/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simpleban;

import com.flummidill.simpleban.BanManager;
import com.flummidill.simpleban.SimpleBan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor {
    private final SimpleBan plugin;
    private final BanManager manager;
    private boolean isConsole = false;

    public CommandHandler(SimpleBan plugin, BanManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd;
        if (sender instanceof ConsoleCommandSender || sender instanceof Player) {
            if (sender instanceof ConsoleCommandSender) {
                this.isConsole = true;
            }
        } else {
            return false;
        }
        switch (cmd = command.getName().toLowerCase()) {
            case "tempban": {
                if (sender.hasPermission("simpleban.tempban") || this.isConsole) {
                    if (args.length < 2) {
                        return false;
                    }
                    UUID targetUUID = this.manager.getOfflinePlayerUUID(args[0]);
                    if (targetUUID == null) {
                        sender.sendMessage("\u00a7cPlayer not found: \u00a7a" + args[0]);
                        return true;
                    }
                    if (this.manager.isBanned(targetUUID)) {
                        sender.sendMessage("\u00a7cPlayer is already banned: \u00a7a" + args[0]);
                        return true;
                    }
                    return this.handleTempBan(sender, args);
                }
                sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                return true;
            }
            case "permban": {
                if (sender.hasPermission("simpleban.permban") || this.isConsole) {
                    if (args.length < 1) {
                        return false;
                    }
                    UUID targetUUID = this.manager.getOfflinePlayerUUID(args[0]);
                    if (targetUUID == null) {
                        sender.sendMessage("\u00a7cPlayer not found: \u00a7a" + args[0]);
                        return true;
                    }
                    if (this.manager.isBanned(targetUUID)) {
                        sender.sendMessage("\u00a7cPlayer is already banned: \u00a7a" + args[0]);
                        return true;
                    }
                    return this.handlePermBan(sender, args);
                }
                sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                return true;
            }
            case "banlist": {
                if (sender.hasPermission("simpleban.banlist") || this.isConsole) {
                    if (args.length != 0) {
                        return false;
                    }
                    return this.handleBanList(sender);
                }
                sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                return true;
            }
            case "baninfo": {
                if (sender.hasPermission("simpleban.baninfo") || this.isConsole) {
                    if (args.length != 1) {
                        return false;
                    }
                    return this.handleBanInfo(sender, args[0]);
                }
                sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                return true;
            }
            case "unban": {
                if (sender.hasPermission("simpleban.unban") || this.isConsole) {
                    if (args.length != 1) {
                        return false;
                    }
                    return this.handleUnBan(sender, args[0]);
                }
                sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                return true;
            }
        }
        return false;
    }

    private boolean handleTempBan(CommandSender sender, String[] args) {
        String targetName = args[0];
        String duration = args[1];
        String reason = args.length > 2 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)) : "None";
        UUID targetUUID = this.manager.getOfflinePlayerUUID(targetName);
        if (targetUUID == null) {
            sender.sendMessage("\u00a7cPlayer not found: \u00a7a" + targetName);
            return true;
        }
        if (!duration.matches("^(?!.*s.*s)(?!.*m.*m)(?!.*h.*h)(?!.*d.*d)(?!.*w.*w)(?!.*y.*y)(\\d{1,4}[smhdwy])+$")) {
            sender.sendMessage("\u00a7cInvalid Duration. Use this Format: \u00a7a'10s' | '2h30m' | '1d12h' | '27w3d45m' | '2w1y3d25h9999s5m'");
            return true;
        }
        this.manager.createBan(targetUUID, "TEMP", sender.getName(), reason, duration);
        Player targetPlayer = Bukkit.getPlayer((UUID)targetUUID);
        if (targetPlayer != null) {
            targetPlayer.kickPlayer(this.manager.getBanMessage(targetPlayer.getUniqueId()).toLegacyText());
        }
        this.manager.sendBanMessage(targetUUID, targetName, sender);
        return true;
    }

    private boolean handlePermBan(CommandSender sender, String[] args) {
        String targetName = args[0];
        String reason = args.length > 1 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length)) : "None";
        UUID targetUUID = this.manager.getOfflinePlayerUUID(targetName);
        if (targetUUID == null) {
            sender.sendMessage("\u00a7cPlayer not found: \u00a7a" + targetName);
            return true;
        }
        this.manager.createBan(targetUUID, "PERM", sender.getName(), reason, "-1");
        Player targetPlayer = Bukkit.getPlayer((UUID)targetUUID);
        if (targetPlayer != null) {
            targetPlayer.kickPlayer(this.manager.getBanMessage(targetPlayer.getUniqueId()).toLegacyText());
        }
        this.manager.sendBanMessage(targetUUID, targetName, sender);
        return true;
    }

    private boolean handleBanList(CommandSender sender) {
        ArrayList<String> bannedPlayers = new ArrayList<String>();
        for (String name : this.manager.getOfflinePlayerNameList()) {
            UUID uuid = this.manager.getOfflinePlayerUUID(name);
            if (uuid == null || !this.manager.isBanned(uuid)) continue;
            bannedPlayers.add(name);
        }
        sender.sendMessage("\u00a7aBanned Players:\n\u00a7c" + (bannedPlayers.isEmpty() ? "None" : String.join((CharSequence)"\n", bannedPlayers)));
        return true;
    }

    private boolean handleBanInfo(CommandSender sender, String targetName) {
        UUID targetUUID = this.manager.getOfflinePlayerUUID(targetName);
        if (targetUUID == null || !this.manager.isBanned(targetUUID)) {
            sender.sendMessage("\u00a7cPlayer is not banned: \u00a7a" + targetName);
            return true;
        }
        String[] info = this.manager.getBanInfo(targetUUID);
        String type = info[0];
        String author = info[1];
        String reason = info[2];
        String expire_time = info[3];
        if (type == null) {
            type = "ERROR";
        }
        if (author == null) {
            author = "ERROR";
        }
        if (reason == null) {
            reason = "ERROR";
        }
        if (expire_time == null) {
            expire_time = "ERROR";
        }
        sender.sendMessage("\u00a7aBan-Info for " + targetName + ":\n\u00a79Type: \u00a7c" + (type.equals("PERM") ? "PERMANENT" : (type.equals("TEMP") ? "TEMPORARY" : type)) + "\n\u00a79Author: \u00a7c" + author + "\n\u00a79Reason: \u00a7c" + reason + "\n\u00a79Expires: \u00a7c" + (expire_time.equals("-1") ? "NEVER" : this.manager.getUnbanTime(expire_time)));
        return true;
    }

    private boolean handleUnBan(CommandSender sender, String targetName) {
        if (targetName.equals("*")) {
            this.manager.removeAllBans();
            this.manager.sendUnBanMessage("Every Player", sender);
            return true;
        }
        UUID targetUUID = this.manager.getOfflinePlayerUUID(targetName);
        if (targetUUID == null) {
            sender.sendMessage("\u00a7cPlayer not found: \u00a7a" + targetName);
            return true;
        }
        if (!this.manager.isBanned(targetUUID)) {
            sender.sendMessage("\u00a7cPlayer is not banned: \u00a7a" + targetName);
            return true;
        }
        this.manager.removeBan(targetUUID);
        this.manager.sendUnBanMessage(targetName, sender);
        return true;
    }
}

