/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simpleban;

import com.flummidill.simpleban.BanManager;
import com.flummidill.simpleban.SimpleBan;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TabCompleter
implements org.bukkit.command.TabCompleter {
    private final SimpleBan plugin;
    private final BanManager manager;

    public TabCompleter(SimpleBan plugin, BanManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (sender instanceof Player) {
            String cmd;
            Player player = (Player)sender;
            UUID uuid = player.getUniqueId();
            this.manager.saveOfflinePlayer(uuid, player.getName());
            switch (cmd = command.getName().toLowerCase()) {
                case "tempban": {
                    return this.autocompleteTempBan(args);
                }
                case "permban": {
                    return this.autocompleteUnBannedPlayers(args);
                }
                case "unban": 
                case "baninfo": {
                    return this.autocompleteBannedPlayers(args);
                }
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private List<String> autocompleteTempBan(String[] args) {
        if (args.length == 1) {
            return this.autocompleteUnBannedPlayers(args);
        }
        if (args.length == 2) {
            return "smhdwy".chars().mapToObj(c -> String.valueOf((char)c)).filter(c -> !args[1].contains((CharSequence)c)).toList();
        }
        return Collections.emptyList();
    }

    private List<String> autocompleteUnBannedPlayers(String[] args) {
        if (args.length == 1) {
            List<String> names = this.manager.getOfflinePlayerNameList().stream().filter(name -> {
                UUID uuid = this.manager.getOfflinePlayerUUID((String)name);
                return uuid != null && !this.manager.isBanned(uuid);
            }).collect(Collectors.toList());
            return this.filterStringsByPrefix(names, args[0]);
        }
        return Collections.emptyList();
    }

    private List<String> autocompleteBannedPlayers(String[] args) {
        if (args.length == 1) {
            List<String> names = this.manager.getOfflinePlayerNameList().stream().filter(name -> {
                UUID uuid = this.manager.getOfflinePlayerUUID((String)name);
                return uuid != null && this.manager.isBanned(uuid);
            }).collect(Collectors.toList());
            return this.filterStringsByPrefix(names, args[0]);
        }
        return Collections.emptyList();
    }

    private List<String> filterStringsByPrefix(List<String> stringList, String prefix) {
        if (prefix == null || prefix.isEmpty() || stringList == null || stringList.isEmpty()) {
            return stringList;
        }
        return stringList.stream().filter(string -> string.toLowerCase().startsWith(prefix.toLowerCase())).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
    }
}

