/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simpleban;

import com.flummidill.libs.json.JSONObject;
import com.flummidill.simpleban.BanManager;
import com.flummidill.simpleban.CommandHandler;
import com.flummidill.simpleban.JoinListener;
import com.flummidill.simpleban.LoginListener;
import com.flummidill.simpleban.TabCompleter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SimpleBan
extends JavaPlugin {
    private BanManager manager;
    private LoginListener loginListener;
    private JoinListener joinListener;

    public void onEnable() {
        this.getLogger().info("~ Created by Flummidill ~");
        this.getLogger().info("Initializing Ban-Manager...");
        this.manager = new BanManager(this);
        this.getLogger().info("Initializing Event Listeners...");
        this.initializeEventListeners();
        this.getLogger().info("Loading Configuration...");
        this.loadConfig();
        this.getLogger().info("Registering Commands...");
        this.registerCommands();
        this.getLogger().info("Removing Expired Bans...");
        this.manager.removeExpiredBans();
        this.getLogger().info("Checking for Updates...");
        this.checkForUpdates();
    }

    public void initializeEventListeners() {
        this.loginListener = new LoginListener(this, this.manager);
        this.getServer().getPluginManager().registerEvents((Listener)this.loginListener, (Plugin)this);
        this.joinListener = new JoinListener(this, this.manager);
        this.getServer().getPluginManager().registerEvents((Listener)this.joinListener, (Plugin)this);
    }

    private void loadConfig() {
        String announceBans = this.getConfig().getString("announce-bans", "Admins");
        String timeZone = this.getConfig().getString("timezone", "UTC");
        String dateFormat = this.getConfig().getString("date-format", "dd/MM/yyyy HH:mm:ss");
        boolean showTimeZone = this.getConfig().getBoolean("show-timezone", true);
        String configVersion = this.getConfig().getString("config-version", "1.0.0");
        String currentVersion = this.getDescription().getVersion();
        this.saveResource("config.yml", true);
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        if (!("Admins".equals(announceBans) || "Players".equals(announceBans) || "Everyone".equals(announceBans) || "No".equals(announceBans))) {
            this.getLogger().warning("Configuration Error: \"announce-bans\" was configured incorrectly and reset to \"Admins\".");
            announceBans = "Admins";
        }
        this.manager.setAnnounceBans(announceBans);
        config.set("announce-bans", (Object)announceBans);
        try {
            ZoneId.of(timeZone);
        }
        catch (DateTimeException e) {
            this.getLogger().warning("Configuration Error: \"timezone\" was configured incorrectly and reset to \"UTC\".");
            timeZone = "UTC";
        }
        this.manager.setTimeZone(timeZone);
        config.set("timezone", (Object)timeZone);
        try {
            LocalDateTime.ofInstant(Instant.now(), ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern(dateFormat));
        }
        catch (DateTimeException e) {
            this.getLogger().warning("Configuration Error: \"date-format\" was configured incorrectly and reset to \"dd/MM/yyyy HH:mm:ss\".");
            dateFormat = "dd/MM/yyyy HH:mm:ss";
        }
        this.manager.setDateFormat(dateFormat);
        config.set("date-format", (Object)dateFormat);
        this.manager.setShowTimeZone(showTimeZone);
        config.set("show-timezone", (Object)showTimeZone);
        if (this.isNewerVersion(configVersion, "1.0.0")) {
            if (this.isOlderVersion(configVersion, currentVersion)) {
                configVersion = currentVersion;
            }
        } else {
            configVersion = currentVersion;
        }
        config.set("config-version", (Object)configVersion);
        this.saveConfig();
    }

    private void registerCommands() {
        CommandHandler commandHandler = new CommandHandler(this, this.manager);
        TabCompleter tabCompleter = new TabCompleter(this, this.manager);
        this.getCommand("tempban").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("permban").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("banlist").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("baninfo").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("unban").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("tempban").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getCommand("permban").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getCommand("banlist").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getCommand("baninfo").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getCommand("unban").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
    }

    private void checkForUpdates() {
        String[] latestVersion = this.getLatestVersion().split("\\|", 2);
        String currentVersion = this.getDescription().getVersion();
        if (!"error".equals(latestVersion[0])) {
            if (this.isNewerVersion(latestVersion[0], currentVersion)) {
                this.getLogger().warning("A new Version of SimpleBan is available: " + latestVersion[0]);
                this.joinListener.setUpdateAvailable(true);
            } else {
                this.getLogger().info("No new Updates available.");
            }
        } else {
            this.getLogger().warning("Failed to Check for Updates!\n" + latestVersion[1]);
        }
    }

    public String getLatestVersion() {
        String apiUrl = "https://api.github.com/repos/Flummidill/SimpleBan/releases/latest";
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpResponse<String> response;
            block10: {
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).header("Accept", "application/json").build();
                try {
                    response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    if (response.statusCode() != 200) break block10;
                    JSONObject json = new JSONObject(response.body());
                    String string = json.getString("tag_name").split("v")[1];
                    return string;
                }
                catch (IOException | InterruptedException e) {
                    this.getLogger().warning("Failed to check for Updates!");
                    StringWriter stackTrace = new StringWriter();
                    e.printStackTrace(new PrintWriter(stackTrace));
                    String string = "error|" + String.valueOf(stackTrace);
                    return string;
                }
            }
            String json = "error|java.net.ConnectException: Connection Failed with Code " + response.statusCode() + "\n        at SimpleGraves.jar//com.flummidill.simpleban.SimpleBan.getLatestVersion(SimpleBan.java)";
            return json;
        }
    }

    public boolean isNewerVersion(String comparingVersion, String referenceVersion) {
        String[] comparingVersionParts = comparingVersion.split("\\.");
        String[] referenceVersionParts = referenceVersion.split("\\.");
        for (int i = 0; i < 3; ++i) {
            int referenceVersionPart;
            int comparingVersionPart = i < comparingVersionParts.length ? Integer.parseInt(comparingVersionParts[i]) : 0;
            int n = referenceVersionPart = i < referenceVersionParts.length ? Integer.parseInt(referenceVersionParts[i]) : 0;
            if (comparingVersionPart > referenceVersionPart) {
                return true;
            }
            if (comparingVersionPart >= referenceVersionPart) continue;
            return false;
        }
        return false;
    }

    public boolean isOlderVersion(String comparingVersion, String referenceVersion) {
        String[] comparingVersionParts = comparingVersion.split("\\.");
        String[] referenceVersionParts = referenceVersion.split("\\.");
        for (int i = 0; i < 3; ++i) {
            int referenceVersionPart;
            int comparingVersionPart = i < comparingVersionParts.length ? Integer.parseInt(comparingVersionParts[i]) : 0;
            int n = referenceVersionPart = i < referenceVersionParts.length ? Integer.parseInt(referenceVersionParts[i]) : 0;
            if (comparingVersionPart < referenceVersionPart) {
                return true;
            }
            if (comparingVersionPart <= referenceVersionPart) continue;
            return false;
        }
        return false;
    }

    public String convertDuration(String input) {
        long totalSeconds = 0L;
        input = input.toLowerCase();
        Pattern pattern = Pattern.compile("(\\d{1,4})([smhdwy])");
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            int value = Integer.parseInt(matcher.group(1));
            char unit = matcher.group(2).charAt(0);
            switch (unit) {
                case 's': {
                    totalSeconds += (long)value;
                    break;
                }
                case 'm': {
                    totalSeconds += (long)value * 60L;
                    break;
                }
                case 'h': {
                    totalSeconds += (long)value * 3600L;
                    break;
                }
                case 'd': {
                    totalSeconds += (long)value * 86400L;
                    break;
                }
                case 'w': {
                    totalSeconds += (long)value * 604800L;
                    break;
                }
                case 'y': {
                    totalSeconds += (long)value * 31536000L;
                }
            }
        }
        return String.valueOf(Instant.now().getEpochSecond() + totalSeconds);
    }
}

