/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.allyeffect.client;

import com.mrbysco.allyeffect.client.Animation;
import com.mrbysco.allyeffect.config.AllyConfig;
import com.mrbysco.allyeffect.registry.AllyRegistry;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class AnimationHandler {
    public static void animatePlayer(LivingEntity livingEntity, HumanoidModel<?> humanoidModel, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!(humanoidModel instanceof PlayerModel)) {
            return;
        }
        PlayerModel playerModel = (PlayerModel)humanoidModel;
        if (!livingEntity.m_21023_((MobEffect)AllyRegistry.ALLY.get())) {
            return;
        }
        Animation animation = (Animation)((Object)AllyConfig.CLIENT.effectAnimation.get());
        switch (animation) {
            case EVOCATION: {
                AnimationHandler.animateEvocation(playerModel, player, ageInTicks);
                break;
            }
            case DANCE: {
                AnimationHandler.animateDance(playerModel, player, ageInTicks);
                break;
            }
            default: {
                AnimationHandler.animateHug(playerModel, player, ageInTicks);
            }
        }
    }

    private static void animateHug(PlayerModel<?> playerModel, Player player, float ageInTicks) {
        AnimationUtils.m_102102_((ModelPart)playerModel.f_102812_, (ModelPart)playerModel.f_102811_, (boolean)false, (float)0.0f, (float)ageInTicks);
    }

    private static void animateDance(PlayerModel<?> playerModel, Player player, float ageInTicks) {
        float f3 = ageInTicks / 60.0f;
        playerModel.f_102808_.f_104200_ = Mth.m_14031_((float)(f3 * 10.0f));
        playerModel.f_102808_.f_104201_ = Mth.m_14031_((float)(f3 * 40.0f)) + 0.4f;
        playerModel.f_102811_.f_104205_ = (float)Math.PI / 180 * (70.0f + Mth.m_14089_((float)(f3 * 40.0f)) * 10.0f);
        playerModel.f_102812_.f_104205_ = playerModel.f_102811_.f_104205_ * -1.0f;
        playerModel.f_102811_.f_104201_ = Mth.m_14031_((float)(f3 * 40.0f)) * 0.5f + 1.5f;
        playerModel.f_102812_.f_104201_ = Mth.m_14031_((float)(f3 * 40.0f)) * 0.5f + 1.5f;
        playerModel.f_102810_.f_104201_ = Mth.m_14031_((float)(f3 * 40.0f)) * 0.35f;
    }

    private static void animateEvocation(PlayerModel<?> playerModel, Player player, float ageInTicks) {
        playerModel.f_102811_.f_104202_ = 0.0f;
        playerModel.f_102811_.f_104200_ = -5.0f;
        playerModel.f_102812_.f_104202_ = 0.0f;
        playerModel.f_102812_.f_104200_ = 5.0f;
        playerModel.f_102811_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
        playerModel.f_102812_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
        playerModel.f_102811_.f_104205_ = 2.3561945f;
        playerModel.f_102812_.f_104205_ = -2.3561945f;
        playerModel.f_102811_.f_104204_ = 0.0f;
        playerModel.f_102812_.f_104204_ = 0.0f;
    }
}

