/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.allyeffect.network.message;

import com.mrbysco.allyeffect.handler.EffectHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class AllyEffectMessage {
    private final boolean active;

    public AllyEffectMessage(boolean active) {
        this.active = active;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.active);
    }

    public static AllyEffectMessage decode(FriendlyByteBuf packetBuffer) {
        return new AllyEffectMessage(packetBuffer.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isServer() && ctx.getSender() != null) {
                ServerPlayer serverPlayer = ctx.getSender();
                EffectHandler.setAllyActive(serverPlayer.m_20148_(), this.active);
            }
        });
        ctx.setPacketHandled(true);
    }
}

