/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.allyeffect.handler;

import com.mrbysco.allyeffect.config.AllyConfig;
import com.mrbysco.allyeffect.effect.AllyEffect;
import com.mrbysco.allyeffect.registry.AllyRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EffectHandler {
    private static final List<UUID> activeAllies = new ArrayList<UUID>();

    public static boolean isAllyActive(UUID playerUUID) {
        return activeAllies.contains(playerUUID);
    }

    public static boolean isAllyActive(Player player) {
        return EffectHandler.isAllyActive(player.m_20148_());
    }

    public static void setAllyActive(UUID playerUUID, boolean isActive) {
        if (isActive) {
            if (!activeAllies.contains(playerUUID)) {
                activeAllies.add(playerUUID);
            }
        } else {
            activeAllies.remove(playerUUID);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side.isServer()) {
            Level level;
            Player player = event.player;
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CompoundTag persistentData = player.getPersistentData();
            if (persistentData.m_128471_("allyeffectDisabled")) {
                EffectHandler.setAllyActive(player.m_20148_(), false);
            }
            if (!activeAllies.isEmpty() && EffectHandler.isAllyActive(player) && (level = player.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                List nearbyEntities = serverLevel.m_45971_(LivingEntity.class, AllyEffect.receiverCondition.m_26883_((double)((Integer)AllyConfig.COMMON.effectRange.get()).intValue()), (LivingEntity)player, player.m_20191_().m_82400_((double)((Integer)AllyConfig.COMMON.effectRange.get()).intValue()));
                if (nearbyEntities.isEmpty() && ((Boolean)AllyConfig.COMMON.activateOnlyInRange.get()).booleanValue()) {
                    return;
                }
                MobEffectInstance instance = new MobEffectInstance((MobEffect)AllyRegistry.ALLY.get(), 20, 0, true, false);
                player.m_147207_(instance, (Entity)player);
            }
        }
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        MobEffectInstance instance = event.getEffectInstance();
        LivingEntity effectEntity = event.getEntity();
        if (effectEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)effectEntity;
            if (instance.m_19544_() == AllyRegistry.ALLY.get()) {
                ServerLevel serverLevel = serverPlayer.m_284548_();
                for (Entity entity : serverLevel.m_142646_().m_142273_()) {
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer otherPlayer = (ServerPlayer)entity;
                    otherPlayer.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(serverPlayer.m_19879_(), instance));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEffectRemove(MobEffectEvent.Remove event) {
        MobEffectInstance instance = event.getEffectInstance();
        LivingEntity effectEntity = event.getEntity();
        if (effectEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)effectEntity;
            if (instance.m_19544_() == AllyRegistry.ALLY.get()) {
                ServerLevel serverLevel = serverPlayer.m_284548_();
                for (Entity entity : serverLevel.m_142646_().m_142273_()) {
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer otherPlayer = (ServerPlayer)entity;
                    otherPlayer.f_8906_.m_9829_((Packet)new ClientboundRemoveMobEffectPacket(serverPlayer.m_19879_(), (MobEffect)AllyRegistry.ALLY.get()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance instance = event.getEffectInstance();
        LivingEntity effectEntity = event.getEntity();
        if (effectEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)effectEntity;
            if (instance.m_19544_() == AllyRegistry.ALLY.get()) {
                ServerLevel serverLevel = serverPlayer.m_284548_();
                for (Entity entity : serverLevel.m_142646_().m_142273_()) {
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer otherPlayer = (ServerPlayer)entity;
                    otherPlayer.f_8906_.m_9829_((Packet)new ClientboundRemoveMobEffectPacket(serverPlayer.m_19879_(), (MobEffect)AllyRegistry.ALLY.get()));
                }
            }
        }
    }
}

