/*
 * Decompiled with CFR 0.152.
 */
package arda.hisea;

import arda.hisea.Hisea;
import arda.hisea.ModBlocks;
import arda.hisea.block.ArdaMistBlock;
import arda.hisea.block.ArdaMistBlockEntityRenderer;
import arda.hisea.block.entity.ArdaMistBlockEntity;
import arda.hisea.core.EffectiveConfig;
import arda.hisea.core.particle.particle.types.MistParticleType;
import arda.hisea.gui.MistConfigScreen;
import arda.hisea.gui.MistSettings;
import arda.hisea.networking.ClientMistNetworking;
import arda.hisea.networking.MistNetworking;
import java.awt.Color;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientBlockEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_3999;
import net.minecraft.class_437;
import net.minecraft.class_5616;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

@Environment(value=EnvType.CLIENT)
public class HiseaClient
implements ClientModInitializer {
    private static final class_304 RESET_SETTINGS_KEY = new class_304("key.hisea.reset_cache", 67, "key.categories.hisea");
    private static final class_304 LOG_SETTINGS_KEY = new class_304("key.hisea.log_cache", 76, "key.categories.hisea");
    public static LodestoneWorldParticleType MIST = new MistParticleType();
    private static boolean DEBUG_PARTICLES = false;
    private static final Color WHITE = new Color(0xFFFFFF);

    private static boolean isDefaultSettings(ArdaMistBlockEntity blockEntity) {
        return blockEntity.getMistIntensity() == 1.0f && blockEntity.getMistVelocity() == 1.0f && blockEntity.getMistLifetime() == 300 && blockEntity.getMistColor() == 0xFFFFFF && blockEntity.getMistTransparency() == 1.0f && blockEntity.getMistRadius() == 3;
    }

    public static class_2960 id(String path) {
        return new class_2960("hisea", path);
    }

    public void onInitializeClient() {
        KeyBindingHelper.registerKeyBinding((class_304)RESET_SETTINGS_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)LOG_SETTINGS_KEY);
        ParticleFactoryRegistry.getInstance().register((class_2396)MIST, MistParticleType.Factory::new);
        MIST = (LodestoneWorldParticleType)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)HiseaClient.id("mist"), (Object)MIST);
        class_5616.method_32144(ModBlocks.ARDA_MIST_BLOCK_ENTITY, ArdaMistBlockEntityRenderer::new);
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.ARDA_MIST, class_1921.method_23583());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)MistNetworking.SYNC_MIST_SETTINGS, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            float intensity = buf.readFloat();
            int lifetime = buf.readInt();
            float velocity = buf.readFloat();
            boolean enabled = buf.readBoolean();
            int color = buf.readInt();
            float transparency = buf.readFloat();
            int radius = buf.readInt();
            client.execute(() -> {
                class_2586 be;
                MistSettings.saveFullSettingsWithColor(pos, intensity, enabled, velocity, lifetime, color, transparency, radius);
                Hisea.LOGGER.info("[Hisea] Received settings sync from server for block at {}: intensity={}, velocity={}, lifetime={}, color=#{}, transparency={}, radius={}, enabled={}", new Object[]{pos, Float.valueOf(intensity), Float.valueOf(velocity), lifetime, Integer.toHexString(color), Float.valueOf(transparency), radius, enabled});
                if (client.field_1687 != null && (be = client.field_1687.method_8321(pos)) instanceof ArdaMistBlockEntity) {
                    ArdaMistBlockEntity mistBE = (ArdaMistBlockEntity)be;
                    mistBE.setMistIntensity(intensity);
                    mistBE.setMistVelocity(velocity);
                    mistBE.setMistLifetime(lifetime);
                    mistBE.setMistEnabled(enabled);
                    mistBE.setMistColor(color);
                    mistBE.setMistTransparency(transparency);
                    mistBE.setMistRadius(radius);
                    client.field_1687.method_8413(pos, client.field_1687.method_8320(pos), client.field_1687.method_8320(pos), 3);
                }
            });
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            Hisea.LOGGER.info("[Hisea] Client joined game, logging last used mist settings");
            MistSettings.resetAllSettings();
            MistSettings.logAllSettings();
            client.execute(() -> new Thread(() -> {
                try {
                    Thread.sleep(2000L);
                    client.execute(() -> {
                        if (client.field_1724 != null && client.field_1687 != null) {
                            Hisea.LOGGER.info("[Hisea] Triggering resync of all nearby mist blocks");
                            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7b[Hisea] Synchronizing mist block settings from server..."), false);
                            class_2338 playerPos = client.field_1724.method_24515();
                            int range = 8;
                            for (int chunkX = (playerPos.method_10263() >> 4) - range; chunkX <= (playerPos.method_10263() >> 4) + range; ++chunkX) {
                                for (int chunkZ = (playerPos.method_10260() >> 4) - range; chunkZ <= (playerPos.method_10260() >> 4) + range; ++chunkZ) {
                                    if (!client.field_1687.method_8393(chunkX, chunkZ)) continue;
                                    client.field_1687.method_22336().method_15513(new class_2338(chunkX << 4, 0, chunkZ << 4));
                                }
                            }
                            Hisea.LOGGER.info("[Hisea] Scheduling scan for mist blocks after world loads");
                            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7b[Hisea] Initializing mist synchronization..."), false);
                            ScanTickHandler scanHandler = new ScanTickHandler();
                            ClientTickEvents.START_CLIENT_TICK.register((Object)scanHandler);
                            if (client.field_1687 != null) {
                                int scanRadius = 4;
                                class_2338 playerPosition = playerPos;
                                for (int x = playerPosition.method_10263() - scanRadius * 16; x < playerPosition.method_10263() + scanRadius * 16; x += 16) {
                                    for (int z = playerPosition.method_10260() - scanRadius * 16; z < playerPosition.method_10260() + scanRadius * 16; z += 16) {
                                        for (int y = 60; y < 120; y += 8) {
                                            class_2586 be;
                                            class_2338 checkPos = new class_2338(x, y, z);
                                            if (!client.field_1687.method_8393(checkPos.method_10263() >> 4, checkPos.method_10260() >> 4) || !((be = client.field_1687.method_8321(checkPos)) instanceof ArdaMistBlockEntity)) continue;
                                            Hisea.LOGGER.info("[Hisea] Found mist block entity at {}, requesting settings from server", (Object)checkPos);
                                            ClientMistNetworking.requestMistSettings(checkPos);
                                        }
                                    }
                                }
                            }
                            Hisea.LOGGER.info("[Hisea] Initial scan complete, continuing background scan");
                            MistSettings.markPostInitialLoad();
                            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a[Hisea] Mist block settings synchronized from server"), false);
                        }
                    });
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start());
        });
        ClientBlockEntityEvents.BLOCK_ENTITY_LOAD.register((blockEntity, world) -> {
            if (blockEntity instanceof ArdaMistBlockEntity) {
                ArdaMistBlockEntity mistBlockEntity = (ArdaMistBlockEntity)blockEntity;
                class_2338 pos = blockEntity.method_11016();
                boolean isDefault = HiseaClient.isDefaultSettings(mistBlockEntity);
                if (MistSettings.isInitialWorldLoad() || isDefault) {
                    Hisea.LOGGER.info("[Hisea] Block entity load: requesting settings for {} from server", (Object)pos);
                    ClientMistNetworking.requestMistSettings(pos);
                } else {
                    float blockIntensity = mistBlockEntity.getMistIntensity();
                    float blockVelocity = mistBlockEntity.getMistVelocity();
                    int blockLifetime = mistBlockEntity.getMistLifetime();
                    boolean blockEnabled = mistBlockEntity.isMistEnabled();
                    int blockColor = mistBlockEntity.getMistColor();
                    float blockTransparency = mistBlockEntity.getMistTransparency();
                    int blockRadius = mistBlockEntity.getMistRadius();
                    MistSettings.saveFullSettingsWithColor(pos, blockIntensity, blockEnabled, blockVelocity, blockLifetime, blockColor, blockTransparency, blockRadius);
                    Hisea.LOGGER.info("[Hisea] Synchronized block entity settings to client cache for mist block at {}: intensity={}, velocity={}, lifetime={}, color=#{}, transparency={}, radius={}, enabled={}", new Object[]{pos, Float.valueOf(blockIntensity), Float.valueOf(blockVelocity), blockLifetime, Integer.toHexString(blockColor), Float.valueOf(blockTransparency), blockRadius, blockEnabled});
                    Hisea.LOGGER.info("[Hisea] Block entity loaded at {}, requesting settings refresh from server", (Object)pos);
                    ClientMistNetworking.requestMistSettings(pos);
                    if (!MistSettings.hasRecentUpdate(pos) && isDefault) {
                        Hisea.LOGGER.info("[Hisea] New mist block detected at {}, applying last used settings", (Object)pos);
                        MistSettings.applyLastUsedSettings(pos, mistBlockEntity);
                        ClientMistNetworking.sendFullMistSettingsUpdate(pos, MistSettings.getLastUsedIntensity(), MistSettings.getLastUsedVelocity(), MistSettings.getLastUsedLifetime(), MistSettings.getLastUsedEnabled(), MistSettings.getLastUsedColor(), MistSettings.getLastUsedTransparency());
                        if (class_310.method_1551().field_1724 != null) {
                            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a7b[Hisea] Applied previous settings to new mist block (Color: #%06X, Transparency: %d%%)", MistSettings.getLastUsedColor(), (int)(MistSettings.getLastUsedTransparency() * 100.0f))), false);
                        }
                    }
                }
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null && client.field_1724 != null && !client.method_1493()) {
                class_2338 hitPos;
                class_2680 hitState;
                boolean isCtrlPressed;
                class_638 world = client.field_1687;
                if (client.field_1724.method_5715() && RESET_SETTINGS_KEY.method_1436()) {
                    MistSettings.resetAllSettings();
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7l[Hisea] Reset all client cached settings!"), false);
                }
                if (client.field_1724.method_5715() && LOG_SETTINGS_KEY.method_1436()) {
                    MistSettings.logAllSettings();
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7b\u00a7l[Hisea] Logged all client cached settings to console!"), false);
                }
                boolean bl = isCtrlPressed = class_3675.method_15987((long)client.method_22683().method_4490(), (int)341) || class_3675.method_15987((long)client.method_22683().method_4490(), (int)345);
                if (isCtrlPressed && client.field_1690.field_1904.method_1434() && client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1332 && (hitState = world.method_8320(hitPos = ((class_3965)client.field_1765).method_17777())).method_27852(ModBlocks.ARDA_MIST)) {
                    if (ArdaMistBlock.isPlayerHoldingMistBlock((class_1657)client.field_1724)) {
                        Hisea.LOGGER.info("[Hisea] Player is looking at arda_mist block while pressing CTRL + use key and holding mist block");
                        if (hitState.method_26204() instanceof ArdaMistBlock) {
                            ArdaMistBlockEntity blockEntity = ArdaMistBlock.getBlockEntity((class_1937)world, hitPos);
                            if (blockEntity != null) {
                                client.method_1507((class_437)new MistConfigScreen(blockEntity, hitPos));
                                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a\u00a7l[Hisea] Opening mist config from tick event"), false);
                            } else {
                                Hisea.LOGGER.error("[Hisea] Failed to open config: Block entity not found at {}", (Object)hitPos);
                                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7l[Hisea] Error: Could not find block data"), false);
                            }
                        }
                    } else {
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7e\u00a7l[Hisea] You must be holding a mist block to configure it"), false);
                    }
                }
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null || client.field_1687 == null || !client.field_1724.method_5805() || !ArdaMistBlock.isPlayerHoldingMistBlock((class_1657)client.field_1724)) {
                return;
            }
            class_2338 playerPos = client.field_1724.method_24515();
            int radius = 16;
            int sectionX = (int)(client.field_1687.method_8510() % 4L);
            int sectionZ = (int)(client.field_1687.method_8510() / 4L % 4L);
            int sectionY = (int)(client.field_1687.method_8510() / 16L % 4L);
            int startX = -radius + sectionX * (radius / 2);
            int endX = startX + radius / 2;
            int startZ = -radius + sectionZ * (radius / 2);
            int endZ = startZ + radius / 2;
            int startY = -radius + sectionY * (radius / 2);
            int endY = startY + radius / 2;
            for (int x = startX; x <= endX; ++x) {
                for (int z = startZ; z <= endZ; ++z) {
                    for (int y = startY; y <= endY; ++y) {
                        class_2338 pos = playerPos.method_10069(x, y, z);
                        if (!client.field_1687.method_8393(pos.method_10263() >> 4, pos.method_10260() >> 4) || client.field_1687.method_8320(pos).method_26204() != ModBlocks.ARDA_MIST) continue;
                        class_2388 barrierEffect = new class_2388(class_2398.field_35434, class_2246.field_10499.method_9564());
                        client.field_1687.method_8406((class_2394)barrierEffect, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 0.0, 0.0, 0.0);
                    }
                }
            }
        });
        Hisea.LOGGER.info("[Hisea] HiseaClient initialized!");
    }

    public static void spawnMist(class_1937 world, class_2338 pos) {
        HiseaClient.spawnMist(world, pos, 1.0f);
    }

    public static void spawnMist(class_1937 world, class_2338 pos, float intensity) {
        HiseaClient.spawnMist(world, pos, intensity, "unknown");
    }

    private static Color intToColor(int rgb) {
        return new Color(rgb);
    }

    public static void spawnMist(class_1937 world, class_2338 pos, float intensity, String source) {
        class_638 clientWorld;
        class_2586 be;
        Integer cachedRadius;
        Float cachedTransparency;
        ArdaMistBlockEntity mistBE;
        class_638 clientWorld2;
        class_2586 be2;
        Boolean cachedEnabled;
        if (MistSettings.hasSettings(pos) && (cachedEnabled = MistSettings.isEnabled(pos)) != null && !cachedEnabled.booleanValue()) {
            if (DEBUG_PARTICLES) {
                Hisea.LOGGER.debug("[Hisea] Not spawning mist - disabled in client cache at {}", (Object)pos);
            }
            return;
        }
        if (world instanceof class_638 && (be2 = (clientWorld2 = (class_638)world).method_8321(pos)) instanceof ArdaMistBlockEntity && !(mistBE = (ArdaMistBlockEntity)be2).isMistEnabled()) {
            if (DEBUG_PARTICLES) {
                Hisea.LOGGER.debug("[Hisea] Not spawning mist - disabled in BlockEntity at {}", (Object)pos);
            }
            return;
        }
        if (intensity <= 0.0f) {
            if (DEBUG_PARTICLES) {
                Hisea.LOGGER.debug("[Hisea] Not spawning mist - intensity <= 0 at {}", (Object)pos);
            }
            return;
        }
        if (DEBUG_PARTICLES) {
            Hisea.LOGGER.debug("[Hisea] Spawning mist at {} with intensity={}", (Object)pos, (Object)Float.valueOf(intensity));
        }
        float velocityMultiplier = 1.0f;
        int customLifetime = 300;
        int customColor = 0xFFFFFF;
        float customTransparency = 1.0f;
        int customRadius = 3;
        Integer cachedColor = MistSettings.getColor(pos);
        if (cachedColor != null) {
            customColor = cachedColor;
        }
        if ((cachedTransparency = MistSettings.getTransparency(pos)) != null) {
            customTransparency = cachedTransparency.floatValue();
        }
        if ((cachedRadius = MistSettings.getRadius(pos)) != null) {
            customRadius = cachedRadius;
        }
        if (world instanceof class_638 && (be = (clientWorld = (class_638)world).method_8321(pos)) instanceof ArdaMistBlockEntity) {
            ArdaMistBlockEntity mistBE2 = (ArdaMistBlockEntity)be;
            velocityMultiplier = mistBE2.getMistVelocity();
            customLifetime = mistBE2.getMistLifetime();
            if (cachedColor == null) {
                customColor = mistBE2.getMistColor();
            }
            if (cachedTransparency == null) {
                customTransparency = mistBE2.getMistTransparency();
            }
            if (cachedRadius == null) {
                customRadius = mistBE2.getMistRadius();
            }
        }
        int i = 0;
        while ((float)i < EffectiveConfig.cascadeCloudDensity) {
            double offsetX = world.method_8409().method_43059() / 5.0;
            double offsetZ = world.method_8409().method_43059() / 5.0;
            Color particleColor = HiseaClient.intToColor(customColor);
            double radiusScale = (double)customRadius / 3.0;
            double scaledOffsetX = offsetX * radiusScale;
            double scaledOffsetZ = offsetZ * radiusScale;
            WorldParticleBuilder.create((LodestoneWorldParticleType)MIST).enableForcedSpawn().enableNoClip().setLightLevel(-1).setScaleData(GenericParticleData.create((float)((0.4f + intensity * world.field_9229.method_43057()) * ((float)customRadius / 3.0f))).build()).setColorData(ColorParticleData.create((Color)particleColor).build()).setTransparencyData(GenericParticleData.create((float)0.001f, (float)(0.7f * customTransparency), (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_OUT).build()).setLifetime(10).setRenderType((class_3999)LodestoneWorldParticleRenderType.TRANSPARENT.withDepthFade()).setMotion(velocityMultiplier == 0.0f ? 0.0 : (double)(world.method_8409().method_43057() * 0.01f) * Math.signum(scaledOffsetX) * (double)velocityMultiplier, velocityMultiplier == 0.0f ? 0.0 : (double)(world.method_8409().method_43057() * 0.005f * velocityMultiplier), velocityMultiplier == 0.0f ? 0.0 : (double)(world.method_8409().method_43057() * 0.01f) * Math.signum(scaledOffsetZ) * (double)velocityMultiplier).spawn(world, (double)pos.method_10263() + 0.5 + scaledOffsetX, (double)((float)pos.method_10264() + world.method_8409().method_43057()), (double)pos.method_10260() + 0.5 + scaledOffsetZ);
            ++i;
        }
        if (world.field_9229.method_43057() * 100.0f <= EffectiveConfig.cascadeMistDensity) {
            double offsetX = world.method_8409().method_43059() / 5.0;
            double offsetZ = world.method_8409().method_43059() / 5.0;
            double radiusScale = (double)customRadius / 3.0;
            double scaledOffsetX = offsetX * radiusScale;
            double scaledOffsetZ = offsetZ * radiusScale;
            double x = (float)pos.method_10263() + 0.5f;
            double y = (float)pos.method_10264() + 0.5f;
            double z = (float)pos.method_10260() + 0.5f;
            float baseScale = 10.0f + world.method_8409().method_43057() * 5.0f;
            float scale = baseScale * intensity * ((float)customRadius / 3.0f);
            float maxAlpha = 0.1f * intensity * customTransparency;
            int lifetime = (int)((float)customLifetime * intensity);
            Color particleColor = HiseaClient.intToColor(customColor);
            WorldParticleBuilder.create((LodestoneWorldParticleType)MIST).enableForcedSpawn().setSpinData(SpinParticleData.create((float)((world.method_8409().method_43057() - world.method_8409().method_43057()) / 20.0f)).build()).setScaleData(GenericParticleData.create((float)scale).build()).setTransparencyData(GenericParticleData.create((float)0.001f, (float)(0.7f * customTransparency), (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_OUT).build()).setLifetime(lifetime).enableNoClip().setNaturalLighting().setRenderType((class_3999)LodestoneWorldParticleRenderType.TRANSPARENT.withDepthFade()).setColorData(ColorParticleData.create((Color)particleColor, (Color)particleColor).build()).setMotion(velocityMultiplier == 0.0f ? 0.0 : (double)(world.method_8409().method_43057() * 0.01f) * Math.signum(offsetX) * (double)velocityMultiplier, velocityMultiplier == 0.0f ? 0.0 : (double)(world.method_8409().method_43057() * 0.005f * velocityMultiplier), velocityMultiplier == 0.0f ? 0.0 : (double)(world.method_8409().method_43057() * 0.01f) * Math.signum(offsetZ) * (double)velocityMultiplier).spawn(world, x, y, z);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ScanTickHandler
    implements ClientTickEvents.StartTick {
        private int tickCount = 0;
        private final int SCAN_DELAY_TICKS = 40;
        private boolean hasRun = false;

        private ScanTickHandler() {
        }

        public void onStartTick(class_310 client) {
            if (this.hasRun) {
                return;
            }
            if (this.tickCount < 40) {
                ++this.tickCount;
                return;
            }
            this.hasRun = true;
            if (client.field_1724 == null || client.field_1687 == null) {
                return;
            }
            Hisea.LOGGER.info("[Hisea] Running delayed scan for mist blocks");
            class_2338 playerPos = client.field_1724.method_24515();
            int scanRadius = 8;
            for (int r = 1; r <= scanRadius; ++r) {
                for (int x = -r; x <= r; ++x) {
                    for (int z = -r; z <= r; ++z) {
                        int chunkZ;
                        int chunkX;
                        if (Math.abs(x) != r && Math.abs(z) != r || !client.field_1687.method_8393(chunkX = (playerPos.method_10263() >> 4) + x, chunkZ = (playerPos.method_10260() >> 4) + z)) continue;
                        for (int y = 60; y < 120; y += 8) {
                            class_2338 checkPos = new class_2338((chunkX << 4) + 8, y, (chunkZ << 4) + 8);
                            class_2680 blockState = client.field_1687.method_8320(checkPos);
                            if (!(blockState.method_26204() instanceof ArdaMistBlock)) continue;
                            Hisea.LOGGER.info("[Hisea] Found mist block at {}, requesting settings from server", (Object)checkPos);
                            ClientMistNetworking.requestMistSettings(checkPos);
                        }
                    }
                }
            }
            if (client.field_1724 != null) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a[Hisea] Mist block synchronization complete"), false);
            }
        }
    }
}

