/*
 * Decompiled with CFR 0.152.
 */
package arda.hisea.block;

import arda.hisea.Hisea;
import arda.hisea.HiseaClient;
import arda.hisea.block.ArdaMistBlock;
import arda.hisea.block.entity.ArdaMistBlockEntity;
import arda.hisea.gui.MistConfigScreen;
import arda.hisea.gui.MistSettings;
import arda.hisea.networking.ClientMistNetworking;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

@Environment(value=EnvType.CLIENT)
public class ArdaMistBlockClient
extends ArdaMistBlock {
    public ArdaMistBlockClient(class_4970.class_2251 settings) {
        super(settings);
    }

    @Override
    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        if (ArdaMistBlock.isPlayerHoldingMistBlock(player)) {
            return super.method_9594(state, player, world, pos);
        }
        return 0.0f;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        boolean enabled;
        float intensity;
        Boolean cachedEnabled;
        if (!world.field_9236) {
            return;
        }
        ArdaMistBlockEntity blockEntity = ArdaMistBlockClient.getBlockEntity(world, pos);
        if (blockEntity == null) {
            return;
        }
        boolean hasSettingsInCache = MistSettings.hasSettings(pos);
        boolean hasRecentUpdate = MistSettings.hasRecentUpdate(pos);
        if (!hasSettingsInCache || !hasRecentUpdate && blockEntity.getMistIntensity() == 1.0f && blockEntity.getMistVelocity() == 1.0f && blockEntity.getMistLifetime() == 300 && blockEntity.getMistColor() == 0xFFFFFF && blockEntity.getMistTransparency() == 1.0f && blockEntity.getMistRadius() == 3) {
            Hisea.LOGGER.info("[Hisea] Detected possible chunk reload for mist block at {}, requesting settings", (Object)pos);
            ClientMistNetworking.requestMistSettings(pos);
            if (!hasSettingsInCache) {
                MistSettings.saveFullSettingsWithColor(pos, blockEntity.getMistIntensity(), blockEntity.isMistEnabled(), blockEntity.getMistVelocity(), blockEntity.getMistLifetime(), blockEntity.getMistColor(), blockEntity.getMistTransparency(), blockEntity.getMistRadius());
            }
        }
        if (MistSettings.hasSettings(pos) && (cachedEnabled = MistSettings.isEnabled(pos)) != null && !cachedEnabled.booleanValue()) {
            return;
        }
        if (MistSettings.hasSettings(pos)) {
            Float cachedIntensity = MistSettings.getIntensity(pos);
            Boolean cachedEnabledState = MistSettings.isEnabled(pos);
            if (cachedIntensity != null && cachedEnabledState != null) {
                intensity = cachedIntensity.floatValue();
                enabled = cachedEnabledState;
            } else {
                intensity = blockEntity.getMistIntensity();
                enabled = blockEntity.isMistEnabled();
                MistSettings.saveSettings(pos, intensity, enabled);
            }
        } else {
            intensity = blockEntity.getMistIntensity();
            enabled = blockEntity.isMistEnabled();
            MistSettings.saveSettings(pos, intensity, enabled);
        }
        if (enabled && random.method_43048(4) == 0) {
            HiseaClient.spawnMist(world, pos, intensity, "randomDisplayTick");
            if (intensity > 1.0f && random.method_43048(4) == 0) {
                HiseaClient.spawnMist(world, pos, intensity);
            }
            if (intensity > 2.0f && random.method_43048(4) == 0) {
                HiseaClient.spawnMist(world, pos, intensity);
            }
            if (intensity > 3.0f && random.method_43048(4) == 0) {
                HiseaClient.spawnMist(world, pos, intensity);
            }
            if (intensity > 4.0f && random.method_43048(4) == 0) {
                HiseaClient.spawnMist(world, pos, intensity);
            }
        }
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        ArdaMistBlockEntity finalBlockEntity;
        if (!world.field_9236) {
            return super.method_9534(state, world, pos, player, hand, hit);
        }
        ArdaMistBlockEntity blockEntity = ArdaMistBlockClient.getBlockEntity(world, pos);
        if (blockEntity == null) {
            return class_1269.field_5814;
        }
        if (class_310.method_1551().field_1687 != null) {
            class_310.method_1551().field_1687.method_8413(pos, state, state, 3);
        }
        if ((finalBlockEntity = ArdaMistBlockClient.getBlockEntity(world, pos)) == null) {
            return class_1269.field_5814;
        }
        class_2338 finalPos = pos.method_10062();
        class_310 client = class_310.method_1551();
        client.execute(() -> client.method_1507((class_437)new MistConfigScreen(finalBlockEntity, finalPos)));
        return class_1269.field_5812;
    }
}

