/*
 * Decompiled with CFR 0.152.
 */
package arda.hisea.block.entity;

import arda.hisea.Hisea;
import arda.hisea.ModBlocks;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;

public class ArdaMistBlockEntity
extends class_2586 {
    private static final String INTENSITY_KEY = "MistIntensity";
    private static final String RADIUS_KEY = "MistRadius";
    private static final String ENABLED_KEY = "MistEnabled";
    private static final String LIFETIME_KEY = "MistLifetime";
    private static final String VELOCITY_KEY = "MistVelocity";
    private static final String COLOR_KEY = "MistColor";
    private static final String TRANSPARENCY_KEY = "MistTransparency";
    private float mistIntensity = 1.0f;
    private int mistRadius = 3;
    private boolean mistEnabled = true;
    private int mistLifetime = 300;
    private float mistVelocity = 1.0f;
    private int mistColor = 0xFFFFFF;
    private float mistTransparency = 1.0f;
    public boolean mistTicked = false;

    public ArdaMistBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.ARDA_MIST_BLOCK_ENTITY, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, ArdaMistBlockEntity be) {
        if (world.field_9236) {
            be.mistTicked = false;
        }
        if (!world.field_9236 && world.method_8510() % 200L == 0L) {
            be.method_5431();
            if (world.method_8409().method_43048(20) == 0) {
                Hisea.LOGGER.info("[Hisea] BlockEntity tick at {} with settings: intensity={}, radius={}, enabled={}", new Object[]{pos, Float.valueOf(be.mistIntensity), be.mistRadius, be.mistEnabled});
            }
            if (world.method_8409().method_43048(40) == 0) {
                world.method_8413(pos, state, state, 3);
                Hisea.LOGGER.info("[Hisea] Server: Periodic resync of settings for block at {}", (Object)pos);
            }
        }
        if (world.field_9236 && world.method_8510() % 400L == 0L && world.method_8409().method_43048(20) == 0) {
            Hisea.LOGGER.info("[Hisea] Client-side BlockEntity at {} has: intensity={}, enabled={}", new Object[]{pos, Float.valueOf(be.mistIntensity), be.mistEnabled});
        }
    }

    public float getMistIntensity() {
        return this.mistIntensity;
    }

    public void setMistIntensity(float intensity) {
        if (this.mistIntensity != intensity) {
            this.mistIntensity = intensity;
            this.forceSave();
            Hisea.LOGGER.info("[Hisea] BlockEntity at {} updated intensity to {}", (Object)this.method_11016(), (Object)Float.valueOf(this.mistIntensity));
        }
    }

    public int getMistRadius() {
        return this.mistRadius;
    }

    public void setMistRadius(int radius) {
        if (this.mistRadius != radius) {
            this.mistRadius = Math.max(1, Math.min(20, radius));
            this.forceSave();
            Hisea.LOGGER.info("[Hisea] BlockEntity at {} updated radius to {}", (Object)this.method_11016(), (Object)this.mistRadius);
        }
    }

    public int getMistLifetime() {
        return this.mistLifetime;
    }

    public void setMistLifetime(int lifetime) {
        if (this.mistLifetime != lifetime) {
            this.mistLifetime = Math.max(100, Math.min(1200, lifetime));
            this.forceSave();
            Hisea.LOGGER.info("[Hisea] BlockEntity at {} updated lifetime to {} ticks", (Object)this.method_11016(), (Object)this.mistLifetime);
        }
    }

    public float getMistVelocity() {
        return this.mistVelocity;
    }

    public void setMistVelocity(float velocity) {
        if (this.mistVelocity != velocity) {
            this.mistVelocity = Math.max(0.1f, Math.min(3.0f, velocity));
            this.forceSave();
            Hisea.LOGGER.info("[Hisea] BlockEntity at {} updated velocity to {}", (Object)this.method_11016(), (Object)Float.valueOf(this.mistVelocity));
        }
    }

    public int getMistColor() {
        return this.mistColor;
    }

    public void setMistColor(int color) {
        if (this.mistColor != color) {
            this.mistColor = color;
            this.forceSave();
            Hisea.LOGGER.info("[Hisea] BlockEntity at {} updated color to #{}", (Object)this.method_11016(), (Object)Integer.toHexString(this.mistColor));
        }
    }

    public float getMistTransparency() {
        return this.mistTransparency;
    }

    public void setMistTransparency(float transparency) {
        if (this.mistTransparency != transparency) {
            this.mistTransparency = Math.max(0.0f, Math.min(1.0f, transparency));
            this.forceSave();
            Hisea.LOGGER.info("[Hisea] BlockEntity at {} updated transparency to {}", (Object)this.method_11016(), (Object)Float.valueOf(this.mistTransparency));
        }
    }

    public boolean isMistEnabled() {
        return this.mistEnabled;
    }

    public void setMistEnabled(boolean enabled) {
        if (this.mistEnabled != enabled) {
            this.mistEnabled = enabled;
            this.forceSave();
            Hisea.LOGGER.info("[Hisea] BlockEntity at {} updated enabled state to {} (forcing save)", (Object)this.method_11016(), (Object)this.mistEnabled);
        }
    }

    public void forceSave() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        this.method_5431();
        this.sync();
        Hisea.LOGGER.info("[Hisea] BlockEntity at {} marked dirty for persistence", (Object)this.method_11016());
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        Hisea.LOGGER.info("[Hisea] CRITICAL DEBUG - Reading NBT data: {}", (Object)nbt);
        Hisea.LOGGER.info("[Hisea] CRITICAL DEBUG - Before NBT read: intensity={}, radius={}, enabled={}", new Object[]{Float.valueOf(this.mistIntensity), this.mistRadius, this.mistEnabled});
        boolean foundIntensity = false;
        if (nbt.method_10545(INTENSITY_KEY)) {
            foundIntensity = true;
            this.mistIntensity = nbt.method_10583(INTENSITY_KEY);
        }
        boolean foundRadius = false;
        if (nbt.method_10545(RADIUS_KEY)) {
            foundRadius = true;
            this.mistRadius = nbt.method_10550(RADIUS_KEY);
        }
        boolean foundLifetime = false;
        if (nbt.method_10545(LIFETIME_KEY)) {
            foundLifetime = true;
            this.mistLifetime = nbt.method_10550(LIFETIME_KEY);
        }
        boolean foundVelocity = false;
        if (nbt.method_10545(VELOCITY_KEY)) {
            foundVelocity = true;
            this.mistVelocity = nbt.method_10583(VELOCITY_KEY);
        }
        boolean foundColor = false;
        if (nbt.method_10545(COLOR_KEY)) {
            foundColor = true;
            this.mistColor = nbt.method_10550(COLOR_KEY);
        }
        boolean foundTransparency = false;
        if (nbt.method_10545(TRANSPARENCY_KEY)) {
            foundTransparency = true;
            this.mistTransparency = nbt.method_10583(TRANSPARENCY_KEY);
        }
        boolean foundEnabled = false;
        if (nbt.method_10545(ENABLED_KEY)) {
            foundEnabled = true;
            this.mistEnabled = nbt.method_10577(ENABLED_KEY);
        }
        Hisea.LOGGER.info("[Hisea] CRITICAL DEBUG - NBT fields found: intensity={}, radius={}, lifetime={}, velocity={}, color={}, transparency={}, enabled={}", new Object[]{foundIntensity, foundRadius, foundLifetime, foundVelocity, foundColor, foundTransparency, foundEnabled});
        Hisea.LOGGER.info("[Hisea] BlockEntity loaded at {} with: intensity={}, radius={}, color=#{}, transparency={}, enabled={}", new Object[]{this.method_11016(), Float.valueOf(this.mistIntensity), this.mistRadius, Integer.toHexString(this.mistColor), Float.valueOf(this.mistTransparency), this.mistEnabled});
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            Hisea.LOGGER.info("[Hisea] Server: Immediate sync of {} to clients", (Object)this.method_11016());
            class_2680 state = this.method_11010();
            this.field_11863.method_8413(this.method_11016(), state, state, 3);
            this.method_5431();
        }
        if (this.field_11863 != null && this.field_11863.field_9236) {
            Hisea.LOGGER.info("[Hisea] Client: Refreshing state from NBT at {}", (Object)this.method_11016());
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        Hisea.LOGGER.info("[Hisea] CRITICAL DEBUG - Writing to NBT: intensity={}, radius={}, lifetime={}, velocity={}, color=#{}, transparency={}, enabled={}", new Object[]{Float.valueOf(this.mistIntensity), this.mistRadius, this.mistLifetime, Float.valueOf(this.mistVelocity), Integer.toHexString(this.mistColor), Float.valueOf(this.mistTransparency), this.mistEnabled});
        nbt.method_10548(INTENSITY_KEY, this.mistIntensity);
        nbt.method_10569(RADIUS_KEY, this.mistRadius);
        nbt.method_10569(LIFETIME_KEY, this.mistLifetime);
        nbt.method_10548(VELOCITY_KEY, this.mistVelocity);
        nbt.method_10569(COLOR_KEY, this.mistColor);
        nbt.method_10548(TRANSPARENCY_KEY, this.mistTransparency);
        nbt.method_10556(ENABLED_KEY, this.mistEnabled);
        nbt.method_10582("HiseaVersion", "1.0");
        Hisea.LOGGER.info("[Hisea] CRITICAL DEBUG - NBT after write: {}", (Object)nbt);
        Hisea.LOGGER.info("[Hisea] BlockEntity saved at {} with: intensity={}, radius={}, enabled={}", new Object[]{this.method_11016(), Float.valueOf(this.mistIntensity), this.mistRadius, this.mistEnabled});
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbt = this.method_38244();
        Hisea.LOGGER.info("[Hisea] CRITICAL: Creating initial chunk data NBT: {}", (Object)nbt);
        Hisea.LOGGER.info("[Hisea] CRITICAL: Values being sent: intensity={}, enabled={}", (Object)Float.valueOf(this.mistIntensity), (Object)this.mistEnabled);
        return nbt;
    }

    private void sync() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 6);
            Hisea.LOGGER.info("[Hisea] BlockEntity at {} synchronized to clients", (Object)this.method_11016());
        }
    }
}

