/*
 * Decompiled with CFR 0.152.
 */
package arda.hisea.gui;

import arda.hisea.Hisea;
import arda.hisea.HiseaClient;
import arda.hisea.block.entity.ArdaMistBlockEntity;
import arda.hisea.gui.MistSettings;
import arda.hisea.networking.ClientMistNetworking;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class MistConfigScreen
extends class_437 {
    private final ArdaMistBlockEntity blockEntity;
    private final class_2338 blockPos;
    private int intensity = 10;
    private boolean enabled = true;
    private int velocity = 10;
    private int lifetime = 30;
    private int color = 0xFFFFFF;
    private float transparency = 10.0f;
    private int radius = 3;
    private class_342 colorField;

    public MistConfigScreen(ArdaMistBlockEntity blockEntity, class_2338 pos) {
        super((class_2561)class_2561.method_43470((String)"[Hisea] Mist Configuration"));
        this.blockEntity = blockEntity;
        Hisea.LOGGER.info("[Hisea] Opening config screen for block at {}, requesting fresh data from server", (Object)pos);
        ClientMistNetworking.requestMistSettings(pos);
        this.blockPos = pos;
        if (MistSettings.hasSettings(pos)) {
            Integer cachedRadius;
            Float cachedTransparency;
            Integer cachedColor;
            Float cachedIntensity = MistSettings.getIntensity(pos);
            Boolean cachedEnabled = MistSettings.isEnabled(pos);
            Float cachedVelocity = MistSettings.getVelocity(pos);
            Integer cachedLifetime = MistSettings.getLifetime(pos);
            if (cachedIntensity != null && cachedEnabled != null) {
                this.intensity = (int)(cachedIntensity.floatValue() * 10.0f);
                this.enabled = cachedEnabled;
                Hisea.LOGGER.info("[Hisea] CRITICAL: Using cached settings for {}: intensity={} ({}%), enabled={}", new Object[]{pos, cachedIntensity, this.intensity * 2, cachedEnabled});
            }
            if (cachedVelocity != null) {
                this.velocity = (int)(cachedVelocity.floatValue() * 10.0f);
                Hisea.LOGGER.info("[Hisea] Using cached velocity: {}", (Object)cachedVelocity);
            }
            if (cachedLifetime != null) {
                this.lifetime = cachedLifetime / 10;
                Hisea.LOGGER.info("[Hisea] Using cached lifetime: {} ticks", (Object)cachedLifetime);
            }
            if ((cachedColor = MistSettings.getColor(pos)) != null) {
                this.color = cachedColor;
                Hisea.LOGGER.info("[Hisea] Using cached color: #{}", (Object)Integer.toHexString(cachedColor));
            }
            if ((cachedTransparency = MistSettings.getTransparency(pos)) != null) {
                this.transparency = cachedTransparency.floatValue() * 10.0f;
                Hisea.LOGGER.info("[Hisea] Using cached transparency: {}", (Object)cachedTransparency);
            }
            if ((cachedRadius = MistSettings.getRadius(pos)) != null) {
                this.radius = cachedRadius;
                Hisea.LOGGER.info("[Hisea] Using cached radius: {}", (Object)cachedRadius);
            }
            if (blockEntity != null) {
                blockEntity.setMistIntensity(cachedIntensity != null ? cachedIntensity.floatValue() : 1.0f);
                blockEntity.setMistEnabled(cachedEnabled != null ? cachedEnabled : true);
                if (cachedVelocity != null) {
                    blockEntity.setMistVelocity(cachedVelocity.floatValue());
                }
                if (cachedLifetime != null) {
                    blockEntity.setMistLifetime(cachedLifetime);
                }
                if (cachedColor != null) {
                    blockEntity.setMistColor(cachedColor);
                }
                if (cachedTransparency != null) {
                    blockEntity.setMistTransparency(cachedTransparency.floatValue());
                }
                if (cachedRadius != null) {
                    blockEntity.setMistRadius(cachedRadius);
                }
                Hisea.LOGGER.info("[Hisea] Updated block entity from cache");
            }
        } else if (blockEntity != null) {
            float rawIntensity = blockEntity.getMistIntensity();
            float rawVelocity = blockEntity.getMistVelocity();
            int rawLifetime = blockEntity.getMistLifetime();
            int rawColor = blockEntity.getMistColor();
            float rawTransparency = blockEntity.getMistTransparency();
            int rawRadius = blockEntity.getMistRadius();
            Hisea.LOGGER.info("[Hisea] CRITICAL: Raw values from BlockEntity: intensity={}, velocity={}, lifetime={}, color=#{}, transparency={}, radius={}", new Object[]{Float.valueOf(rawIntensity), Float.valueOf(rawVelocity), rawLifetime, Integer.toHexString(rawColor), Float.valueOf(rawTransparency), rawRadius});
            this.intensity = (int)(rawIntensity * 10.0f);
            this.velocity = (int)(rawVelocity * 10.0f);
            this.lifetime = rawLifetime / 10;
            this.color = rawColor;
            this.transparency = rawTransparency * 10.0f;
            this.radius = rawRadius;
            this.enabled = blockEntity.isMistEnabled();
            Hisea.LOGGER.info("[Hisea] CRITICAL: Converted UI values: intensity={}, velocity={}, lifetime={}, color=#{}, transparency={}, radius={}", new Object[]{this.intensity, this.velocity, this.lifetime, Integer.toHexString(this.color), Float.valueOf(this.transparency), this.radius});
            if (this.intensity < 0) {
                Hisea.LOGGER.warn("[Hisea] Fixing negative intensity value: {} -> 0", (Object)this.intensity);
                this.intensity = 0;
            }
            if (this.intensity > 50) {
                Hisea.LOGGER.warn("[Hisea] Clamping excessive intensity value: {} -> 50", (Object)this.intensity);
                this.intensity = 50;
            }
            if (this.velocity < 0) {
                Hisea.LOGGER.warn("[Hisea] Fixing negative velocity value: {} -> 0", (Object)this.velocity);
                this.velocity = 0;
            }
            if (this.velocity > 20) {
                Hisea.LOGGER.warn("[Hisea] Clamping excessive velocity value: {} -> 20", (Object)this.velocity);
                this.velocity = 20;
            }
            if (this.lifetime < 10) {
                Hisea.LOGGER.warn("[Hisea] Fixing too low lifetime value: {} -> 10", (Object)this.lifetime);
                this.lifetime = 10;
            }
            if (this.lifetime > 60) {
                Hisea.LOGGER.warn("[Hisea] Clamping excessive lifetime value: {} -> 60", (Object)this.lifetime);
                this.lifetime = 60;
            }
            if (this.transparency < 0.0f) {
                Hisea.LOGGER.warn("[Hisea] Fixing negative transparency value: {} -> 0", (Object)Float.valueOf(this.transparency));
                this.transparency = 0.0f;
            }
            if (this.transparency > 10.0f) {
                Hisea.LOGGER.warn("[Hisea] Clamping excessive transparency value: {} -> 10", (Object)Float.valueOf(this.transparency));
                this.transparency = 10.0f;
            }
            if (this.radius < 1) {
                Hisea.LOGGER.warn("[Hisea] Fixing too low radius value: {} -> 1", (Object)this.radius);
                this.radius = 1;
            }
            if (this.radius > 20) {
                Hisea.LOGGER.warn("[Hisea] Clamping excessive radius value: {} -> 20", (Object)this.radius);
                this.radius = 20;
            }
            Hisea.LOGGER.info("[Hisea] Loading from block entity at {}: intensity={} ({}%), enabled={}, velocity={}, lifetime={}, color=#{}, transparency={}, radius={}", new Object[]{this.blockPos, Float.valueOf(blockEntity.getMistIntensity()), this.intensity * 2, blockEntity.isMistEnabled(), Float.valueOf(blockEntity.getMistVelocity()), blockEntity.getMistLifetime(), Integer.toHexString(rawColor), Float.valueOf(blockEntity.getMistTransparency()), blockEntity.getMistRadius()});
            MistSettings.saveFullSettingsWithColor(pos, rawIntensity, this.enabled, rawVelocity, rawLifetime, rawColor, rawTransparency, rawRadius);
        } else {
            this.intensity = 10;
            this.enabled = true;
            this.velocity = 10;
            this.lifetime = 30;
            this.color = 0xFFFFFF;
            this.transparency = 10.0f;
            this.radius = 3;
            Hisea.LOGGER.warn("[Hisea] No block entity available, using default values");
        }
        Hisea.LOGGER.info("[Hisea] MistConfigScreen created for block at {} with intensity={}, enabled={}", new Object[]{pos, this.intensity, this.enabled});
    }

    protected void method_25426() {
        int startY;
        super.method_25426();
        Hisea.LOGGER.info("[Hisea] MistConfigScreen init() called");
        if (this.blockEntity != null) {
            float rawIntensity = this.blockEntity.getMistIntensity();
            float rawVelocity = this.blockEntity.getMistVelocity();
            int rawLifetime = this.blockEntity.getMistLifetime();
            Hisea.LOGGER.info("[Hisea] CRITICAL: In init() - Re-reading from BlockEntity, raw values: intensity={}, velocity={}, lifetime={}", new Object[]{Float.valueOf(rawIntensity), Float.valueOf(rawVelocity), rawLifetime});
            this.intensity = (int)(rawIntensity * 10.0f);
            this.velocity = (int)(rawVelocity * 10.0f);
            this.lifetime = rawLifetime / 10;
            this.enabled = this.blockEntity.isMistEnabled();
            Hisea.LOGGER.info("[Hisea] CRITICAL: In init() - Updated UI state to intensity={}, velocity={}, lifetime={}, enabled={}", new Object[]{this.intensity, this.velocity, this.lifetime, this.enabled});
        }
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int buttonWidth = 80;
        int sliderWidth = 110;
        int buttonHeight = 20;
        int padding = 15;
        int leftColX = centerX - 190;
        int rightColX = centerX - 100;
        int row1 = startY = centerY - 85;
        int row2 = row1 + buttonHeight + padding + 5;
        int row3 = row2 + buttonHeight + padding + 5;
        int row4 = row3 + buttonHeight + padding + 5;
        int leftCol2X = centerX + 20;
        int rightCol2X = centerX + 110;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.enabled ? "\u00a7a\u00a7lMist: ON" : "\u00a7c\u00a7lMist: OFF")), button -> {
            this.enabled = !this.enabled;
            button.method_25355((class_2561)class_2561.method_43470((String)(this.enabled ? "\u00a7a\u00a7lMist: ON" : "\u00a7c\u00a7lMist: OFF")));
            Hisea.LOGGER.info("[Hisea] CRITICAL: User toggled mist state to {} for block at {}", (Object)this.enabled, (Object)this.blockPos);
            MistSettings.saveFullSettings(this.blockPos, (float)this.intensity / 10.0f, this.enabled, (float)this.velocity / 10.0f, this.lifetime * 10);
            Hisea.LOGGER.info("[Hisea] CRITICAL: Updated client cache IMMEDIATELY with enabled={}", (Object)this.enabled);
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7b\u00a7l[Hisea] Mist: " + (this.enabled ? "\u00a7a\u00a7lON" : "\u00a7c\u00a7lOFF"))), true);
            }
            this.updateSettings();
        }).method_46434(centerX - 60, startY - 40, 120, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Intensity"), button -> {}).method_46434(leftColX, row1, buttonWidth, buttonHeight).method_46431());
        int segmentWidth = sliderWidth / 4;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"--"), button -> {
            this.intensity = Math.max(0, this.intensity - 5);
            this.updateSettings();
        }).method_46434(rightColX, row1, segmentWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), button -> {
            this.intensity = Math.max(0, this.intensity - 1);
            this.updateSettings();
        }).method_46434(rightColX + segmentWidth, row1, segmentWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), button -> {
            this.intensity = Math.min(50, this.intensity + 1);
            this.updateSettings();
        }).method_46434(rightColX + segmentWidth * 2, row1, segmentWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"++"), button -> {
            this.intensity = Math.min(50, this.intensity + 5);
            this.updateSettings();
        }).method_46434(rightColX + segmentWidth * 3, row1, segmentWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Velocity"), button -> {}).method_46434(leftColX, row2, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"--"), button -> {
            this.velocity = Math.max(0, this.velocity - 10);
            this.updateSettings();
        }).method_46434(rightColX, row2, segmentWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), button -> {
            this.velocity = Math.max(0, this.velocity - 1);
            this.updateSettings();
        }).method_46434(rightColX + segmentWidth, row2, segmentWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), button -> {
            this.velocity = Math.min(20, this.velocity + 1);
            this.updateSettings();
        }).method_46434(rightColX + segmentWidth * 2, row2, segmentWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"++"), button -> {
            this.velocity = Math.min(20, this.velocity + 10);
            this.updateSettings();
        }).method_46434(rightColX + segmentWidth * 3, row2, segmentWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Lifetime"), button -> {}).method_46434(leftColX, row3, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"--"), button -> {
            this.lifetime = Math.max(10, this.lifetime - 5);
            this.updateSettings();
        }).method_46434(rightColX, row3, segmentWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), button -> {
            this.lifetime = Math.max(10, this.lifetime - 1);
            this.updateSettings();
        }).method_46434(rightColX + segmentWidth, row3, segmentWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), button -> {
            this.lifetime = Math.min(60, this.lifetime + 1);
            this.updateSettings();
        }).method_46434(rightColX + segmentWidth * 2, row3, segmentWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"++"), button -> {
            this.lifetime = Math.min(60, this.lifetime + 5);
            this.updateSettings();
        }).method_46434(rightColX + segmentWidth * 3, row3, segmentWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Transparency"), button -> {}).method_46434(leftCol2X, row1, buttonWidth, buttonHeight).method_46431());
        int btnWidth = sliderWidth / 4;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"--"), button -> {
            this.transparency = Math.max(0.0f, this.transparency - 1.0f);
            this.updateSettings();
        }).method_46434(rightCol2X, row1, btnWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), button -> {
            if (this.transparency > 0.0f) {
                this.transparency = Math.max(0.0f, this.transparency - 0.1f);
                this.transparency = (float)Math.round(this.transparency * 10.0f) / 10.0f;
                this.updateSettings();
            }
        }).method_46434(rightCol2X + btnWidth, row1, btnWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), button -> {
            if (this.transparency < 10.0f) {
                this.transparency = Math.min(10.0f, this.transparency + 0.1f);
                this.transparency = (float)Math.round(this.transparency * 10.0f) / 10.0f;
                this.updateSettings();
            }
        }).method_46434(rightCol2X + btnWidth * 2, row1, btnWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"++"), button -> {
            this.transparency = Math.min(10.0f, this.transparency + 1.0f);
            this.updateSettings();
        }).method_46434(rightCol2X + btnWidth * 3, row1, btnWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Radius"), button -> {}).method_46434(leftCol2X, row2, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-5"), button -> {
            this.radius = Math.max(1, this.radius - 5);
            this.updateSettings();
        }).method_46434(rightCol2X, row2, btnWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-1"), button -> {
            this.radius = Math.max(1, this.radius - 1);
            this.updateSettings();
        }).method_46434(rightCol2X + btnWidth, row2, btnWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+1"), button -> {
            this.radius = Math.min(100, this.radius + 1);
            this.updateSettings();
        }).method_46434(rightCol2X + btnWidth * 2, row2, btnWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+5"), button -> {
            this.radius = Math.min(100, this.radius + 5);
            this.updateSettings();
        }).method_46434(rightCol2X + btnWidth * 3, row2, btnWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Color"), button -> {}).method_46434(leftCol2X, row3, buttonWidth, buttonHeight).method_46431());
        this.colorField = new class_342(this.field_22793, rightCol2X, row3, btnWidth * 3, buttonHeight, (class_2561)class_2561.method_43470((String)""));
        this.colorField.method_1880(6);
        this.colorField.method_1852(Integer.toHexString(this.color).toUpperCase());
        this.colorField.method_1863(this::onColorTextChanged);
        this.method_37063((class_364)this.colorField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Apply"), button -> this.applyColorFromTextField()).method_46434(rightCol2X + btnWidth * 3 + 10, row3, btnWidth + 10, buttonHeight).method_46431());
        int bottomRowY = row4 + 15;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset All"), button -> {
            this.intensity = 10;
            this.velocity = 10;
            this.lifetime = 30;
            this.color = 0xFFFFFF;
            this.transparency = 10.0f;
            this.radius = 3;
            this.enabled = true;
            this.colorField.method_1852("FFFFFF");
            this.updateSettings();
        }).method_46434(centerX - 130, bottomRowY, 120, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Apply & Close"), button -> this.method_25419()).method_46434(centerX + 10, bottomRowY, 120, buttonHeight).method_46431());
    }

    private void clearExistingParticles() {
        if (this.field_22787 != null && this.field_22787.field_1687 != null) {
            ClientMistNetworking.sendClearMistRequest(this.blockPos);
            Hisea.LOGGER.info("[Hisea] Sent request to clear mist particles at {}", (Object)this.blockPos);
        }
    }

    private void onColorTextChanged(String text) {
        try {
            int newColor = Integer.parseInt(text, 16);
            int n = newColor & 0xFFFFFF;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void applyColorFromTextField() {
        block5: {
            try {
                String colorText = this.colorField.method_1882();
                if (colorText.isEmpty()) {
                    this.color = 0xFFFFFF;
                    this.colorField.method_1852("FFFFFF");
                } else {
                    this.color = Integer.parseInt(colorText, 16);
                    this.color &= 0xFFFFFF;
                    this.colorField.method_1852(String.format("%06X", this.color));
                }
                this.updateSettings();
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)String.format("[Hisea] Set color to #%06X", this.color)), false);
                }
            }
            catch (NumberFormatException e) {
                this.colorField.method_1852(String.format("%06X", this.color));
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block5;
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c[Hisea] Invalid color format. Use hex format (e.g., FFFFFF for white)"), false);
            }
        }
    }

    private void updateSettings() {
        if (this.blockEntity != null) {
            float newIntensity = (float)this.intensity / 10.0f;
            float newVelocity = (float)this.velocity / 10.0f;
            int newLifetime = this.lifetime * 10;
            float newTransparency = this.transparency / 10.0f;
            int newRadius = this.radius;
            Hisea.LOGGER.info("[Hisea] CRITICAL: Before update - Block at {}: intensity={}, velocity={}, lifetime={}, transparency={}, radius={}, enabled={}", new Object[]{this.blockPos, Float.valueOf(this.blockEntity.getMistIntensity()), Float.valueOf(this.blockEntity.getMistVelocity()), this.blockEntity.getMistLifetime(), Float.valueOf(this.blockEntity.getMistTransparency()), this.blockEntity.getMistRadius(), this.blockEntity.isMistEnabled()});
            if (this.field_22787 != null && this.field_22787.method_1562() != null) {
                boolean intensityChanged = Math.abs(this.blockEntity.getMistIntensity() - newIntensity) > 0.001f;
                boolean velocityChanged = Math.abs(this.blockEntity.getMistVelocity() - newVelocity) > 0.001f;
                boolean lifetimeChanged = this.blockEntity.getMistLifetime() != newLifetime;
                boolean transparencyChanged = Math.abs(this.blockEntity.getMistTransparency() - newTransparency) > 0.001f;
                boolean radiusChanged = this.blockEntity.getMistRadius() != newRadius;
                boolean enabledChanged = this.blockEntity.isMistEnabled() != this.enabled;
                boolean anyChange = intensityChanged || velocityChanged || lifetimeChanged || transparencyChanged || radiusChanged || enabledChanged;
                this.blockEntity.setMistIntensity(newIntensity);
                this.blockEntity.setMistVelocity(newVelocity);
                this.blockEntity.setMistLifetime(newLifetime);
                this.blockEntity.setMistColor(this.color);
                this.blockEntity.setMistTransparency(newTransparency);
                this.blockEntity.setMistRadius(newRadius);
                this.blockEntity.setMistEnabled(this.enabled);
                MistSettings.saveFullSettingsWithColor(this.blockPos, newIntensity, this.enabled, newVelocity, newLifetime, this.color, newTransparency, newRadius);
                ClientMistNetworking.sendFullMistSettingsUpdate(this.blockPos, newIntensity, newVelocity, newLifetime, this.enabled, this.color, newTransparency, newRadius);
                Hisea.LOGGER.info("[Hisea] CRITICAL: Sent full settings update to server");
                if (this.field_22787.field_1687 != null && anyChange) {
                    this.field_22787.field_1687.method_8413(this.blockPos, this.field_22787.field_1687.method_8320(this.blockPos), this.field_22787.field_1687.method_8320(this.blockPos), 3);
                    Hisea.LOGGER.info("[Hisea] CRITICAL: Forced block update to refresh visuals");
                }
                Hisea.LOGGER.info("[Hisea] CRITICAL: After update - Block at {}: intensity={}, velocity={}, lifetime={}, color=#{}, transparency={}, radius={}, enabled={}", new Object[]{this.blockPos, Float.valueOf(this.blockEntity.getMistIntensity()), Float.valueOf(this.blockEntity.getMistVelocity()), this.blockEntity.getMistLifetime(), Integer.toHexString(this.blockEntity.getMistColor()), Float.valueOf(this.blockEntity.getMistTransparency()), this.blockEntity.getMistRadius(), this.blockEntity.isMistEnabled()});
                Hisea.LOGGER.info("[Hisea] CRITICAL: Client updated, server updated via direct networking");
            }
            class_310 client = class_310.method_1551();
            if (client.field_1687 != null) {
                if (this.enabled) {
                    for (int i = 0; i < 10; ++i) {
                        HiseaClient.spawnMist((class_1937)client.field_1687, this.blockPos, newIntensity);
                    }
                } else {
                    client.field_1687.method_8406((class_2394)class_2398.field_11251, (double)this.blockPos.method_10263() + 0.5, (double)this.blockPos.method_10264() + 0.5, (double)this.blockPos.method_10260() + 0.5, 0.0, 0.0, 0.0);
                }
            }
            Hisea.LOGGER.info("[Hisea] Updated all mist settings: intensity={}, velocity={}, lifetime={}, color=#{}, enabled={}", new Object[]{Float.valueOf(newIntensity), Float.valueOf(newVelocity), newLifetime, Integer.toHexString(this.color), this.enabled});
        } else {
            Hisea.LOGGER.error("[Hisea] ERROR: blockEntity is null in updateSettings()!");
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            String status = this.enabled ? "\u00a7a\u00a7lON" : "\u00a7c\u00a7lOFF";
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a7b\u00a7l[Hisea] Mist %s, intensity: %d%%", status, this.intensity * 2)), false);
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)String.format("[Hisea] Velocity: %.1fx, Lifetime: %.1fs, Transparency: %.1f%%, Radius: %d blocks, Color: #%06X", Float.valueOf((float)this.velocity / 10.0f), Float.valueOf((float)this.lifetime * 0.5f), Float.valueOf(this.transparency * 10.0f), this.radius, this.color & 0xFFFFFF)), false);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int startY;
        this.method_25420(context);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"\u00a7b\u00a7l[Hisea] Mist Configuration"), this.field_22789 / 2, 20, 0xFFFFFF);
        int colorPreviewSize = 25;
        int colorPreviewX = this.field_22789 / 2 - colorPreviewSize / 2;
        int colorPreviewY = 45;
        String colorText = String.format("#%06X", this.color & 0xFFFFFF);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)colorText), this.field_22789 / 2, colorPreviewY - 12, this.color);
        context.method_25294(colorPreviewX - 1, colorPreviewY - 1, colorPreviewX + colorPreviewSize + 1, colorPreviewY + colorPreviewSize + 1, -16777216);
        context.method_25294(colorPreviewX, colorPreviewY, colorPreviewX + colorPreviewSize, colorPreviewY + colorPreviewSize, 0xFF000000 | this.color);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int barWidth = 110;
        int barHeight = 8;
        int padding = 15;
        int buttonWidth = 80;
        int buttonHeight = 20;
        int leftColX = centerX - 190;
        int rightColX = centerX - 100;
        int leftCol2X = centerX + 20;
        int rightCol2X = centerX + 110;
        int row1 = startY = centerY - 85;
        int row2 = row1 + 20 + padding + 5;
        int row3 = row2 + 20 + padding + 5;
        int intensityBarX = rightColX;
        int intensityBarY = row1 + 25;
        context.method_25294(intensityBarX, intensityBarY, intensityBarX + barWidth, intensityBarY + barHeight, -13421773);
        int intensityFillWidth = (int)((double)barWidth * ((double)this.intensity / 50.0));
        int intensityBarColor = this.enabled ? -13391309 : -10066330;
        context.method_25294(intensityBarX, intensityBarY, intensityBarX + intensityFillWidth, intensityBarY + barHeight, intensityBarColor);
        String intensityText = String.format("%d%%", this.intensity * 2);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)intensityText), leftColX + buttonWidth / 2, row1 + buttonHeight + 5, 0xFFFFFF);
        int velocityBarX = rightColX;
        int velocityBarY = row2 + 25;
        context.method_25294(velocityBarX, velocityBarY, velocityBarX + barWidth, velocityBarY + barHeight, -13421773);
        int velocityFillWidth = (int)((double)barWidth * ((double)this.velocity / 20.0));
        int velocityBarColor = this.enabled ? -13421654 : -10066330;
        context.method_25294(velocityBarX, velocityBarY, velocityBarX + velocityFillWidth, velocityBarY + barHeight, velocityBarColor);
        String velocityText = String.format("%.1fx", Float.valueOf((float)this.velocity / 10.0f));
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)velocityText), leftColX + buttonWidth / 2, row2 + buttonHeight + 5, 0xFFFFFF);
        int lifetimeBarX = rightColX;
        int lifetimeBarY = row3 + 25;
        context.method_25294(lifetimeBarX, lifetimeBarY, lifetimeBarX + barWidth, lifetimeBarY + barHeight, -13421773);
        int lifetimeFillWidth = (int)((double)barWidth * ((double)(this.lifetime - 10) / 50.0));
        int lifetimeBarColor = this.enabled ? -5622989 : -10066330;
        context.method_25294(lifetimeBarX, lifetimeBarY, lifetimeBarX + lifetimeFillWidth, lifetimeBarY + barHeight, lifetimeBarColor);
        String lifetimeText = String.format("%.1fs", Float.valueOf((float)this.lifetime * 0.5f));
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)lifetimeText), leftColX + buttonWidth / 2, row3 + buttonHeight + 5, 0xFFFFFF);
        int transparencyBarX = rightCol2X;
        int transparencyBarY = row1 + 25;
        context.method_25294(transparencyBarX, transparencyBarY, transparencyBarX + barWidth, transparencyBarY + barHeight, -13421773);
        int transparencyFillWidth = (int)((double)barWidth * ((double)this.transparency / 10.0));
        int transparencyBarColor = this.enabled ? -10074966 : -10066330;
        context.method_25294(transparencyBarX, transparencyBarY, transparencyBarX + transparencyFillWidth, transparencyBarY + barHeight, transparencyBarColor);
        String transparencyText = String.format("%.1f%%", Float.valueOf(this.transparency * 10.0f));
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)transparencyText), leftCol2X + buttonWidth / 2, row1 + buttonHeight + 5, 0xFFFFFF);
        int radiusBarX = rightCol2X;
        int radiusBarY = row2 + 25;
        context.method_25294(radiusBarX, radiusBarY, radiusBarX + barWidth, radiusBarY + barHeight, -13421773);
        int radiusFillWidth = (int)((double)barWidth * ((double)(this.radius - 1) / 99.0));
        int radiusBarColor = this.enabled ? -13391190 : -10066330;
        context.method_25294(radiusBarX, radiusBarY, radiusBarX + radiusFillWidth, radiusBarY + barHeight, radiusBarColor);
        String radiusText = String.format("%d blocks", this.radius);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)radiusText), leftCol2X + buttonWidth / 2, row2 + buttonHeight + 5, 0xFFFFFF);
        String statusText = String.format("Intensity: %d%% | Velocity: %.1fx | Lifetime: %.1fs | Transparency: %.1f%% | Radius: %d", this.intensity * 2, Float.valueOf((float)this.velocity / 10.0f), Float.valueOf((float)this.lifetime * 0.5f), Float.valueOf(this.transparency * 10.0f), this.radius);
        int statusBarY = this.field_22790 - 20;
        context.method_25294(0, statusBarY - 2, this.field_22789, statusBarY + 12, Integer.MIN_VALUE);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)statusText), this.field_22789 / 2, statusBarY, this.enabled ? 0xFFFFFF : 0xAAAAAA);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25393() {
        super.method_25393();
        if (this.colorField != null) {
            this.colorField.method_1865();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.colorField.method_25370()) {
            this.applyColorFromTextField();
            return true;
        }
        if (this.colorField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.colorField.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public void method_25419() {
        if (this.blockEntity != null && this.field_22787 != null && this.field_22787.method_1562() != null) {
            float finalIntensity = (float)this.intensity / 10.0f;
            float finalVelocity = (float)this.velocity / 10.0f;
            int finalLifetime = this.lifetime * 10;
            float finalTransparency = this.transparency / 10.0f;
            Hisea.LOGGER.info("[Hisea] CRITICAL: GUI closing, final state: intensity={}, velocity={}, lifetime={}, transparency={}, radius={}, enabled={}", new Object[]{Float.valueOf(finalIntensity), Float.valueOf(finalVelocity), finalLifetime, Float.valueOf(finalTransparency), this.radius, this.enabled});
            this.blockEntity.setMistIntensity(finalIntensity);
            this.blockEntity.setMistVelocity(finalVelocity);
            this.blockEntity.setMistLifetime(finalLifetime);
            this.blockEntity.setMistTransparency(finalTransparency);
            this.blockEntity.setMistRadius(this.radius);
            this.blockEntity.setMistEnabled(this.enabled);
            MistSettings.saveFullSettingsWithColor(this.blockPos, finalIntensity, this.enabled, finalVelocity, finalLifetime, this.color, finalTransparency, this.radius);
            ClientMistNetworking.sendFullMistSettingsUpdate(this.blockPos, finalIntensity, finalVelocity, finalLifetime, this.enabled, this.color, finalTransparency, this.radius);
            Hisea.LOGGER.info("[Hisea] CRITICAL: Sent final direct network update to server on close");
            if (this.field_22787.field_1687 != null) {
                this.field_22787.field_1687.method_8413(this.blockPos, this.field_22787.field_1687.method_8320(this.blockPos), this.field_22787.field_1687.method_8320(this.blockPos), 3);
                Hisea.LOGGER.info("[Hisea] CRITICAL: Forced final block update before closing");
            }
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7b\u00a7l[Hisea] Saving all mist settings via direct networking..."), false);
        }
        super.method_25419();
    }
}

