/*
 * Decompiled with CFR 0.152.
 */
package arda.hisea.gui;

import arda.hisea.Hisea;
import arda.hisea.block.entity.ArdaMistBlockEntity;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class MistSettings {
    private static final Map<String, class_2338> BLOCK_POS_LOOKUP = new HashMap<String, class_2338>();
    private static final Map<String, Float> POSITION_INTENSITY = new HashMap<String, Float>();
    private static final Map<String, Boolean> POSITION_ENABLED = new HashMap<String, Boolean>();
    private static final Map<String, Integer> POSITION_LIFETIME = new HashMap<String, Integer>();
    private static final Map<String, Float> POSITION_VELOCITY = new HashMap<String, Float>();
    private static final Map<String, Integer> POSITION_COLOR = new HashMap<String, Integer>();
    private static final Map<String, Float> POSITION_TRANSPARENCY = new HashMap<String, Float>();
    private static final Map<String, Integer> POSITION_RADIUS = new HashMap<String, Integer>();
    private static final Map<String, Long> POSITION_LAST_UPDATE = new HashMap<String, Long>();
    @Deprecated
    private static final Map<class_2338, Float> INTENSITY_CACHE = new HashMap<class_2338, Float>();
    @Deprecated
    private static final Map<class_2338, Boolean> ENABLED_CACHE = new HashMap<class_2338, Boolean>();
    @Deprecated
    private static final Map<class_2338, Integer> LIFETIME_CACHE = new HashMap<class_2338, Integer>();
    @Deprecated
    private static final Map<class_2338, Float> VELOCITY_CACHE = new HashMap<class_2338, Float>();
    @Deprecated
    private static final Map<class_2338, Integer> COLOR_CACHE = new HashMap<class_2338, Integer>();
    @Deprecated
    private static final Map<class_2338, Float> TRANSPARENCY_CACHE = new HashMap<class_2338, Float>();
    @Deprecated
    private static final Map<class_2338, Integer> RADIUS_CACHE = new HashMap<class_2338, Integer>();
    @Deprecated
    private static final Map<class_2338, Long> LAST_UPDATE_TIME = new HashMap<class_2338, Long>();
    private static float lastUsedIntensity = 1.0f;
    private static boolean lastUsedEnabled = true;
    private static float lastUsedVelocity = 1.0f;
    private static int lastUsedLifetime = 300;
    private static int lastUsedColor = 0xFFFFFF;
    private static float lastUsedTransparency = 1.0f;
    private static int lastUsedRadius = 3;
    private static boolean initialWorldLoad = true;

    public static void saveSettings(class_2338 pos, float intensity, boolean enabled) {
        String key = MistSettings.posToKey(pos);
        Integer existingLifetime = POSITION_LIFETIME.getOrDefault(key, 300);
        Float existingVelocity = POSITION_VELOCITY.getOrDefault(key, Float.valueOf(1.0f));
        MistSettings.saveFullSettings(pos, intensity, enabled, existingVelocity.floatValue(), existingLifetime);
    }

    public static void saveSettingsWithLifetime(class_2338 pos, float intensity, boolean enabled, int lifetime) {
        String key = MistSettings.posToKey(pos);
        Float existingVelocity = POSITION_VELOCITY.getOrDefault(key, Float.valueOf(1.0f));
        MistSettings.saveFullSettings(pos, intensity, enabled, existingVelocity.floatValue(), lifetime);
    }

    public static void saveSettingsWithVelocity(class_2338 pos, float intensity, boolean enabled, float velocity) {
        String key = MistSettings.posToKey(pos);
        Integer existingLifetime = POSITION_LIFETIME.getOrDefault(key, 300);
        MistSettings.saveFullSettings(pos, intensity, enabled, velocity, existingLifetime);
    }

    public static void saveFullSettings(class_2338 pos, float intensity, boolean enabled, float velocity, int lifetime) {
        String key = MistSettings.posToKey(pos);
        Integer existingColor = POSITION_COLOR.getOrDefault(key, 0xFFFFFF);
        Float existingTransparency = POSITION_TRANSPARENCY.getOrDefault(key, Float.valueOf(1.0f));
        Integer existingRadius = POSITION_RADIUS.getOrDefault(key, 3);
        MistSettings.saveFullSettingsWithColor(pos, intensity, enabled, velocity, lifetime, existingColor, existingTransparency.floatValue(), existingRadius);
    }

    public static void saveFullSettingsWithColor(class_2338 pos, float intensity, boolean enabled, float velocity, int lifetime, int color) {
        String key = MistSettings.posToKey(pos);
        Float existingTransparency = POSITION_TRANSPARENCY.getOrDefault(key, Float.valueOf(1.0f));
        Integer existingRadius = POSITION_RADIUS.getOrDefault(key, 3);
        MistSettings.saveFullSettingsWithColor(pos, intensity, enabled, velocity, lifetime, color, existingTransparency.floatValue(), existingRadius);
    }

    public static void saveFullSettingsWithColor(class_2338 pos, float intensity, boolean enabled, float velocity, int lifetime, int color, float transparency) {
        String key = MistSettings.posToKey(pos);
        Integer existingRadius = POSITION_RADIUS.getOrDefault(key, 3);
        MistSettings.saveFullSettingsWithColor(pos, intensity, enabled, velocity, lifetime, color, transparency, existingRadius);
    }

    public static void saveFullSettingsWithColor(class_2338 pos, float intensity, boolean enabled, float velocity, int lifetime, int color, float transparency, int radius) {
        String posKey = pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260();
        class_2338 immutablePos = pos.method_10062();
        BLOCK_POS_LOOKUP.put(posKey, immutablePos);
        POSITION_LAST_UPDATE.put(posKey, System.currentTimeMillis());
        Boolean previousEnabled = POSITION_ENABLED.get(posKey);
        if (previousEnabled != null && previousEnabled.booleanValue() && !enabled) {
            Hisea.LOGGER.info("[Hisea] ULTRA DEBUG: Block at {} was just disabled, caching this state with HIGH priority", (Object)immutablePos);
        }
        intensity = Math.max(0.0f, Math.min(5.0f, intensity));
        velocity = Math.max(0.0f, Math.min(3.0f, velocity));
        lifetime = Math.max(100, Math.min(600, lifetime));
        transparency = Math.max(0.0f, Math.min(1.0f, transparency));
        radius = Math.max(1, Math.min(100, radius));
        POSITION_INTENSITY.put(posKey, Float.valueOf(intensity));
        POSITION_LIFETIME.put(posKey, lifetime);
        POSITION_VELOCITY.put(posKey, Float.valueOf(velocity));
        POSITION_COLOR.put(posKey, color);
        POSITION_TRANSPARENCY.put(posKey, Float.valueOf(transparency));
        POSITION_RADIUS.put(posKey, radius);
        POSITION_ENABLED.put(posKey, enabled);
        lastUsedIntensity = intensity;
        lastUsedVelocity = velocity;
        lastUsedLifetime = lifetime;
        lastUsedColor = color;
        lastUsedTransparency = transparency;
        lastUsedRadius = radius;
        lastUsedEnabled = enabled;
        Hisea.LOGGER.info("[Hisea] Cached settings for {}: intensity={}, lifetime={}, velocity={}, color=#{}, transparency={}, radius={}, enabled={}", new Object[]{immutablePos, Float.valueOf(intensity), lifetime, Float.valueOf(velocity), Integer.toHexString(color), Float.valueOf(transparency), radius, enabled});
        Hisea.LOGGER.info("[Hisea] Updated last used settings for new blocks");
    }

    private static String posToKey(class_2338 pos) {
        return pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260();
    }

    public static Float getIntensity(class_2338 pos) {
        String key = MistSettings.posToKey(pos);
        return POSITION_INTENSITY.get(key);
    }

    public static Integer getLifetime(class_2338 pos) {
        String key = MistSettings.posToKey(pos);
        return POSITION_LIFETIME.get(key);
    }

    public static Float getVelocity(class_2338 pos) {
        String key = MistSettings.posToKey(pos);
        return POSITION_VELOCITY.get(key);
    }

    public static Integer getColor(class_2338 pos) {
        String key = MistSettings.posToKey(pos);
        return POSITION_COLOR.get(key);
    }

    public static Float getTransparency(class_2338 pos) {
        String key = MistSettings.posToKey(pos);
        return POSITION_TRANSPARENCY.get(key);
    }

    public static Integer getRadius(class_2338 pos) {
        String key = MistSettings.posToKey(pos);
        return POSITION_RADIUS.get(key);
    }

    public static Boolean isEnabled(class_2338 pos) {
        String key = MistSettings.posToKey(pos);
        return POSITION_ENABLED.get(key);
    }

    public static boolean hasSettings(class_2338 pos) {
        String key = MistSettings.posToKey(pos);
        return POSITION_INTENSITY.containsKey(key) && POSITION_ENABLED.containsKey(key);
    }

    public static boolean hasRecentUpdate(class_2338 pos) {
        String key = MistSettings.posToKey(pos);
        Long lastUpdate = POSITION_LAST_UPDATE.get(key);
        if (lastUpdate != null) {
            long fiveSecondsAgo = System.currentTimeMillis() - 5000L;
            return lastUpdate > fiveSecondsAgo;
        }
        return false;
    }

    public static void resetAllSettings() {
        BLOCK_POS_LOOKUP.clear();
        POSITION_INTENSITY.clear();
        POSITION_LIFETIME.clear();
        POSITION_VELOCITY.clear();
        POSITION_COLOR.clear();
        POSITION_TRANSPARENCY.clear();
        POSITION_RADIUS.clear();
        POSITION_ENABLED.clear();
        POSITION_LAST_UPDATE.clear();
        INTENSITY_CACHE.clear();
        LIFETIME_CACHE.clear();
        VELOCITY_CACHE.clear();
        COLOR_CACHE.clear();
        TRANSPARENCY_CACHE.clear();
        RADIUS_CACHE.clear();
        ENABLED_CACHE.clear();
        LAST_UPDATE_TIME.clear();
        lastUsedIntensity = 1.0f;
        lastUsedEnabled = true;
        lastUsedVelocity = 1.0f;
        lastUsedLifetime = 300;
        lastUsedColor = 0xFFFFFF;
        lastUsedTransparency = 1.0f;
        lastUsedRadius = 3;
        initialWorldLoad = true;
        Hisea.LOGGER.info("[Hisea] CRITICAL: Cleared all client-side cached settings and reset last used defaults");
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7b[Hisea] Reset all mist settings and defaults"), false);
        }
    }

    public static void markPostInitialLoad() {
        initialWorldLoad = false;
        Hisea.LOGGER.info("[Hisea] Marked client as post-initial world load");
    }

    public static boolean isInitialWorldLoad() {
        return initialWorldLoad;
    }

    public static void logAllSettings() {
        Hisea.LOGGER.info("[Hisea] ===== CLIENT SETTINGS CACHE CONTENTS =====");
        Hisea.LOGGER.info("[Hisea] Total positions in cache: {}", (Object)POSITION_INTENSITY.size());
        for (Map.Entry<String, Boolean> entry : POSITION_ENABLED.entrySet()) {
            String key = entry.getKey();
            class_2338 pos = BLOCK_POS_LOOKUP.get(key);
            Boolean enabled = entry.getValue();
            Float intensity = POSITION_INTENSITY.getOrDefault(key, Float.valueOf(0.0f));
            Float velocity = POSITION_VELOCITY.getOrDefault(key, Float.valueOf(1.0f));
            Integer lifetime = POSITION_LIFETIME.getOrDefault(key, 300);
            Long lastUpdate = POSITION_LAST_UPDATE.getOrDefault(key, 0L);
            long secondsAgo = (System.currentTimeMillis() - lastUpdate) / 1000L;
            Integer color = POSITION_COLOR.getOrDefault(key, 0xFFFFFF);
            Float transparency = POSITION_TRANSPARENCY.getOrDefault(key, Float.valueOf(1.0f));
            Integer radius = POSITION_RADIUS.getOrDefault(key, 3);
            String posDisplay = pos != null ? pos.toString() : key;
            Hisea.LOGGER.info("[Hisea] Block at {}: enabled={}, intensity={}, velocity={}, lifetime={}, color=#{}, transparency={}, radius={}, updated {} seconds ago", new Object[]{posDisplay, enabled, intensity, velocity, lifetime, Integer.toHexString(color), transparency, radius, secondsAgo});
        }
        Hisea.LOGGER.info("[Hisea] Last used settings: enabled={}, intensity={}, velocity={}, lifetime={}, color=#{}, transparency={}, radius={}", new Object[]{lastUsedEnabled, Float.valueOf(lastUsedIntensity), Float.valueOf(lastUsedVelocity), lastUsedLifetime, Integer.toHexString(lastUsedColor), Float.valueOf(lastUsedTransparency), lastUsedRadius});
        Hisea.LOGGER.info("[Hisea] =========================================");
    }

    public static float getLastUsedIntensity() {
        return lastUsedIntensity;
    }

    public static boolean getLastUsedEnabled() {
        return lastUsedEnabled;
    }

    public static float getLastUsedVelocity() {
        return lastUsedVelocity;
    }

    public static int getLastUsedLifetime() {
        return lastUsedLifetime;
    }

    public static int getLastUsedColor() {
        return lastUsedColor;
    }

    public static float getLastUsedTransparency() {
        return lastUsedTransparency;
    }

    public static int getLastUsedRadius() {
        return lastUsedRadius;
    }

    public static void applyLastUsedSettings(class_2338 pos, ArdaMistBlockEntity blockEntity) {
        if (blockEntity != null) {
            blockEntity.setMistIntensity(lastUsedIntensity);
            blockEntity.setMistVelocity(lastUsedVelocity);
            blockEntity.setMistLifetime(lastUsedLifetime);
            blockEntity.setMistColor(lastUsedColor);
            blockEntity.setMistTransparency(lastUsedTransparency);
            blockEntity.setMistRadius(lastUsedRadius);
            blockEntity.setMistEnabled(lastUsedEnabled);
            MistSettings.saveFullSettingsWithColor(pos, lastUsedIntensity, lastUsedEnabled, lastUsedVelocity, lastUsedLifetime, lastUsedColor, lastUsedTransparency, lastUsedRadius);
            Hisea.LOGGER.info("[Hisea] Applied last used settings to new block at {}", (Object)pos);
        }
    }
}

