/*
 * Decompiled with CFR 0.152.
 */
package arda.hisea.networking;

import arda.hisea.Hisea;
import arda.hisea.block.entity.ArdaMistBlockEntity;
import arda.hisea.networking.MistNetworking;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ClientMistNetworking {
    public static void sendMistSettingsUpdate(class_2338 pos, float intensity, boolean enabled) {
        int lifetime = 300;
        float velocity = 1.0f;
        try {
            class_2586 be;
            class_310 client = class_310.method_1551();
            if (client.field_1687 != null && (be = client.field_1687.method_8321(pos)) instanceof ArdaMistBlockEntity) {
                ArdaMistBlockEntity mistBE = (ArdaMistBlockEntity)be;
                lifetime = mistBE.getMistLifetime();
                velocity = mistBE.getMistVelocity();
            }
        }
        catch (Exception e) {
            Hisea.LOGGER.error("[Hisea] Error getting current lifetime/velocity values: {}", (Object)e.getMessage());
        }
        ClientMistNetworking.sendFullMistSettingsUpdate(pos, intensity, velocity, lifetime, enabled);
    }

    public static void sendFullMistSettingsUpdate(class_2338 pos, float intensity, float velocity, int lifetime, boolean enabled) {
        int color = 0xFFFFFF;
        try {
            class_2586 be;
            class_310 client = class_310.method_1551();
            if (client.field_1687 != null && (be = client.field_1687.method_8321(pos)) instanceof ArdaMistBlockEntity) {
                ArdaMistBlockEntity mistBE = (ArdaMistBlockEntity)be;
                color = mistBE.getMistColor();
            }
        }
        catch (Exception e) {
            Hisea.LOGGER.error("[Hisea] Error getting current color value: {}", (Object)e.getMessage());
        }
        ClientMistNetworking.sendFullMistSettingsUpdate(pos, intensity, velocity, lifetime, enabled, color);
    }

    public static void sendFullMistSettingsUpdate(class_2338 pos, float intensity, float velocity, int lifetime, boolean enabled, int color) {
        ClientMistNetworking.sendFullMistSettingsUpdate(pos, intensity, velocity, lifetime, enabled, color, 1.0f);
    }

    public static void sendFullMistSettingsUpdate(class_2338 pos, float intensity, float velocity, int lifetime, boolean enabled, int color, float transparency) {
        ClientMistNetworking.sendFullMistSettingsUpdate(pos, intensity, velocity, lifetime, enabled, color, transparency, 3);
    }

    public static void sendFullMistSettingsUpdate(class_2338 pos, float intensity, float velocity, int lifetime, boolean enabled, int color, float transparency, int radius) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.method_1562() == null) {
            Hisea.LOGGER.error("[Hisea] Cannot send network packet: player or network handler is null");
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        buf.writeFloat(intensity);
        buf.writeInt(lifetime);
        buf.writeFloat(velocity);
        buf.writeBoolean(enabled);
        buf.writeInt(color);
        buf.writeFloat(transparency);
        buf.writeInt(radius);
        client.method_1562().method_2883((class_2596)new class_2817(MistNetworking.UPDATE_MIST_SETTINGS, buf));
        Hisea.LOGGER.info("[Hisea] Sent full settings update packet to server: pos={}, intensity={}, velocity={}, lifetime={}, color=#{}, transparency={}, radius={}, enabled={}", new Object[]{pos, Float.valueOf(intensity), Float.valueOf(velocity), lifetime, Integer.toHexString(color), Float.valueOf(transparency), radius, enabled});
    }

    public static void sendClearMistRequest(class_2338 pos) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.method_1562() == null) {
            Hisea.LOGGER.error("[Hisea] Cannot send clear mist packet: player or network handler is null");
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        client.method_1562().method_2883((class_2596)new class_2817(MistNetworking.CLEAR_MIST_PARTICLES, buf));
        if (client.field_1687 != null) {
            client.field_1687.method_8413(pos, client.field_1687.method_8320(pos), client.field_1687.method_8320(pos), 3);
            Hisea.LOGGER.info("[Hisea] Cleared mist particles for block at {}", (Object)pos);
        }
    }

    public static void requestMistSettings(class_2338 pos) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.method_1562() == null) {
            Hisea.LOGGER.error("[Hisea] Cannot send settings request packet: player or network handler is null");
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        client.method_1562().method_2883((class_2596)new class_2817(MistNetworking.REQUEST_MIST_SETTINGS, buf));
        Hisea.LOGGER.info("[Hisea] Requested mist settings from server for block at {}", (Object)pos);
    }
}

