/*
 * Decompiled with CFR 0.152.
 */
package arda.hisea.networking;

import arda.hisea.Hisea;
import arda.hisea.block.ArdaMistBlock;
import arda.hisea.block.entity.ArdaMistBlockEntity;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class MistNetworking {
    public static final class_2960 UPDATE_MIST_SETTINGS = new class_2960("hisea", "update_mist_settings");
    public static final class_2960 CLEAR_MIST_PARTICLES = new class_2960("hisea", "clear_mist_particles");
    public static final class_2960 REQUEST_MIST_SETTINGS = new class_2960("hisea", "request_mist_settings");
    public static final class_2960 SYNC_MIST_SETTINGS = new class_2960("hisea", "sync_mist_settings");

    public static void registerServerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)UPDATE_MIST_SETTINGS, (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            float intensity = buf.readFloat();
            int lifetime = buf.readInt();
            float velocity = buf.readFloat();
            boolean enabled = buf.readBoolean();
            int color = buf.readableBytes() > 0 ? buf.readInt() : 0xFFFFFF;
            float transparency = buf.readableBytes() > 0 ? buf.readFloat() : 1.0f;
            int radius = buf.readableBytes() > 0 ? buf.readInt() : 3;
            Hisea.LOGGER.info("[Hisea] Server received settings update packet: pos={}, intensity={}, velocity={}, lifetime={}, color=#{}, transparency={}, radius={}, enabled={}", new Object[]{pos, Float.valueOf(intensity), Float.valueOf(velocity), lifetime, Integer.toHexString(color), Float.valueOf(transparency), radius, enabled});
            server.execute(() -> {
                if (player.method_37908().method_8393(pos.method_10263() >> 4, pos.method_10260() >> 4)) {
                    if (player.method_37908().method_8320(pos).method_26204() instanceof ArdaMistBlock) {
                        ArdaMistBlockEntity blockEntity = ArdaMistBlock.getBlockEntity(player.method_37908(), pos);
                        if (blockEntity != null) {
                            blockEntity.setMistIntensity(intensity);
                            blockEntity.setMistVelocity(velocity);
                            blockEntity.setMistLifetime(lifetime);
                            blockEntity.setMistEnabled(enabled);
                            blockEntity.setMistColor(color);
                            blockEntity.setMistTransparency(transparency);
                            blockEntity.setMistRadius(radius);
                            blockEntity.method_5431();
                            player.method_37908().method_8413(pos, player.method_37908().method_8320(pos), player.method_37908().method_8320(pos), 3);
                            Hisea.LOGGER.info("[Hisea] Updated BlockEntity settings on server: intensity={}, velocity={}, lifetime={}, color=#{}, transparency={}, radius={}, enabled={}", new Object[]{Float.valueOf(intensity), Float.valueOf(velocity), lifetime, Integer.toHexString(color), Float.valueOf(transparency), radius, enabled});
                        } else {
                            Hisea.LOGGER.warn("[Hisea] Could not find BlockEntity at {} to update", (Object)pos);
                        }
                    } else {
                        Hisea.LOGGER.warn("[Hisea] Block at {} is not an ArdaMistBlock", (Object)pos);
                    }
                } else {
                    Hisea.LOGGER.warn("[Hisea] Chunk not loaded for position {}", (Object)pos);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQUEST_MIST_SETTINGS, (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            Hisea.LOGGER.info("[Hisea] Server received settings request for pos={}", (Object)pos);
            server.execute(() -> {
                if (player.method_37908().method_8393(pos.method_10263() >> 4, pos.method_10260() >> 4)) {
                    if (player.method_37908().method_8320(pos).method_26204() instanceof ArdaMistBlock) {
                        ArdaMistBlockEntity blockEntity = ArdaMistBlock.getBlockEntity(player.method_37908(), pos);
                        if (blockEntity != null) {
                            class_2540 responseBuffer = PacketByteBufs.create();
                            responseBuffer.method_10807(pos);
                            responseBuffer.writeFloat(blockEntity.getMistIntensity());
                            responseBuffer.writeInt(blockEntity.getMistLifetime());
                            responseBuffer.writeFloat(blockEntity.getMistVelocity());
                            responseBuffer.writeBoolean(blockEntity.isMistEnabled());
                            responseBuffer.writeInt(blockEntity.getMistColor());
                            responseBuffer.writeFloat(blockEntity.getMistTransparency());
                            responseBuffer.writeInt(blockEntity.getMistRadius());
                            ServerPlayNetworking.send((class_3222)player, (class_2960)SYNC_MIST_SETTINGS, (class_2540)responseBuffer);
                            Hisea.LOGGER.info("[Hisea] Sent settings for mist block at {} to player {}", (Object)pos, (Object)player.method_5477().getString());
                        } else {
                            Hisea.LOGGER.warn("[Hisea] Could not find BlockEntity at {} to sync", (Object)pos);
                        }
                    } else {
                        Hisea.LOGGER.warn("[Hisea] Block at {} is not an ArdaMistBlock", (Object)pos);
                    }
                } else {
                    Hisea.LOGGER.warn("[Hisea] Chunk not loaded for position {}", (Object)pos);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CLEAR_MIST_PARTICLES, (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            Hisea.LOGGER.info("[Hisea] Server received clear mist particles request for pos={}", (Object)pos);
            server.execute(() -> {
                if (player.method_37908().method_8393(pos.method_10263() >> 4, pos.method_10260() >> 4)) {
                    if (player.method_37908().method_8320(pos).method_26204() instanceof ArdaMistBlock) {
                        player.method_37908().method_8413(pos, player.method_37908().method_8320(pos), player.method_37908().method_8320(pos), 3);
                        Hisea.LOGGER.info("[Hisea] Cleared mist particles at {} for all clients", (Object)pos);
                    } else {
                        Hisea.LOGGER.warn("[Hisea] Block at {} is not an ArdaMistBlock", (Object)pos);
                    }
                } else {
                    Hisea.LOGGER.warn("[Hisea] Chunk not loaded for position {}", (Object)pos);
                }
            });
        });
    }
}

