/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.thirstbar;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class WaterBarPlugin
extends JavaPlugin
implements Listener {
    private static final NamespacedKey DIRTY_WATER_KEY = new NamespacedKey("thirstbar", "dirty_water");
    private static final NamespacedKey CLEAN_WATER_KEY = new NamespacedKey("thirstbar", "clean_water");
    private static final NamespacedKey WATERSKIN_KEY = new NamespacedKey("thirstbar", "waterskin");
    private static final NamespacedKey WATERSKIN_CHARGES_KEY = new NamespacedKey("thirstbar", "waterskin_charges");
    private static final NamespacedKey WATERSKIN_DIRTY_KEY = new NamespacedKey("thirstbar", "waterskin_dirty");
    private final Random random = new Random();
    private FileConfiguration config;
    private final Map<UUID, Double> playerWater = new ConcurrentHashMap<UUID, Double>();
    private final Map<UUID, BukkitRunnable> damageTasks = new HashMap<UUID, BukkitRunnable>();
    private final Map<String, Double> biomeLossRates = new HashMap<String, Double>();
    private File playerDataFile;
    private FileConfiguration playerConfig;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.loadBiomeLossRates();
        this.playerDataFile = new File(this.getDataFolder(), "player.yml");
        if (!this.playerDataFile.exists()) {
            try {
                this.playerDataFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create player.yml");
                e.printStackTrace();
            }
        }
        this.playerConfig = YamlConfiguration.loadConfiguration((File)this.playerDataFile);
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.loadPlayerData(player.getUniqueId());
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.registerCraftingRecipes();
        this.registerCampfireRecipes();
        new BukkitRunnable(){

            public void run() {
                for (UUID uuid : WaterBarPlugin.this.playerWater.keySet()) {
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player == null || !player.isOnline()) continue;
                    WaterBarPlugin.this.updatePlayerThirst(player);
                }
            }
        }.runTaskTimer((Plugin)this, 200L, 200L);
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    WaterBarPlugin.this.updateWaterBarDisplay(player);
                }
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
        new BukkitRunnable(){

            public void run() {
                WaterBarPlugin.this.saveAllPlayerDataAsync();
            }
        }.runTaskTimerAsynchronously((Plugin)this, 6000L, 6000L);
        this.startCauldronFiller();
    }

    private void startCauldronFiller() {
        long fillRate = this.config.getLong("cauldron.fill-rate-ticks", 100L);
        final double fillChance = this.config.getDouble("cauldron.fill-chance", 0.25);
        new BukkitRunnable(){

            public void run() {
                for (World world : Bukkit.getWorlds()) {
                    if (!world.hasStorm()) continue;
                    for (Chunk chunk : world.getLoadedChunks()) {
                        for (BlockState blockState : chunk.getTileEntities()) {
                            if (blockState.getType() != Material.CAULDRON || blockState.getBlock().getLocation().getBlock().getLightFromSky() != 15 || !(WaterBarPlugin.this.random.nextDouble() < fillChance)) continue;
                            WaterBarPlugin.this.fillCauldron(blockState);
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)this, fillRate, fillRate);
    }

    private void fillCauldron(BlockState cauldronState) {
        Levelled levelled;
        if (cauldronState.getBlock().getBlockData() instanceof Levelled && (levelled = (Levelled)cauldronState.getBlock().getBlockData()).getLevel() < levelled.getMaximumLevel()) {
            levelled.setLevel(levelled.getLevel() + 1);
            cauldronState.getBlock().setBlockData((BlockData)levelled);
        }
    }

    private void loadBiomeLossRates() {
        double hotLoss = this.config.getDouble("water-loss.hot-loss", 0.66);
        double coldLoss = this.config.getDouble("water-loss.cold-loss", 0.16);
        double defaultLoss = this.config.getDouble("water-loss.default-loss", 0.33);
        for (String biome : this.config.getStringList("water-loss.hot-biomes")) {
            this.biomeLossRates.put(biome.toUpperCase(Locale.ROOT), hotLoss);
        }
        for (String biome : this.config.getStringList("water-loss.cold-biomes")) {
            this.biomeLossRates.put(biome.toUpperCase(Locale.ROOT), coldLoss);
        }
        this.biomeLossRates.put("DEFAULT", defaultLoss);
    }

    private void loadPlayerData(UUID uuid) {
        String key = uuid.toString();
        if (!this.playerConfig.contains(key)) {
            this.playerConfig.set(key + ".water", (Object)this.config.getInt("water-levels.starting-water", 100));
            this.savePlayerConfigAsync();
        }
        double waterLevel = this.playerConfig.getDouble(key + ".water", (double)this.config.getInt("water-levels.starting-water", 100));
        this.playerWater.put(uuid, waterLevel);
    }

    private void savePlayerConfigAsync() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                this.playerConfig.save(this.playerDataFile);
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to save player.yml");
                e.printStackTrace();
            }
        });
    }

    private void saveAllPlayerDataAsync() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            for (Map.Entry<UUID, Double> entry : this.playerWater.entrySet()) {
                this.playerConfig.set(entry.getKey().toString() + ".water", (Object)entry.getValue());
            }
            try {
                this.playerConfig.save(this.playerDataFile);
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to save player.yml");
                e.printStackTrace();
            }
        });
    }

    private void registerCampfireRecipes() {
        CampfireRecipe campfireRecipe = new CampfireRecipe(new NamespacedKey((Plugin)this, "purify_water_campfire"), this.createWaterBottle(false), (RecipeChoice)new RecipeChoice.ExactChoice(this.createWaterBottle(true)), 0.35f, 1200);
        this.getServer().addRecipe((Recipe)campfireRecipe);
        CampfireRecipe waterskinRecipe = new CampfireRecipe(new NamespacedKey((Plugin)this, "purify_waterskin_campfire"), this.createWaterskin(this.config.getInt("waterskin.max-charges", 3), false), (RecipeChoice)new RecipeChoice.ExactChoice(this.createWaterskin(this.config.getInt("waterskin.max-charges", 3), true)), 0.5f, this.config.getInt("waterskin.purification-time-ticks", 600));
        this.getServer().addRecipe((Recipe)waterskinRecipe);
    }

    private void registerCraftingRecipes() {
        ShapelessRecipe recipe = new ShapelessRecipe(new NamespacedKey((Plugin)this, "craft_dirty_water"), this.createWaterBottle(true));
        recipe.addIngredient(Material.GLASS_BOTTLE);
        recipe.addIngredient(Material.DIRT);
        this.getServer().addRecipe((Recipe)recipe);
        ShapedRecipe waterskinRecipe = new ShapedRecipe(new NamespacedKey((Plugin)this, "craft_waterskin"), this.createWaterskin(0, false));
        waterskinRecipe.shape(new String[]{"LSL", "SGS", "LSL"});
        waterskinRecipe.setIngredient('L', Material.LEATHER);
        waterskinRecipe.setIngredient('S', Material.STRING);
        waterskinRecipe.setIngredient('G', Material.GLASS_BOTTLE);
        this.getServer().addRecipe((Recipe)waterskinRecipe);
    }

    public void onDisable() {
        for (Map.Entry<UUID, Double> entry : this.playerWater.entrySet()) {
            this.playerConfig.set(entry.getKey().toString() + ".water", (Object)entry.getValue());
        }
        try {
            this.playerConfig.save(this.playerDataFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save player.yml on disable");
            e.printStackTrace();
        }
        this.damageTasks.values().forEach(BukkitRunnable::cancel);
        this.damageTasks.clear();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (cmd.getName().equalsIgnoreCase("water")) {
            if (args.length == 0) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /water <check|give|help>");
                return true;
            }
            switch (args[0].toLowerCase(Locale.ROOT)) {
                case "check": {
                    double waterLevel = this.playerWater.getOrDefault(player.getUniqueId(), 100.0);
                    player.sendMessage(String.valueOf(ChatColor.AQUA) + "Your water level: " + (int)waterLevel + "/100");
                    return true;
                }
                case "give": {
                    ItemStack item;
                    if (!player.hasPermission("thirstbar.admin")) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "No permission!");
                        return true;
                    }
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/water give <clean|dirty|waterskin>");
                        return true;
                    }
                    if (args[1].equalsIgnoreCase("waterskin")) {
                        item = this.createWaterskin(0, false);
                    } else {
                        boolean dirty = args[1].equalsIgnoreCase("dirty");
                        item = this.createWaterBottle(dirty);
                    }
                    HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
                    if (!leftover.isEmpty()) {
                        player.getWorld().dropItemNaturally(player.getLocation(), (ItemStack)leftover.values().iterator().next());
                    }
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Given " + args[1].toLowerCase(Locale.ROOT) + " item.");
                    return true;
                }
                case "help": {
                    player.sendMessage(String.valueOf(ChatColor.GOLD) + "Water Commands:");
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/water check " + String.valueOf(ChatColor.WHITE) + "- Check your water level");
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/water give <clean|dirty|waterskin> " + String.valueOf(ChatColor.WHITE) + "- Give yourself an item (admin only)");
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/water help " + String.valueOf(ChatColor.WHITE) + "- Show this help");
                    return true;
                }
            }
            player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown command. Use /water help");
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.loadPlayerData(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        BukkitRunnable task = this.damageTasks.remove(uuid);
        if (task != null) {
            task.cancel();
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Action action;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (!(!this.isWaterskin(item) || (action = event.getAction()) != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK || action == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && this.isWaterSource(event.getClickedBlock()))) {
            this.drinkFromWaterskin(player, item);
            event.setCancelled(true);
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null || !this.isWaterSource(clickedBlock)) {
            return;
        }
        event.setCancelled(true);
        if (item.getType() == Material.GLASS_BOTTLE) {
            this.fillGlassBottle(player);
            return;
        }
        if (this.isWaterskin(item) && this.getWaterskinCharges(item) == 0) {
            this.fillWaterskin(player, item);
            return;
        }
    }

    private void fillWaterskin(Player player, ItemStack waterskin) {
        int maxCharges = this.config.getInt("waterskin.max-charges", 3);
        ItemStack fullDirtyWaterskin = this.createWaterskin(maxCharges, true);
        waterskin.setAmount(waterskin.getAmount() - 1);
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{fullDirtyWaterskin});
        if (!leftover.isEmpty()) {
            player.getWorld().dropItemNaturally(player.getLocation(), (ItemStack)leftover.values().iterator().next());
        }
    }

    private void drinkFromWaterskin(Player player, ItemStack waterskin) {
        double newWater;
        int charges = this.getWaterskinCharges(waterskin);
        if (charges <= 0) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(String.valueOf(ChatColor.RED) + "Waterskin is empty!"));
            return;
        }
        boolean isDirty = this.isWaterskinDirty(waterskin);
        UUID uuid = player.getUniqueId();
        int maxWater = this.config.getInt("water-levels.max-water", 100);
        double currentWater = this.playerWater.getOrDefault(uuid, Double.valueOf(maxWater));
        if (isDirty) {
            restoreAmount = this.config.getInt("water-levels.dirty-water-restore", 5);
            newWater = Math.min((double)maxWater, currentWater + (double)restoreAmount);
            int poisonDuration = this.config.getInt("effects.dirty-water.poison-duration", 100);
            int poisonStrength = this.config.getInt("effects.dirty-water.poison-strength", 0);
            player.addPotionEffect(new PotionEffect(PotionEffectType.POISON, poisonDuration, poisonStrength));
        } else {
            restoreAmount = this.config.getInt("water-levels.clean-water-restore", 20);
            newWater = Math.min((double)maxWater, currentWater + (double)restoreAmount);
        }
        this.playerWater.put(uuid, newWater);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(String.valueOf(ChatColor.AQUA) + "You take a drink."));
        int newCharges = charges - 1;
        if (newCharges == 0) {
            player.getInventory().setItemInMainHand(this.createWaterskin(0, false));
        } else {
            player.getInventory().setItemInMainHand(this.createWaterskin(newCharges, isDirty));
        }
    }

    private boolean isWaterSource(Block block) {
        if (block.getType() == Material.WATER) {
            return true;
        }
        if (block.getBlockData() instanceof Waterlogged) {
            return ((Waterlogged)block.getBlockData()).isWaterlogged();
        }
        return false;
    }

    private void fillGlassBottle(Player player) {
        boolean removed = this.removeOneGlassBottle(player);
        if (!removed) {
            return;
        }
        int chance = this.random.nextInt(100);
        ItemStack waterBottle = chance < 80 ? this.createWaterBottle(true) : this.createWaterBottle(false);
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{waterBottle});
        if (!leftover.isEmpty()) {
            player.getWorld().dropItemNaturally(player.getLocation(), (ItemStack)leftover.values().iterator().next());
        }
    }

    private boolean removeOneGlassBottle(Player player) {
        PlayerInventory inv = player.getInventory();
        for (int slot = 0; slot < inv.getSize(); ++slot) {
            ItemStack item = inv.getItem(slot);
            if (item == null || item.getType() != Material.GLASS_BOTTLE) continue;
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                inv.setItem(slot, item);
            } else {
                inv.setItem(slot, null);
            }
            return true;
        }
        return false;
    }

    private ItemStack createWaterBottle(boolean isDirty) {
        ItemStack bottle = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)bottle.getItemMeta();
        if (meta == null) {
            return bottle;
        }
        NamespacedKey key = isDirty ? DIRTY_WATER_KEY : CLEAN_WATER_KEY;
        meta.setDisplayName(isDirty ? String.valueOf(ChatColor.DARK_GRAY) + "Dirty Water" : String.valueOf(ChatColor.AQUA) + "Clean Water");
        meta.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)1);
        meta.setLore(isDirty ? Collections.singletonList(String.valueOf(ChatColor.GRAY) + "Can be purified in a furnace or campfire") : Collections.singletonList(String.valueOf(ChatColor.BLUE) + "Safe to drink"));
        bottle.setItemMeta((ItemMeta)meta);
        return bottle;
    }

    private ItemStack createWaterskin(int charges, boolean isDirty) {
        ItemStack waterskin = new ItemStack(Material.LEATHER);
        ItemMeta meta = waterskin.getItemMeta();
        if (meta == null) {
            return waterskin;
        }
        int maxCharges = this.config.getInt("waterskin.max-charges", 3);
        meta.getPersistentDataContainer().set(WATERSKIN_KEY, PersistentDataType.BYTE, (Object)1);
        meta.getPersistentDataContainer().set(WATERSKIN_CHARGES_KEY, PersistentDataType.INTEGER, (Object)charges);
        meta.getPersistentDataContainer().set(WATERSKIN_DIRTY_KEY, PersistentDataType.BYTE, (Object)((byte)(isDirty ? 1 : 0)));
        meta.setDisplayName(isDirty ? String.valueOf(ChatColor.DARK_GRAY) + "Dirty Waterskin" : String.valueOf(ChatColor.AQUA) + "Waterskin");
        meta.addEnchant(Enchantment.INFINITY, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        if (charges == 0) {
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Empty")));
        } else {
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Charges: " + charges + "/" + maxCharges)));
        }
        meta.setLore(lore);
        waterskin.setItemMeta(meta);
        return waterskin;
    }

    private boolean isWaterskin(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().getPersistentDataContainer().has(WATERSKIN_KEY);
    }

    private int getWaterskinCharges(ItemStack waterskin) {
        if (!this.isWaterskin(waterskin)) {
            return 0;
        }
        return (Integer)waterskin.getItemMeta().getPersistentDataContainer().getOrDefault(WATERSKIN_CHARGES_KEY, PersistentDataType.INTEGER, (Object)0);
    }

    private boolean isWaterskinDirty(ItemStack waterskin) {
        if (!this.isWaterskin(waterskin)) {
            return false;
        }
        return (Byte)waterskin.getItemMeta().getPersistentDataContainer().getOrDefault(WATERSKIN_DIRTY_KEY, PersistentDataType.BYTE, (Object)0) == 1;
    }

    @EventHandler
    public void onPlayerDrink(PlayerItemConsumeEvent event) {
        if (event.getItem() == null || !event.getItem().hasItemMeta()) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        ItemStack consumedItem = event.getItem();
        if (consumedItem.getItemMeta().getPersistentDataContainer().has(DIRTY_WATER_KEY)) {
            int maxWater = this.config.getInt("water-levels.max-water", 100);
            int restoreAmount = this.config.getInt("water-levels.dirty-water-restore", 5);
            double currentWater = this.playerWater.getOrDefault(uuid, Double.valueOf(maxWater));
            double newWater = Math.min((double)maxWater, currentWater + (double)restoreAmount);
            this.playerWater.put(uuid, newWater);
            int poisonDuration = this.config.getInt("effects.dirty-water.poison-duration", 100);
            int poisonStrength = this.config.getInt("effects.dirty-water.poison-strength", 0);
            player.addPotionEffect(new PotionEffect(PotionEffectType.POISON, poisonDuration, poisonStrength));
        } else if (consumedItem.getItemMeta().getPersistentDataContainer().has(CLEAN_WATER_KEY)) {
            int maxWater = this.config.getInt("water-levels.max-water", 100);
            int restoreAmount = this.config.getInt("water-levels.clean-water-restore", 20);
            double currentWater = this.playerWater.getOrDefault(uuid, Double.valueOf(maxWater));
            double newWater = Math.min((double)maxWater, currentWater + (double)restoreAmount);
            this.playerWater.put(uuid, newWater);
        }
    }

    @EventHandler
    public void onFurnaceStart(FurnaceStartSmeltEvent event) {
        if (this.isDirtyWater(event.getSource())) {
            this.notifyNearbyPlayers(event.getBlock(), String.valueOf(ChatColor.GOLD) + "Water purification started...");
        }
    }

    @EventHandler
    public void onFurnaceCook(FurnaceSmeltEvent event) {
        if (this.isDirtyWater(event.getSource())) {
            event.setResult(this.createWaterBottle(false));
            this.notifyNearbyPlayers(event.getBlock(), String.valueOf(ChatColor.GREEN) + "Water purified in furnace!");
        } else if (this.isWaterskin(event.getSource()) && this.isWaterskinDirty(event.getSource())) {
            int maxCharges = this.config.getInt("waterskin.max-charges", 3);
            event.setResult(this.createWaterskin(maxCharges, false));
            this.notifyNearbyPlayers(event.getBlock(), String.valueOf(ChatColor.GREEN) + "Waterskin purified!");
        }
    }

    private boolean isDirtyWater(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().getPersistentDataContainer().has(DIRTY_WATER_KEY);
    }

    private void notifyNearbyPlayers(Block block, String message) {
        block.getWorld().getNearbyEntities(block.getLocation(), 3.0, 3.0, 3.0).stream().filter(entity -> entity instanceof Player).map(entity -> (Player)entity).forEach(player -> player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message)));
    }

    private void updatePlayerThirst(Player player) {
        BukkitRunnable task;
        UUID uuid = player.getUniqueId();
        double currentWater = this.playerWater.getOrDefault(uuid, 100.0);
        String biomeName = player.getLocation().getBlock().getBiome().name().toUpperCase(Locale.ROOT);
        double lossRate = this.biomeLossRates.getOrDefault(biomeName, this.biomeLossRates.getOrDefault("DEFAULT", 0.33));
        double newWater = Math.max(0.0, currentWater - lossRate);
        this.playerWater.put(uuid, newWater);
        if (newWater <= 10.0) {
            int slownessDuration = this.config.getInt("effects.low-water.slowness-duration", 60);
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, slownessDuration, 0, true, false));
        }
        if (newWater <= 20.0 && newWater > 0.0 && player.getGameMode() != GameMode.CREATIVE) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(String.valueOf(ChatColor.YELLOW) + "Low water! (" + (int)newWater + "/100)"));
        }
        if (newWater <= 0.0 && !this.damageTasks.containsKey(uuid)) {
            this.startDehydrationTask(player);
        }
        if (newWater > 0.0 && this.damageTasks.containsKey(uuid) && (task = this.damageTasks.remove(uuid)) != null) {
            task.cancel();
        }
    }

    private void startDehydrationTask(final Player player) {
        final UUID uuid = player.getUniqueId();
        final int damageAmount = this.config.getInt("effects.dehydration.damage-amount", 2);
        long damageIntervalTicks = this.config.getLong("effects.dehydration.damage-interval-ticks", 80L);
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                if (!player.isOnline() || player.isDead() || WaterBarPlugin.this.playerWater.getOrDefault(uuid, 1.0) > 0.0) {
                    this.cancel();
                    WaterBarPlugin.this.damageTasks.remove(uuid);
                    return;
                }
                player.damage((double)damageAmount);
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(String.valueOf(ChatColor.RED) + "Dehydrated! (-" + (double)damageAmount / 2.0 + " hearts)"));
            }
        };
        task.runTaskTimer((Plugin)this, 0L, damageIntervalTicks);
        this.damageTasks.put(uuid, task);
    }

    private void updateWaterBarDisplay(Player player) {
        UUID uuid = player.getUniqueId();
        double waterLevel = this.playerWater.getOrDefault(uuid, 100.0);
        float waterPercentage = (float)Math.min(1.0, Math.max(0.0, waterLevel / 100.0));
        player.setExp(waterPercentage);
    }
}

