/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.additional_power;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_304;
import net.minecraft.class_3486;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.mixin.accessor.ApoliClientAccessor;

public class LevitatePower
extends Power
implements Active {
    private float ascentSpeed = 0.5f;
    private int maxAscendDuration = 40;
    private Active.Key key;
    private int ascendProgress = 0;
    private boolean wasActiveLastTick = false;
    private boolean isKeyActive = false;
    private boolean isLevitate = false;

    public LevitatePower(PowerType<?> type, class_1309 entity) {
        super(type, entity);
        this.setTicking(true);
    }

    public void onUse() {
        class_1309 class_13092 = this.entity;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            this.isKeyActive = true;
            PowerHolderComponent.syncPower((class_1297)this.entity, (PowerType)this.type);
        }
    }

    private void resetLevitateState() {
        this.isLevitate = false;
        this.ascendProgress = 0;
    }

    private float easeOutQuadProgress() {
        float a = 1.0f - (float)this.ascendProgress / (float)this.maxAscendDuration;
        return a * a;
    }

    private void processLevitate(class_1657 player) {
        this.isLevitate = true;
        player.method_5875(true);
    }

    private void processStopLevitate(class_1657 player) {
        this.isLevitate = false;
        player.method_5875(false);
    }

    public void tick() {
        class_1309 class_13092 = this.entity;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (player.method_5861(class_3486.field_15517) > 0.0 || player.method_5861(class_3486.field_15518) > 0.0) {
                this.resetLevitateState();
                return;
            }
            if (this.isKeyActive || this.wasActiveLastTick) {
                this.processLevitate(player);
            } else {
                this.processStopLevitate(player);
            }
            player.field_6017 = 0.0f;
            this.wasActiveLastTick = this.isKeyActive;
            this.isKeyActive = false;
            if (this.entity.method_24828()) {
                this.resetLevitateState();
            }
            PowerHolderComponent.syncPower((class_1297)this.entity, (PowerType)this.type);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void ClientProcessLevitate(class_1657 player) {
        class_243 velocity = player.method_18798();
        if (this.ascendProgress < this.maxAscendDuration) {
            player.method_18800(velocity.field_1352, (double)(this.ascentSpeed * this.easeOutQuadProgress()), velocity.field_1350);
            ++this.ascendProgress;
        } else {
            player.method_18800(velocity.field_1352, 0.0, velocity.field_1350);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void ClientProcessStopLevitate(class_1657 player) {
    }

    @Environment(value=EnvType.CLIENT)
    public boolean clientIsActive() {
        class_304 keyBinding = ApoliClientAccessor.get_idToKeyBindingMap().get(this.key.key);
        if (keyBinding != null) {
            return keyBinding.method_1434();
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public void clientTick(class_1657 player) {
        if (player.method_5861(class_3486.field_15517) > 0.0 || player.method_5861(class_3486.field_15518) > 0.0) {
            this.resetLevitateState();
            return;
        }
        this.isKeyActive = this.clientIsActive();
        if (this.isKeyActive || this.wasActiveLastTick) {
            this.ClientProcessLevitate(player);
        } else {
            this.ClientProcessStopLevitate(player);
        }
        this.wasActiveLastTick = this.isKeyActive;
        this.isKeyActive = false;
        if (this.entity.method_24828()) {
            this.resetLevitateState();
        }
    }

    public Active.Key getKey() {
        return this.key;
    }

    public void setKey(Active.Key key) {
        this.key = key;
    }

    public boolean isActive() {
        return this.isLevitate && super.isActive();
    }

    public void onRemoved() {
        this.entity.method_5875(false);
    }

    public static PowerFactory<?> getFactory() {
        return new PowerFactory(ShapeShifterCurseFabric.identifier("levitate"), new SerializableData().add("ascent_speed", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.5f)).add("max_ascend_duration", SerializableDataTypes.INT, (Object)40).add("key", ApoliDataTypes.BACKWARDS_COMPATIBLE_KEY, (Object)new Active.Key()).add("hud_render", ApoliDataTypes.HUD_RENDER, (Object)HudRender.DONT_RENDER), data -> (powerType, entity) -> {
            LevitatePower power = new LevitatePower((PowerType<?>)powerType, (class_1309)entity);
            power.ascentSpeed = data.getFloat("ascent_speed");
            power.maxAscendDuration = data.getInt("max_ascend_duration");
            power.setKey((Active.Key)data.get("key"));
            return power;
        }).allowCondition();
    }
}

