/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.command.CustomFormArgumentType;
import net.onixary.shapeShifterCurseFabric.command.FormArgumentType;
import net.onixary.shapeShifterCurseFabric.cursed_moon.CursedMoon;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormBase;
import net.onixary.shapeShifterCurseFabric.player_form.skin.PlayerSkinComponent;
import net.onixary.shapeShifterCurseFabric.player_form.skin.RegPlayerSkinComponent;
import net.onixary.shapeShifterCurseFabric.player_form.transform.TransformManager;
import net.onixary.shapeShifterCurseFabric.util.FormTextureUtils;

public class ShapeShifterCurseCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"shape_shifter_curse").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set_form").requires(cs -> cs.method_9259(2))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"form", (ArgumentType)FormArgumentType.form()).executes(ShapeShifterCurseCommand::setForm))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"transform_to_form").requires(cs -> cs.method_9259(2))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"form", (ArgumentType)FormArgumentType.form()).executes(ShapeShifterCurseCommand::transformToForm))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set_custom_form").requires(cs -> cs.method_9259(2))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"form", (ArgumentType)CustomFormArgumentType.form()).executes(ShapeShifterCurseCommand::setCustomForm))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"transform_to_custom_form").requires(cs -> cs.method_9259(2))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"form", (ArgumentType)CustomFormArgumentType.form()).executes(ShapeShifterCurseCommand::transformToCustomForm))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"jump_to_next_cursed_moon").requires(cs -> cs.method_9259(2))).executes(ShapeShifterCurseCommand::jumpToNextCursedMoon))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"world_time").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"time", (ArgumentType)IntegerArgumentType.integer()).executes(ShapeShifterCurseCommand::setWorldTime)))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"time", (ArgumentType)IntegerArgumentType.integer()).executes(ShapeShifterCurseCommand::addWorldTime))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"adjust_feral_item_loc").requires(cs -> cs.method_9259(2))).then(class_2170.method_9244((String)"rot_center", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"pos_offset", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"euler_x", (ArgumentType)FloatArgumentType.floatArg()).executes(ShapeShifterCurseCommand::adjustFeralItemLoc)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"keep_original_skin").requires(cs -> cs.method_9259(0))).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ShapeShifterCurseCommand::setPlayerSkin)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set_form_color").requires(cs -> cs.method_9259(0))).executes(ShapeShifterCurseCommand::logFormColorSetting)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(ShapeShifterCurseCommand::setFormColorEnable)).then(class_2170.method_9244((String)"primaryColorRGBA", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"accentColor1RGBA", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"accentColor2RGBA", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"eyeColor", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"primaryGreyReverse", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"accent1GreyReverse", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"accent2GreyReverse", (ArgumentType)BoolArgumentType.bool()).executes(ShapeShifterCurseCommand::setFormColor)))))))))));
    }

    private static int setForm(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(commandContext, (String)"target");
        PlayerFormBase form = FormArgumentType.getForm(commandContext, "form");
        class_2168 serverCommandSource = (class_2168)commandContext.getSource();
        if (form == null) {
            ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid Form Id!"));
            return 0;
        }
        TransformManager.setFormDirectly((class_1657)target, form);
        return 1;
    }

    private static int transformToForm(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(commandContext, (String)"target");
        PlayerFormBase form = FormArgumentType.getForm(commandContext, "form");
        class_2168 serverCommandSource = (class_2168)commandContext.getSource();
        if (form == null) {
            ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid Form Id!"));
            return 0;
        }
        TransformManager.handleDirectTransform((class_1657)target, form, false);
        return 1;
    }

    private static int setCustomForm(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(commandContext, (String)"target");
        PlayerFormBase form = CustomFormArgumentType.getForm(commandContext, "form");
        class_2168 serverCommandSource = (class_2168)commandContext.getSource();
        if (form == null) {
            ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid Form Id!"));
            return 0;
        }
        TransformManager.setFormDirectly((class_1657)target, form);
        return 1;
    }

    private static int transformToCustomForm(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(commandContext, (String)"target");
        PlayerFormBase form = CustomFormArgumentType.getForm(commandContext, "form");
        class_2168 serverCommandSource = (class_2168)commandContext.getSource();
        if (form == null) {
            ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid Form Id!"));
            return 0;
        }
        TransformManager.handleDirectTransform((class_1657)target, form, false);
        return 1;
    }

    private static int jumpToNextCursedMoon(CommandContext<class_2168> commandContext) {
        class_3218 world = ((class_2168)commandContext.getSource()).method_9225();
        CursedMoon.forceTriggerCursedMoon(world);
        class_2168 serverCommandSource = (class_2168)commandContext.getSource();
        serverCommandSource.method_9226(() -> class_2561.method_43470((String)"Set cursed moon to next night!"), true);
        return 1;
    }

    private static int adjustFeralItemLoc(CommandContext<class_2168> commandContext) {
        class_243 rotCenter = class_2277.method_9736(commandContext, (String)"rot_center");
        class_243 posOffset = class_2277.method_9736(commandContext, (String)"pos_offset");
        float eulerX = FloatArgumentType.getFloat(commandContext, (String)"euler_x");
        ShapeShifterCurseFabric.feralItemCenter = rotCenter;
        ShapeShifterCurseFabric.feralItemPosOffset = posOffset;
        ShapeShifterCurseFabric.feralItemEulerX = eulerX;
        class_2168 serverCommandSource = (class_2168)commandContext.getSource();
        serverCommandSource.method_9226(() -> class_2561.method_43470((String)("Location adjusted! Center : " + String.valueOf(rotCenter) + " Offset: " + String.valueOf(posOffset) + " RotationX : " + eulerX)), true);
        return 1;
    }

    private static int setPlayerSkin(CommandContext<class_2168> commandContext) {
        try {
            class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
            boolean newSetting = BoolArgumentType.getBool(commandContext, (String)"value");
            ((PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player)).setKeepOriginalSkin(newSetting);
            RegPlayerSkinComponent.SKIN_SETTINGS.sync((Object)player);
            String message = newSetting ? "Successfully set to use your original skin!" : "Successfully set to use built-in skin!";
            player.method_7353((class_2561)class_2561.method_43470((String)message), false);
            return 1;
        }
        catch (Exception e) {
            ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Error when change player skin: " + e.getMessage())));
            ShapeShifterCurseFabric.LOGGER.error("Error when change player skin: ", (Throwable)e);
            return 0;
        }
    }

    private static String getColorHexFormABGR(int color) {
        int ARGB = FormTextureUtils.ABGR2ARGB(color);
        String String2 = Integer.toHexString(ARGB);
        if (String2.length() < 8) {
            return "00000000".substring(0, 8 - String2.length()) + String2;
        }
        return String2;
    }

    private static int logFormColorSetting(CommandContext<class_2168> commandContext) {
        try {
            class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
            if (player == null) {
                ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Must be a player!"));
                return 0;
            }
            Object message = "Form color setting: \n";
            message = (String)message + "Enable: " + ((PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player)).isEnableFormColor() + "\n";
            message = (String)message + "Primary Color ARGB: " + ShapeShifterCurseCommand.getColorHexFormABGR(((PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player)).getFormColor().getPrimaryColor()) + "\n";
            message = (String)message + "Accent Color 1 ARGB: " + ShapeShifterCurseCommand.getColorHexFormABGR(((PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player)).getFormColor().getAccentColor1()) + "\n";
            message = (String)message + "Accent Color 2 ARGB: " + ShapeShifterCurseCommand.getColorHexFormABGR(((PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player)).getFormColor().getAccentColor2()) + "\n";
            message = (String)message + "Eye Color A ARGB: " + ShapeShifterCurseCommand.getColorHexFormABGR(((PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player)).getFormColor().getEyeColorA()) + "\n";
            message = (String)message + "Eye Color B ARGB: " + ShapeShifterCurseCommand.getColorHexFormABGR(((PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player)).getFormColor().getEyeColorB()) + "\n";
            message = (String)message + "Primary Grey Reverse: " + ((PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player)).getFormColor().getPrimaryGreyReverse() + "\n";
            message = (String)message + "Accent 1 Grey Reverse: " + ((PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player)).getFormColor().getAccent1GreyReverse() + "\n";
            message = (String)message + "Accent 2 Grey Reverse: " + ((PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player)).getFormColor().getAccent2GreyReverse() + "\n";
            player.method_7353((class_2561)class_2561.method_43470((String)message), false);
            return 1;
        }
        catch (Exception e) {
            ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Error when log player form color: " + e.getMessage())));
            ShapeShifterCurseFabric.LOGGER.error("Error when log player form color: ", (Throwable)e);
            return 0;
        }
    }

    private static int setFormColorEnable(CommandContext<class_2168> commandContext) {
        try {
            class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
            if (player == null) {
                ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Must be a player!"));
                return 0;
            }
            boolean enable = BoolArgumentType.getBool(commandContext, (String)"enable");
            ((PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player)).setEnableFormColor(enable);
            RegPlayerSkinComponent.SKIN_SETTINGS.sync((Object)player);
            return 1;
        }
        catch (Exception e) {
            ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Error when change player form color: " + e.getMessage())));
            ShapeShifterCurseFabric.LOGGER.error("Error when change player form color: ", (Throwable)e);
            return 0;
        }
    }

    private static int setFormColor(CommandContext<class_2168> commandContext) {
        try {
            class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
            if (player == null) {
                ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Must be a player!"));
                return 0;
            }
            boolean enable = BoolArgumentType.getBool(commandContext, (String)"enable");
            String primaryColorRGBA = StringArgumentType.getString(commandContext, (String)"primaryColorRGBA");
            String accentColor1RGBA = StringArgumentType.getString(commandContext, (String)"accentColor1RGBA");
            String accentColor2RGBA = StringArgumentType.getString(commandContext, (String)"accentColor2RGBA");
            String eyeColorA = StringArgumentType.getString(commandContext, (String)"eyeColorA");
            String eyeColorB = StringArgumentType.getString(commandContext, (String)"eyeColorB");
            if (!((PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player)).setFormColor(primaryColorRGBA, accentColor1RGBA, accentColor2RGBA, eyeColorA, eyeColorB, BoolArgumentType.getBool(commandContext, (String)"primaryGreyReverse"), BoolArgumentType.getBool(commandContext, (String)"accent1GreyReverse"), BoolArgumentType.getBool(commandContext, (String)"accent2GreyReverse"))) {
                ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid color format!"));
                return 0;
            }
            ((PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player)).setEnableFormColor(enable);
            RegPlayerSkinComponent.SKIN_SETTINGS.sync((Object)player);
            return 1;
        }
        catch (Exception e) {
            ((class_2168)commandContext.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Error when change player form color: " + e.getMessage())));
            ShapeShifterCurseFabric.LOGGER.error("Error when change player form color: ", (Throwable)e);
            return 0;
        }
    }

    private static int setWorldTime(CommandContext<class_2168> commandContext) {
        class_3218 world = ((class_2168)commandContext.getSource()).method_9225();
        world.method_29199((long)IntegerArgumentType.getInteger(commandContext, (String)"time"));
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43470((String)("World time set to " + ((class_2168)commandContext.getSource()).method_9225().method_8532())), false);
        return 1;
    }

    private static int addWorldTime(CommandContext<class_2168> commandContext) {
        class_3218 world = ((class_2168)commandContext.getSource()).method_9225();
        long TargetTime = world.method_8532() + (long)IntegerArgumentType.getInteger(commandContext, (String)"time");
        world.method_29199(TargetTime);
        ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43470((String)("World time set to " + TargetTime)), false);
        return 1;
    }
}

