/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.mixin;

import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5269;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.cursed_moon.CursedMoon;
import net.onixary.shapeShifterCurseFabric.data.CursedMoonData;
import net.onixary.shapeShifterCurseFabric.networking.ModPacketsS2CServer;
import net.onixary.shapeShifterCurseFabric.player_form.RegPlayerForms;
import net.onixary.shapeShifterCurseFabric.player_form.ability.FormAbilityManager;
import net.onixary.shapeShifterCurseFabric.player_form.ability.PlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.ability.RegPlayerFormComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1937.class})
public abstract class CursedMoonWorldMixin
implements class_1936,
AutoCloseable {
    @Mutable
    @Final
    @Shadow
    protected final class_5269 field_9232;

    protected CursedMoonWorldMixin(class_5269 properties) {
        this.field_9232 = properties;
    }

    @Inject(at={@At(value="HEAD")}, method={"tickBlockEntities"})
    public void tickBlockEntities(CallbackInfo info) {
        long timeOfDay;
        boolean isCursedPhase;
        CursedMoon.day_time = this.method_8532();
        CursedMoon.day = (int)(this.method_8532() / 24000L) + 1;
        class_1937 self = (class_1937)this;
        if (self.method_8608()) {
            return;
        }
        class_3218 world = (class_3218)self;
        long worldTime = world.method_8532();
        int currentDay = (int)(worldTime / 24000L) + 1;
        CursedMoonData data = ShapeShifterCurseFabric.cursedMoonData.getInstance();
        if (data.lastCheckedDay <= 0) {
            data.load(world);
        }
        if (currentDay > data.lastCheckedDay) {
            data.lastCheckedDay = currentDay;
            CursedMoon.resetCursedMoonForNewDay(world);
            ShapeShifterCurseFabric.LOGGER.info("Cursed moon data saved by CursedMoonWorldMixin new day reset. Moon Phase: " + world.method_30273());
            data.save(world);
            for (class_3222 player : world.method_18456()) {
                PlayerFormComponent formComp = (PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player);
                if (formComp.isMoonEffectApplied() && !formComp.isEndMoonEffectApplied()) {
                    CursedMoon.applyEndMoonEffect(player);
                    CursedMoon.midday_message_sent = false;
                }
                CursedMoon.resetMoonEffect(player);
            }
        }
        if (world.method_8510() % 20L == 0L && CursedMoon.isDaytime((class_1937)world) && (isCursedPhase = CursedMoon.isCursedMoonByPhase((class_1937)world)) && (timeOfDay = worldTime % 24000L) >= 6000L && timeOfDay < 6100L && !CursedMoon.midday_message_sent) {
            for (class_3222 player : world.method_18456()) {
                if (FormAbilityManager.getForm((class_1657)player).equals(RegPlayerForms.ORIGINAL_BEFORE_ENABLE)) continue;
                if (player.method_37908().method_27983() == class_1937.field_25179) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.before_cursed_moon").method_27692(class_124.field_1064));
                    continue;
                }
                player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.before_cursed_moon_nether").method_27692(class_124.field_1064));
            }
            CursedMoon.midday_message_sent = true;
        }
        if (world.method_8510() % 100L == 0L) {
            boolean isCursed = CursedMoon.isCursedMoon((class_1937)world);
            boolean isNight = CursedMoon.isNight((class_1937)world);
            for (class_3222 player : world.method_18456()) {
                ModPacketsS2CServer.sendCursedMoonData(player, worldTime, currentDay, isCursed, isNight);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tickEntity"})
    public <T extends class_1297> void tickEntity(Consumer<T> tickConsumer, T entity, CallbackInfo info) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            class_1937 world = player.method_37908();
            long worldTime = world.method_8532();
            int currentDay = (int)(worldTime / 24000L) + 1;
            long timeOfDay = worldTime % 24000L;
            if (player.method_37908().method_8510() % 20L == 0L) {
                boolean currentIsCursedMoon = CursedMoon.isCursedMoon(world);
                boolean currentIsNight = CursedMoon.isNight();
                ModPacketsS2CServer.sendCursedMoonData(player, CursedMoon.day_time, CursedMoon.day, currentIsCursedMoon, currentIsNight);
            }
            if (CursedMoon.isCursedMoon(world)) {
                if (player.method_6113() && !ShapeShifterCurseFabric.commonConfig.allowSleepInCursedMoon) {
                    player.method_18400();
                }
                this.shape_shifter_curse$OnCursedMoon(player, timeOfDay);
            } else {
                this.shape_shifter_curse$OnNoCursedMoon(player, timeOfDay);
            }
        }
    }

    @Shadow
    public long method_8532() {
        return this.field_9232.method_217();
    }

    @Unique
    public void shape_shifter_curse$OnNoCursedMoon(class_3222 player, long time) {
        PlayerFormComponent formComp = (PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player);
        if (formComp.isMoonEffectApplied() || formComp.isEndMoonEffectApplied()) {
            CursedMoon.resetMoonEffect(player);
        } else if (formComp.isMoonEffectApplied() && !formComp.isEndMoonEffectApplied()) {
            CursedMoon.applyEndMoonEffect(player);
            CursedMoon.midday_message_sent = false;
        }
    }

    @Unique
    public void shape_shifter_curse$OnCursedMoon(class_3222 player, long time) {
        boolean wasByCursedMoon;
        if (time >= 6000L && time < 12500L && !CursedMoon.midday_message_sent) {
            CursedMoon.midday_message_sent = true;
            if (FormAbilityManager.getForm((class_1657)player).equals(RegPlayerForms.ORIGINAL_BEFORE_ENABLE)) {
                if (player.method_37908().method_27983() != class_1937.field_25179) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.before_cursed_moon_nether").method_27692(class_124.field_1076));
                } else {
                    player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.before_cursed_moon").method_27692(class_124.field_1076));
                }
            }
        } else if (time >= 12500L && time < 23000L) {
            CursedMoon.applyMoonEffect(player);
            CursedMoon.midday_message_sent = false;
        } else if (time >= 23000L || time < 6000L) {
            CursedMoon.applyEndMoonEffect(player);
            CursedMoon.midday_message_sent = false;
        } else if (time > 6000L && player.method_37908().method_8510() % 20L == 0L && (wasByCursedMoon = ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).isByCursedMoon())) {
            ShapeShifterCurseFabric.LOGGER.info("Forced clear of cursed moon flag for player " + player.method_5477().getString() + " during non-cursed-moon period");
            ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCursedMoon(false);
            RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
            FormAbilityManager.saveForm((class_1657)player);
        }
    }
}

