/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.networking;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4174;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.networking.ModPackets;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormDynamic;
import net.onixary.shapeShifterCurseFabric.player_form.RegPlayerForms;
import net.onixary.shapeShifterCurseFabric.status_effects.attachment.PlayerEffectAttachment;
import net.onixary.shapeShifterCurseFabric.util.CustomEdibleUtils;

public class ModPacketsS2CServer {
    public static void sendCursedMoonData(class_3222 player, long dayTime, int day, boolean isCursedMoon, boolean isNight) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeLong(dayTime);
        buf.writeInt(day);
        buf.writeBoolean(isCursedMoon);
        buf.writeBoolean(isNight);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.SYNC_CURSED_MOON_DATA, (class_2540)buf);
    }

    public static void sendFormChange(class_3222 player, String newFormName) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(newFormName);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.SYNC_FORM_CHANGE, (class_2540)buf);
        ShapeShifterCurseFabric.LOGGER.info("Sent form change to client: " + newFormName);
    }

    public static void sendSyncEffectAttachment(class_3222 player, PlayerEffectAttachment attachment) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10794(attachment.toNbt());
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.SYNC_EFFECT_ATTACHMENT, (class_2540)buf);
    }

    public static void sendTransformState(class_3222 player, boolean isTransforming, String fromForm, String toForm) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(player.method_5667());
        buf.writeBoolean(isTransforming);
        buf.method_10814(fromForm != null ? fromForm : "");
        buf.method_10814(toForm != null ? toForm : "");
        for (class_3222 p : player.method_51469().method_18456()) {
            ServerPlayNetworking.send((class_3222)p, (class_2960)ModPackets.SYNC_TRANSFORM_STATE, (class_2540)buf);
        }
        ShapeShifterCurseFabric.LOGGER.info("Sent transform state to client: isTransforming=" + isTransforming);
    }

    public static void sendBatAttachState(class_3222 player, boolean isAttached, int attachType, class_2338 attachedPos, class_2350 attachedSide) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(isAttached);
        buf.writeInt(attachType);
        if (attachedPos != null) {
            buf.writeBoolean(true);
            buf.method_10807(attachedPos);
        } else {
            buf.writeBoolean(false);
        }
        if (attachedSide != null) {
            buf.writeBoolean(true);
            buf.writeInt(attachedSide.method_10146());
        } else {
            buf.writeBoolean(false);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.SYNC_BAT_ATTACH_STATE, (class_2540)buf);
    }

    public static void broadcastBatAttachState(class_3222 targetPlayer, boolean isAttached, int attachType, class_2338 attachedPos, class_2350 attachedSide) {
        targetPlayer.method_51469().method_18766(player -> player != targetPlayer && player.method_5858((class_1297)targetPlayer) <= 4096.0).forEach(nearbyPlayer -> ModPacketsS2CServer.sendOtherPlayerBatAttachState(nearbyPlayer, targetPlayer.method_5667(), isAttached, attachType, attachedPos, attachedSide));
    }

    public static void sendOtherPlayerBatAttachState(class_3222 receiver, UUID targetPlayerUuid, boolean isAttached, int attachType, class_2338 attachedPos, class_2350 attachedSide) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(targetPlayerUuid);
        buf.writeBoolean(isAttached);
        buf.writeInt(attachType);
        if (attachedPos != null) {
            buf.writeBoolean(true);
            buf.method_10807(attachedPos);
        } else {
            buf.writeBoolean(false);
        }
        if (attachedSide != null) {
            buf.writeBoolean(true);
            buf.writeInt(attachedSide.method_10146());
        } else {
            buf.writeBoolean(false);
        }
        ServerPlayNetworking.send((class_3222)receiver, (class_2960)ModPackets.SYNC_OTHER_PLAYER_BAT_ATTACH_STATE, (class_2540)buf);
    }

    public static void sendForceSneakState(class_3222 player, boolean shouldForceSneak) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(shouldForceSneak);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.SYNC_FORCE_SNEAK_STATE, (class_2540)buf);
    }

    private static void sendRemoveDynamicFormExcept(class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(RegPlayerForms.dynamicPlayerForms.size());
        for (class_2960 formId : RegPlayerForms.dynamicPlayerForms) {
            buf.method_10814(formId.toString());
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.REMOVE_DYNAMIC_FORM_EXCEPT, (class_2540)buf);
    }

    public static void sendUpdateDynamicForm(class_3222 player, JsonObject forms) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(forms.size());
        for (String formName : forms.keySet()) {
            buf.method_10814(formName);
            buf.method_10814(forms.get(formName).toString());
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.UPDATE_DYNAMIC_FORM, (class_2540)buf);
    }

    public static void updateDynamicForm(class_3222 player) {
        int MaxFormPerPacket = 63;
        HashMap<class_2960, PlayerFormDynamic> forms = RegPlayerForms.DumpDynamicPlayerForms();
        ModPacketsS2CServer.sendRemoveDynamicFormExcept(player);
        for (int i = 0; i < forms.size(); i += MaxFormPerPacket) {
            JsonObject jsonForms = new JsonObject();
            for (int j = 0; j < MaxFormPerPacket && i + j < forms.size(); ++j) {
                class_2960 formId = RegPlayerForms.dynamicPlayerForms.get(i + j);
                jsonForms.add(formId.toString(), (JsonElement)forms.get(formId).save());
            }
            ModPacketsS2CServer.sendUpdateDynamicForm(player, jsonForms);
        }
    }

    public static void sendPlayerLogin(class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.LOGIN_PACKET, (class_2540)buf);
    }

    public static void sendCustomEdibleList(class_3222 player, List<class_2960> Items, class_4174 foodComponent) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(1);
        buf.writeInt(Items.size());
        for (class_2960 id : Items) {
            buf.method_10812(id);
        }
        CustomEdibleUtils.WriteFoodComponent(buf, foodComponent);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.UPDATE_CUSTOM_EDIBLE_DATA, (class_2540)buf);
    }

    public static void sendClearEdibleList(class_3222 player, List<class_2960> Items) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(0);
        buf.writeInt(Items.size());
        for (class_2960 id : Items) {
            buf.method_10812(id);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.UPDATE_CUSTOM_EDIBLE_DATA, (class_2540)buf);
    }
}

