/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.player_form;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.player_animation.AnimationHolder;
import net.onixary.shapeShifterCurseFabric.player_animation.PlayerAnimState;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormBase;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormBodyType;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormGroup;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormPhase;
import net.onixary.shapeShifterCurseFabric.player_form.RegPlayerForms;
import net.onixary.shapeShifterCurseFabric.player_form_render.OriginalFurClient;

public class PlayerFormDynamic
extends PlayerFormBase {
    private final HashMap<PlayerAnimState, AnimationHolderData> animMap_Builder = new HashMap();
    public static final HashMap<class_2960, HashMap<PlayerAnimState, AnimationHolder>> animMap = new HashMap();
    private AnimationHolderData defaultAnim_Builder = null;
    public static final HashMap<class_2960, AnimationHolder> defaultAnim = new HashMap();
    public static final HashMap<class_2960, Boolean> isAnimRegistered = new HashMap();
    private class_2960 originID = null;
    private class_2960 originLayerID = null;

    public PlayerFormDynamic(class_2960 id) {
        super(id);
    }

    public boolean isModelExist() {
        return OriginalFurClient.FUR_RESOURCES.containsKey(this.getFormOriginID());
    }

    @Override
    public AnimationHolder Anim_getFormAnimToPlay(PlayerAnimState currentState) {
        if (!this.isModelExist()) {
            return null;
        }
        if (!isAnimRegistered.getOrDefault(this.FormID, false).booleanValue()) {
            this.Anim_registerAnims();
        }
        return this.getAnimMap().getOrDefault((Object)currentState, defaultAnim.get(this.FormID));
    }

    public HashMap<PlayerAnimState, AnimationHolder> getAnimMap() {
        return animMap.computeIfAbsent(this.FormID, k -> new HashMap());
    }

    @Override
    public void Anim_registerAnims() {
        this.getAnimMap().clear();
        for (PlayerAnimState state : this.animMap_Builder.keySet()) {
            this.getAnimMap().put(state, this.animMap_Builder.get((Object)state).build());
        }
        if (this.defaultAnim_Builder != null) {
            defaultAnim.put(this.FormID, this.defaultAnim_Builder.build());
        }
        isAnimRegistered.put(this.FormID, true);
    }

    private AnimationHolderData loadAnim(JsonObject animData) {
        try {
            class_2960 AnimID = class_2960.method_12829((String)animData.get("animID").getAsString());
            float Speed = 1.0f;
            int Fade = 2;
            if (animData.has("speed")) {
                Speed = animData.get("speed").getAsFloat();
            }
            if (animData.has("fade")) {
                Fade = animData.get("fade").getAsInt();
            }
            return new AnimationHolderData(AnimID, Speed, Fade);
        }
        catch (Exception e) {
            ShapeShifterCurseFabric.LOGGER.warn("Error while loading player animation: " + e.getMessage());
            return null;
        }
    }

    private JsonObject saveAnim(PlayerAnimState state, AnimationHolderData animData) {
        JsonObject jsonAnimData = new JsonObject();
        if (state != null) {
            jsonAnimData.addProperty("state", state.name());
        }
        jsonAnimData.addProperty("animID", animData.AnimID.toString());
        jsonAnimData.addProperty("speed", (Number)Float.valueOf(animData.Speed));
        jsonAnimData.addProperty("fade", (Number)animData.Fade);
        return jsonAnimData;
    }

    public void registerAnim(JsonObject animData) {
        try {
            PlayerAnimState State2 = PlayerAnimState.valueOf(animData.get("state").getAsString());
            this.animMap_Builder.put(State2, this.loadAnim(animData));
        }
        catch (Exception e) {
            ShapeShifterCurseFabric.LOGGER.warn("Error while register player animation: " + e.getMessage());
        }
    }

    private String _Gson_GetString(JsonObject data, String key, String defaultValue) {
        if (data.has(key)) {
            return data.get(key).getAsString();
        }
        return defaultValue;
    }

    private int _Gson_GetInt(JsonObject data, String key, int defaultValue) {
        if (data.has(key)) {
            return data.get(key).getAsInt();
        }
        return defaultValue;
    }

    private boolean _Gson_GetBoolean(JsonObject data, String key, boolean defaultValue) {
        if (data.has(key)) {
            return data.get(key).getAsBoolean();
        }
        return defaultValue;
    }

    public void load(JsonObject formData) {
        try {
            String originLayerIDStr;
            this.setPhase(PlayerFormPhase.valueOf(this._Gson_GetString(formData, "phase", "PHASE_CLEAR")));
            this.setBodyType(PlayerFormBodyType.valueOf(this._Gson_GetString(formData, "bodyType", "NORMAL")));
            this.setHasSlowFall(this._Gson_GetBoolean(formData, "hasSlowFall", false));
            this.setOverrideHandAnim(this._Gson_GetBoolean(formData, "overrideHandAnim", false));
            this.setCanSneakRush(this._Gson_GetBoolean(formData, "canSneakRush", false));
            this.setCanRushJump(this._Gson_GetBoolean(formData, "canRushJump", false));
            this.setIsCustomForm(this._Gson_GetBoolean(formData, "isCustomForm", false));
            String originIDStr = this._Gson_GetString(formData, "originID", null);
            if (originIDStr != null) {
                this.originID = class_2960.method_12829((String)originIDStr);
            }
            if ((originLayerIDStr = this._Gson_GetString(formData, "originLayerID", null)) != null) {
                this.originLayerID = class_2960.method_12829((String)originLayerIDStr);
            }
            if (formData.has("anim")) {
                for (JsonElement animData : formData.get("anim").getAsJsonArray()) {
                    if (!animData.isJsonObject()) continue;
                    this.registerAnim(animData.getAsJsonObject());
                }
            }
            if (formData.has("animDefault")) {
                this.defaultAnim_Builder = this.loadAnim(formData.get("animDefault").getAsJsonObject());
            }
            class_2960 GroupID = class_2960.method_12829((String)this._Gson_GetString(formData, "groupID", this.FormID.toString()));
            int GroupIndex = this._Gson_GetInt(formData, "groupIndex", 0);
            PlayerFormGroup group = RegPlayerForms.getPlayerFormGroup(GroupID);
            if (group == null) {
                group = RegPlayerForms.registerDynamicPlayerFormGroup(new PlayerFormGroup(GroupID));
            }
            this.setGroup(group, GroupIndex);
        }
        catch (Exception e) {
            ShapeShifterCurseFabric.LOGGER.error("Error while loading player form: {}", (Object)e.getMessage());
        }
        isAnimRegistered.put(this.FormID, false);
    }

    public JsonObject save() {
        JsonObject data = new JsonObject();
        data.addProperty("phase", this.getPhase().toString());
        data.addProperty("bodyType", this.getBodyType().toString());
        data.addProperty("hasSlowFall", Boolean.valueOf(this.getHasSlowFall()));
        data.addProperty("overrideHandAnim", Boolean.valueOf(this.getOverrideHandAnim()));
        data.addProperty("canSneakRush", Boolean.valueOf(this.getCanSneakRush()));
        data.addProperty("canRushJump", Boolean.valueOf(this.getCanRushJump()));
        data.addProperty("isCustomForm", Boolean.valueOf(this.getIsCustomForm()));
        if (this.originID != null) {
            data.addProperty("originID", this.originID.toString());
        }
        if (this.originLayerID != null) {
            data.addProperty("originLayerID", this.originLayerID.toString());
        }
        JsonArray anims = new JsonArray();
        for (Map.Entry<PlayerAnimState, AnimationHolderData> entry : this.animMap_Builder.entrySet()) {
            anims.add((JsonElement)this.saveAnim(entry.getKey(), entry.getValue()));
        }
        data.add("anim", (JsonElement)anims);
        if (this.defaultAnim_Builder != null) {
            data.add("animDefault", (JsonElement)this.saveAnim(null, this.defaultAnim_Builder));
        }
        if (this.getGroup() != null) {
            data.addProperty("groupID", this.getGroup().GroupID.toString());
            data.addProperty("groupIndex", (Number)this.FormIndex);
        }
        return data;
    }

    public static PlayerFormDynamic of(class_2960 id, JsonObject formData) {
        PlayerFormDynamic form = new PlayerFormDynamic(id);
        form.load(formData);
        return form;
    }

    @Override
    public class_2960 getFormOriginID() {
        return this.originID != null ? this.originID : super.getFormOriginID();
    }

    @Override
    public class_2960 getFormOriginLayerID() {
        return this.originLayerID != null ? this.originLayerID : super.getFormOriginLayerID();
    }

    static class AnimationHolderData {
        public class_2960 AnimID;
        public float Speed;
        public int Fade;

        public AnimationHolderData(class_2960 AnimID, float Speed, int Fade) {
            this.AnimID = AnimID;
            this.Speed = Speed;
            this.Fade = Fade;
        }

        public AnimationHolder build() {
            return new AnimationHolder(this.AnimID, true, this.Speed, this.Fade);
        }
    }
}

