/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.player_form.skin;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.OptionalInt;
import net.minecraft.class_2487;
import net.onixary.shapeShifterCurseFabric.util.FormTextureUtils;

public class PlayerSkinComponent
implements Component,
AutoSyncedComponent {
    private boolean keepOriginalSkin = false;
    private boolean enableFormColor = false;
    private FormTextureUtils.ColorSetting formColor = new FormTextureUtils.ColorSetting(-1, -1, -1, -16777216, -16777216, false, false, false);

    public boolean shouldKeepOriginalSkin() {
        return this.keepOriginalSkin;
    }

    public boolean isEnableFormColor() {
        return this.enableFormColor;
    }

    public FormTextureUtils.ColorSetting getFormColor() {
        return this.formColor;
    }

    public void setKeepOriginalSkin(boolean keepOriginalSkin) {
        this.keepOriginalSkin = keepOriginalSkin;
    }

    public void setEnableFormColor(boolean enableFormColor) {
        this.enableFormColor = enableFormColor;
    }

    public void setFormColor(FormTextureUtils.ColorSetting formColor) {
        this.formColor = formColor;
    }

    public void setFormColor(int primaryColorRGBA, int accentColor1RGBA, int accentColor2RGBA, int eyeColorA, int eyeColorB, boolean primaryGreyReverse, boolean accent1GreyReverse, boolean accent2GreyReverse) {
        this.formColor = new FormTextureUtils.ColorSetting(FormTextureUtils.RGBA2ABGR(primaryColorRGBA), FormTextureUtils.RGBA2ABGR(accentColor1RGBA), FormTextureUtils.RGBA2ABGR(accentColor2RGBA), FormTextureUtils.RGBA2ABGR(eyeColorA), FormTextureUtils.RGBA2ABGR(eyeColorB), primaryGreyReverse, accent1GreyReverse, accent2GreyReverse);
    }

    public OptionalInt RGBA_Str2RGBA(String rgbaStr) {
        try {
            if (rgbaStr.length() == 6) {
                return OptionalInt.of(Integer.parseUnsignedInt(rgbaStr, 16) << 8 | 0xFF);
            }
            if (rgbaStr.length() == 8) {
                return OptionalInt.of(Integer.parseUnsignedInt(rgbaStr, 16));
            }
            return OptionalInt.empty();
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    public boolean setFormColor(String primaryColorRGBAHex, String accentColor1RGBAHex, String accentColor2RGBAHex, String eyeColorAHex, String eyeColorBHex, boolean primaryGreyReverse, boolean accent1GreyReverse, boolean accent2GreyReverse) {
        OptionalInt primaryColorRGBA = this.RGBA_Str2RGBA(primaryColorRGBAHex);
        OptionalInt accentColor1RGBA = this.RGBA_Str2RGBA(accentColor1RGBAHex);
        OptionalInt accentColor2RGBA = this.RGBA_Str2RGBA(accentColor2RGBAHex);
        OptionalInt eyeColorA = this.RGBA_Str2RGBA(eyeColorAHex);
        OptionalInt eyeColorB = this.RGBA_Str2RGBA(eyeColorBHex);
        if (primaryColorRGBA.isPresent() && accentColor1RGBA.isPresent() && accentColor2RGBA.isPresent() && eyeColorA.isPresent() && eyeColorB.isPresent()) {
            this.setFormColor(primaryColorRGBA.getAsInt(), accentColor1RGBA.getAsInt(), accentColor2RGBA.getAsInt(), eyeColorA.getAsInt(), eyeColorB.getAsInt(), primaryGreyReverse, accent1GreyReverse, accent2GreyReverse);
            return true;
        }
        return false;
    }

    public void readFromNbt(class_2487 tag) {
        try {
            this.keepOriginalSkin = tag.method_10577("KeepOriginalSkin");
            this.enableFormColor = tag.method_10577("EnableFormColor");
            this.formColor = new FormTextureUtils.ColorSetting(FormTextureUtils.RGBA2ABGR(tag.method_10550("PrimaryColor")), FormTextureUtils.RGBA2ABGR(tag.method_10550("AccentColor1")), FormTextureUtils.RGBA2ABGR(tag.method_10550("AccentColor2")), FormTextureUtils.RGBA2ABGR(tag.method_10550("EyeColorA")), FormTextureUtils.RGBA2ABGR(tag.method_10550("EyeColorB")), tag.method_10577("PrimaryGreyReverse"), tag.method_10577("Accent1GreyReverse"), tag.method_10577("Accent2GreyReverse"));
        }
        catch (IllegalArgumentException e) {
            this.keepOriginalSkin = false;
            this.enableFormColor = false;
            this.formColor = new FormTextureUtils.ColorSetting(-1, -1, -1, -1, -1, false, false, false);
        }
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10556("KeepOriginalSkin", this.keepOriginalSkin);
        tag.method_10556("EnableFormColor", this.enableFormColor);
        tag.method_10569("PrimaryColor", FormTextureUtils.ABGR2RGBA(this.formColor.getPrimaryColor()));
        tag.method_10569("AccentColor1", FormTextureUtils.ABGR2RGBA(this.formColor.getAccentColor1()));
        tag.method_10569("AccentColor2", FormTextureUtils.ABGR2RGBA(this.formColor.getAccentColor2()));
        tag.method_10569("EyeColorA", FormTextureUtils.ABGR2RGBA(this.formColor.getEyeColorA()));
        tag.method_10569("EyeColorB", FormTextureUtils.ABGR2RGBA(this.formColor.getEyeColorB()));
        tag.method_10556("PrimaryGreyReverse", this.formColor.getPrimaryGreyReverse());
        tag.method_10556("Accent1GreyReverse", this.formColor.getAccent1GreyReverse());
        tag.method_10556("Accent2GreyReverse", this.formColor.getAccent2GreyReverse());
    }
}

