/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.util;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.player_form_render.OriginFurModel;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class FormTextureUtils {
    public static class_2960 getColorMask_Texture(OriginFurModel model) {
        String MaskIDStr = class_3518.method_15253((JsonObject)model.json, (String)"texture_mask", null);
        return MaskIDStr == null ? null : class_2960.method_12829((String)MaskIDStr);
    }

    public static class_2960 getColorMask_OverlayTexture(OriginFurModel model, boolean Slim) {
        String MaskIDStr = null;
        MaskIDStr = !Slim ? class_3518.method_15253((JsonObject)model.json, (String)"overlay_mask", null) : class_3518.method_15253((JsonObject)model.json, (String)"overlay_slim_mask", null);
        return MaskIDStr == null ? null : class_2960.method_12829((String)MaskIDStr);
    }

    public static class_2960 getColorMask_EmissiveTexture(OriginFurModel model, boolean Slim) {
        String MaskIDStr = null;
        MaskIDStr = !Slim ? class_3518.method_15253((JsonObject)model.json, (String)"emissive_overlay_mask", null) : class_3518.method_15253((JsonObject)model.json, (String)"emissive_overlay_slim_mask", null);
        return MaskIDStr == null ? null : class_2960.method_12829((String)MaskIDStr);
    }

    public static class_1011 toNativeImage(class_2960 texture) {
        class_1011 nativeImage = null;
        class_3300 RM = class_310.method_1551().method_1478();
        class_3298 resource = null;
        try {
            resource = RM.getResourceOrThrow(texture);
            InputStream inputStream = resource.method_14482();
            nativeImage = class_1011.method_4309((InputStream)inputStream);
        }
        catch (IOException e) {
            ShapeShifterCurseFabric.LOGGER.warn("Failed to load texture: " + String.valueOf(texture));
        }
        return nativeImage;
    }

    public static int RGBA2ABGR(int color) {
        return color << 24 | color << 8 & 0xFF0000 | color >> 8 & 0xFF00 | color >>> 24;
    }

    public static int RGB2ABGR(int color) {
        return FormTextureUtils.RGBA2ABGR(color << 8 | 0xFF);
    }

    public static int ARGB2ABGR(int color) {
        int Alpha = color >> 24 & 0xFF;
        return FormTextureUtils.RGBA2ABGR(color << 8 | Alpha);
    }

    public static int ABGR2RGBA(int color) {
        return color << 24 | color << 8 & 0xFF0000 | color >> 8 & 0xFF00 | color >>> 24;
    }

    public static int ABGR2RGB(int color) {
        return FormTextureUtils.ABGR2RGBA(color) >>> 8;
    }

    public static int ABGR2ARGB(int color) {
        return FormTextureUtils.ABGR2RGB(color) | color & 0xFF000000;
    }

    public static int ColorMulBytes(int ColorA, int Bytes) {
        return ColorA & 0xFF000000 | (ColorA >> 16 & 0xFF) * Bytes / 255 << 16 | (ColorA >> 8 & 0xFF) * Bytes / 255 << 8 | (ColorA & 0xFF) * Bytes / 255;
    }

    public static int GreyScaleMul(int Color2, float GreyScale) {
        int R = Math.min(255, Math.max((int)(GreyScale * (float)(Color2 & 0xFF)), 0));
        int G = Math.min(255, Math.max((int)(GreyScale * (float)(Color2 >> 8 & 0xFF)), 0));
        int B = Math.min(255, Math.max((int)(GreyScale * (float)(Color2 >> 16 & 0xFF)), 0));
        return 0xFF000000 | B << 16 | G << 8 | R;
    }

    public static int getGreyScale(int color) {
        int R = color >> 16 & 0xFF;
        int G = color >> 8 & 0xFF;
        int B = color & 0xFF;
        return R * 28 + G * 151 + B * 77 >> 8;
    }

    public static int overrideGreyScale(int a, int b, float t) {
        return Math.min(a + (int)(t * (float)b), 255);
    }

    public static Triple<Integer, Integer, Integer> getAverageGreyScale(class_1011 image, class_1011 maskImage) {
        int textureWidth = image.method_4307();
        int textureHeight = image.method_4323();
        long R = 0L;
        long G = 0L;
        long B = 0L;
        int RC = 0;
        int GC = 0;
        int BC = 0;
        for (int x = 0; x < textureWidth; ++x) {
            for (int y = 0; y < textureHeight; ++y) {
                int Mask = maskImage.method_4315(x, y);
                if ((Mask & 0xFF0000) > 0) {
                    B += (long)FormTextureUtils.getGreyScale(image.method_4315(x, y));
                    ++BC;
                    continue;
                }
                if ((Mask & 0xFF00) > 0) {
                    G += (long)FormTextureUtils.getGreyScale(image.method_4315(x, y));
                    ++GC;
                    continue;
                }
                if ((Mask & 0xFF) <= 0) continue;
                R += (long)FormTextureUtils.getGreyScale(image.method_4315(x, y));
                ++RC;
            }
        }
        return new ImmutableTriple((Object)(RC == 0 ? 255 : (int)R / RC), (Object)(GC == 0 ? 255 : (int)G / GC), (Object)(BC == 0 ? 255 : (int)B / BC));
    }

    public static int ProcessMaskChannel(int Color2, int Mask, int ColorSetting2, int AverageGreyScale, boolean ReverseGreyScale) {
        if ((ColorSetting2 >> 24 & 0xFF) == 0) {
            return Color2;
        }
        int ColorGreyScale = FormTextureUtils.getGreyScale(Color2);
        int GreyScaleOffset = ReverseGreyScale ? AverageGreyScale - ColorGreyScale : ColorGreyScale - AverageGreyScale;
        int ColorSettingGreyScale = FormTextureUtils.getGreyScale(ColorSetting2);
        int TargetGreyScale = Math.min(255, Math.max(ColorSettingGreyScale + GreyScaleOffset, 0));
        int ColorResult = FormTextureUtils.GreyScaleMul(ColorSetting2 | 0xFF000000, (float)TargetGreyScale / (float)ColorSettingGreyScale);
        return FormTextureUtils.ColorMulBytes(ColorResult, Mask);
    }

    public static int ProcessPixel(int Color2, int Mask, ColorSetting colorSetting, Triple<Integer, Integer, Integer> MaskLayerAverageGreyScale, boolean OnlyMultiply) {
        int B;
        if (Mask == 0) {
            return Color2;
        }
        int maskAlpha = Mask >>> 24;
        if (maskAlpha != 255) {
            if (maskAlpha == 1) {
                if (colorSetting.eyeColorA >>> 24 == 0) {
                    return Color2;
                }
                return colorSetting.eyeColorA & 0xFFFFFF | Color2 & 0xFF000000;
            }
            if (maskAlpha == 2) {
                if (colorSetting.eyeColorB >>> 24 == 0) {
                    return Color2;
                }
                return colorSetting.eyeColorB & 0xFFFFFF | Color2 & 0xFF000000;
            }
        }
        if ((B = Mask >> 16 & 0xFF) > 0) {
            if (OnlyMultiply) {
                return FormTextureUtils.ColorMulBytes(colorSetting.accentColor2, B) & 0xFFFFFF | Color2 & 0xFF000000;
            }
            int result = FormTextureUtils.ProcessMaskChannel(Color2, B, colorSetting.accentColor2, (Integer)MaskLayerAverageGreyScale.getRight(), colorSetting.accent2GreyReverse);
            return result & 0xFFFFFF | Color2 & 0xFF000000;
        }
        int G = Mask >> 8 & 0xFF;
        if (G > 0) {
            if (OnlyMultiply) {
                return FormTextureUtils.ColorMulBytes(colorSetting.accentColor1, G) & 0xFFFFFF | Color2 & 0xFF000000;
            }
            int result = FormTextureUtils.ProcessMaskChannel(Color2, G, colorSetting.accentColor1, (Integer)MaskLayerAverageGreyScale.getMiddle(), colorSetting.accent1GreyReverse);
            return result & 0xFFFFFF | Color2 & 0xFF000000;
        }
        int R = Mask & 0xFF;
        if (R > 0) {
            if (OnlyMultiply) {
                return FormTextureUtils.ColorMulBytes(colorSetting.primaryColor, R) & 0xFFFFFF | Color2 & 0xFF000000;
            }
            int result = FormTextureUtils.ProcessMaskChannel(Color2, R, colorSetting.primaryColor, (Integer)MaskLayerAverageGreyScale.getLeft(), colorSetting.primaryGreyReverse);
            return result & 0xFFFFFF | Color2 & 0xFF000000;
        }
        return Color2;
    }

    public static class_2960 BakeTexture(class_2960 texture, class_2960 mask, ColorSetting colorSetting, boolean OnlyMultiply) {
        if (texture == null || mask == null) {
            return null;
        }
        class_1011 textureImage = FormTextureUtils.toNativeImage(texture);
        class_1011 maskImage = FormTextureUtils.toNativeImage(mask);
        int textureWidth = textureImage.method_4307();
        int textureHeight = textureImage.method_4323();
        Triple<Integer, Integer, Integer> MaskLayerAverageGreyScale = FormTextureUtils.getAverageGreyScale(textureImage, maskImage);
        for (int x = 0; x < textureWidth; ++x) {
            for (int y = 0; y < textureHeight; ++y) {
                textureImage.method_4305(x, y, FormTextureUtils.ProcessPixel(textureImage.method_4315(x, y), maskImage.method_4315(x, y), colorSetting, MaskLayerAverageGreyScale, OnlyMultiply));
            }
        }
        class_1060 TM = class_310.method_1551().method_1531();
        return TM.method_4617("masked_texture", new class_1043(textureImage));
    }

    public static class_2960 getBakedTexture(OriginFurModel model, ColorSetting colorSetting) {
        class_2960 CachedTexture = model.ColorMask_Baked_Textures.get(colorSetting);
        if (CachedTexture != null) {
            return CachedTexture;
        }
        CachedTexture = FormTextureUtils.BakeTexture(OriginFurModel.dTR(model.json), FormTextureUtils.getColorMask_Texture(model), colorSetting, FormTextureUtils.IsModelUseMultiply(model));
        if (CachedTexture == null) {
            CachedTexture = OriginFurModel.dTR(model.json);
        }
        model.ColorMask_Baked_Textures.put(colorSetting, CachedTexture);
        return CachedTexture;
    }

    public static class_2960 getBakedOverlayTexture(OriginFurModel model, ColorSetting colorSetting, boolean Slim) {
        if (!Slim) {
            class_2960 CachedTexture = model.ColorMask_Baked_OverlayTexture.get(colorSetting);
            if (CachedTexture != null) {
                return CachedTexture;
            }
            CachedTexture = FormTextureUtils.BakeTexture(class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"overlay", null)), FormTextureUtils.getColorMask_OverlayTexture(model, Slim), colorSetting, FormTextureUtils.IsModelUseMultiply(model));
            if (CachedTexture == null) {
                CachedTexture = class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"overlay", null));
            }
            model.ColorMask_Baked_OverlayTexture.put(colorSetting, CachedTexture);
            return CachedTexture;
        }
        class_2960 CachedTexture = model.ColorMask_Baked_OverlayTexture_Slim.get(colorSetting);
        if (CachedTexture != null) {
            return CachedTexture;
        }
        CachedTexture = FormTextureUtils.BakeTexture(class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"overlay_slim", null)), FormTextureUtils.getColorMask_OverlayTexture(model, Slim), colorSetting, FormTextureUtils.IsModelUseMultiply(model));
        if (CachedTexture == null) {
            CachedTexture = class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"overlay_slim", null));
        }
        model.ColorMask_Baked_OverlayTexture_Slim.put(colorSetting, CachedTexture);
        return CachedTexture;
    }

    public static class_2960 getBakedEmissiveTexture(OriginFurModel model, ColorSetting colorSetting, boolean Slim) {
        if (!Slim) {
            class_2960 CachedTexture = model.ColorMask_Baked_EmissiveTexture.get(colorSetting);
            if (CachedTexture != null) {
                return CachedTexture;
            }
            CachedTexture = FormTextureUtils.BakeTexture(class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"emissive_overlay", null)), FormTextureUtils.getColorMask_EmissiveTexture(model, Slim), colorSetting, FormTextureUtils.IsModelUseMultiply(model));
            if (CachedTexture == null) {
                CachedTexture = class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"emissive_overlay", null));
            }
            model.ColorMask_Baked_EmissiveTexture.put(colorSetting, CachedTexture);
            return CachedTexture;
        }
        class_2960 CachedTexture = model.ColorMask_Baked_EmissiveTexture_Slim.get(colorSetting);
        if (CachedTexture != null) {
            return CachedTexture;
        }
        CachedTexture = FormTextureUtils.BakeTexture(class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"emissive_overlay_slim", null)), FormTextureUtils.getColorMask_EmissiveTexture(model, Slim), colorSetting, FormTextureUtils.IsModelUseMultiply(model));
        if (CachedTexture == null) {
            CachedTexture = class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"emissive_overlay_slim", null));
        }
        model.ColorMask_Baked_EmissiveTexture_Slim.put(colorSetting, CachedTexture);
        return CachedTexture;
    }

    private static boolean IsModelUseMultiply(OriginFurModel model) {
        return class_3518.method_15258((JsonObject)model.json, (String)"IsMultiplyMask", (boolean)false);
    }

    public record ColorSetting(int primaryColor, int accentColor1, int accentColor2, int eyeColorA, int eyeColorB, boolean primaryGreyReverse, boolean accent1GreyReverse, boolean accent2GreyReverse) {
        public int getPrimaryColor() {
            return this.primaryColor;
        }

        public int getAccentColor1() {
            return this.accentColor1;
        }

        public int getAccentColor2() {
            return this.accentColor2;
        }

        public int getEyeColorA() {
            return this.eyeColorA;
        }

        public int getEyeColorB() {
            return this.eyeColorB;
        }

        public boolean getPrimaryGreyReverse() {
            return this.primaryGreyReverse;
        }

        public boolean getAccent1GreyReverse() {
            return this.accent1GreyReverse;
        }

        public boolean getAccent2GreyReverse() {
            return this.accent2GreyReverse;
        }
    }
}

