/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.util;

import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_268;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.additional_power.JumpEventCondition;
import net.onixary.shapeShifterCurseFabric.cursed_moon.CursedMoon;
import net.onixary.shapeShifterCurseFabric.data.PlayerDataStorage;
import net.onixary.shapeShifterCurseFabric.data.PlayerNbtStorage;
import net.onixary.shapeShifterCurseFabric.networking.ModPacketsS2CServer;
import net.onixary.shapeShifterCurseFabric.player_form.ability.FormAbilityManager;
import net.onixary.shapeShifterCurseFabric.player_form.ability.PlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.ability.RegPlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.InstinctManager;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.InstinctTicker;
import net.onixary.shapeShifterCurseFabric.player_form.skin.PlayerSkinComponent;
import net.onixary.shapeShifterCurseFabric.player_form.skin.RegPlayerSkinComponent;
import net.onixary.shapeShifterCurseFabric.status_effects.RegTStatusEffect;
import net.onixary.shapeShifterCurseFabric.status_effects.attachment.EffectManager;
import net.onixary.shapeShifterCurseFabric.status_effects.attachment.PlayerEffectAttachment;
import net.onixary.shapeShifterCurseFabric.team.MobTeamManager;

public class PlayerEventHandler {
    public static void register() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (handler.field_14140.method_37908().method_8608()) {
                return;
            }
            PlayerDataStorage.initialize(server);
            class_3222 player = handler.field_14140;
            FormAbilityManager.getServerWorld(player.method_51469());
            PlayerSkinComponent skinComponent = (PlayerSkinComponent)RegPlayerSkinComponent.SKIN_SETTINGS.get((Object)player);
            RegPlayerSkinComponent.SKIN_SETTINGS.sync((Object)player);
            PlayerFormComponent savedComponent = PlayerNbtStorage.loadPlayerFormComponent(server.method_30002(), player.method_5667().toString());
            if (savedComponent != null) {
                RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
                ShapeShifterCurseFabric.LOGGER.info("Loaded existing player data, not first join");
            } else {
                ShapeShifterCurseFabric.LOGGER.info("No saved data found, this is first join with mod");
                PlayerFormComponent formComponent = (PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player);
                formComponent.clear();
                formComponent.setFirstJoin(true);
                ShapeShifterCurseFabric.ON_FIRST_JOIN_WITH_MOD.trigger(player);
                formComponent.setFirstJoin(false);
                RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
                PlayerNbtStorage.savePlayerFormComponent(server.method_30002(), player.method_5667().toString(), formComponent);
            }
            server.execute(() -> {
                try {
                    ModPacketsS2CServer.updateDynamicForm(player);
                }
                catch (Exception e) {
                    ShapeShifterCurseFabric.LOGGER.error("Error sending update dynamic form: ", (Throwable)e);
                }
            });
            server.execute(() -> {
                try {
                    FormAbilityManager.loadForm((class_1657)player);
                }
                catch (Exception e) {
                    ShapeShifterCurseFabric.LOGGER.error("Error loading player form: ", (Throwable)e);
                }
            });
            boolean hasAttachment = EffectManager.loadCurrentAttachment(server.method_30002(), (class_1657)player);
            if (!hasAttachment) {
                EffectManager.resetAttachment((class_1657)player);
            } else {
                ShapeShifterCurseFabric.LOGGER.info("Attachment loaded ");
            }
            ModPacketsS2CServer.sendSyncEffectAttachment(player, (PlayerEffectAttachment)player.getAttached(EffectManager.EFFECT_ATTACHMENT));
            InstinctManager.getServerWorld(server.method_30002());
            InstinctTicker.loadInstinct((class_1657)player);
            ShapeShifterCurseFabric.LOGGER.info("Cursed moon enabled");
            ShapeShifterCurseFabric.cursedMoonData.getInstance().load(server.method_30002());
            ShapeShifterCurseFabric.cursedMoonData.getInstance().enableCursedMoon(server.method_30002());
            class_3218 world = server.method_30002();
            boolean currentIsCursedMoon = CursedMoon.isCursedMoon((class_1937)world);
            boolean currentIsNight = CursedMoon.isNight((class_1937)world);
            ModPacketsS2CServer.sendCursedMoonData(player, world.method_8532(), CursedMoon.getDay((class_1937)world), currentIsCursedMoon, currentIsNight);
            ShapeShifterCurseFabric.LOGGER.info("\u5411\u73a9\u5bb6\u540c\u6b65\u8bc5\u5492\u4e4b\u6708\u72b6\u6001: " + currentIsCursedMoon + ", \u6708\u76f8: " + world.method_30273());
            server.execute(() -> new Thread(() -> {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                server.execute(() -> {
                    if (player.field_13987 != null && !player.method_14239()) {
                        class_3218 currentWorld = player.method_51469();
                        boolean delayedIsCursedMoon = CursedMoon.isCursedMoonByPhase((class_1937)currentWorld);
                        boolean delayedIsNight = CursedMoon.isNight((class_1937)currentWorld);
                        ModPacketsS2CServer.sendCursedMoonData(player, currentWorld.method_8532(), CursedMoon.getDay((class_1937)currentWorld), delayedIsCursedMoon, delayedIsNight);
                        ShapeShifterCurseFabric.LOGGER.info("\u5ef6\u8fdf\u540c\u6b65\u8bc5\u5492\u4e4b\u6708\u72b6\u6001: " + delayedIsCursedMoon + ", \u6708\u76f8: " + currentWorld.method_30273() + ", \u73a9\u5bb6: " + player.method_5477().getString());
                    }
                });
            }).start());
            ShapeShifterCurseFabric.cursedMoonData.getInstance().loadPlayerStates(server.method_30002(), player);
            ShapeShifterCurseFabric.cursedMoonData.getInstance().save(server.method_30002());
            CursedMoon.resetMoonEffect(player);
        });
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            if (newPlayer.method_37908().method_8608()) {
                return;
            }
            PlayerEventHandler.copyTransformativeEffect(oldPlayer, newPlayer);
            PlayerEventHandler.copyFormAndAbility(oldPlayer, newPlayer);
            PlayerNbtStorage.saveAll(newPlayer.method_51469(), newPlayer);
        });
        ServerWorldEvents.LOAD.register((server, world) -> {
            for (class_3222 player : world.method_18456()) {
                FormAbilityManager.loadForm((class_1657)player);
                boolean hasAttachment = EffectManager.loadCurrentAttachment(server.method_30002(), (class_1657)player);
                if (!hasAttachment) {
                    EffectManager.resetAttachment((class_1657)player);
                } else {
                    ShapeShifterCurseFabric.LOGGER.info("Attachment loaded ");
                }
                ModPacketsS2CServer.sendSyncEffectAttachment(player, (PlayerEffectAttachment)player.getAttached(EffectManager.EFFECT_ATTACHMENT));
                InstinctManager.getServerWorld(server.method_30002());
                InstinctTicker.loadInstinct((class_1657)player);
                ShapeShifterCurseFabric.LOGGER.info("Cursed moon enabled");
                ShapeShifterCurseFabric.cursedMoonData.getInstance().load(server.method_30002());
                ShapeShifterCurseFabric.cursedMoonData.getInstance().enableCursedMoon(server.method_30002());
                boolean currentIsCursedMoon = CursedMoon.isCursedMoon((class_1937)world);
                boolean currentIsNight = CursedMoon.isNight((class_1937)world);
                ModPacketsS2CServer.sendCursedMoonData(player, world.method_8532(), CursedMoon.getDay((class_1937)world), currentIsCursedMoon, currentIsNight);
                ShapeShifterCurseFabric.LOGGER.info("\u5411\u73a9\u5bb6\u540c\u6b65\u8bc5\u5492\u4e4b\u6708\u72b6\u6001: " + currentIsCursedMoon + ", \u6708\u76f8: " + world.method_30273());
                ShapeShifterCurseFabric.cursedMoonData.getInstance().loadPlayerStates(server.method_30002(), player);
                ShapeShifterCurseFabric.cursedMoonData.getInstance().save(server.method_30002());
                CursedMoon.resetMoonEffect(player);
                ((class_1928.class_4310)server.method_3767().method_20746(class_1928.field_19396)).method_20758(true, server);
                MobTeamManager.registerTeam(world);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            for (class_3218 world : server.method_3738()) {
                if (world.method_27983() != class_1937.field_25179) continue;
                ShapeShifterCurseFabric.LOGGER.info("Cursed moon data saved by server stop");
                ShapeShifterCurseFabric.cursedMoonData.getInstance().save(world);
                for (class_3222 player : world.method_18456()) {
                    ShapeShifterCurseFabric.cursedMoonData.getInstance().savePlayerStates(world, player);
                    PlayerNbtStorage.saveAll(world, player);
                }
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> JumpEventCondition.tick());
    }

    private static void copyTransformativeEffect(class_3222 oldPlayer, class_3222 newPlayer) {
        PlayerEffectAttachment oldAttachment = (PlayerEffectAttachment)oldPlayer.getAttached(EffectManager.EFFECT_ATTACHMENT);
        newPlayer.setAttached(EffectManager.EFFECT_ATTACHMENT, (Object)new PlayerEffectAttachment());
        PlayerEffectAttachment newAttachment = (PlayerEffectAttachment)newPlayer.getAttached(EffectManager.EFFECT_ATTACHMENT);
        if (oldAttachment != null) {
            newAttachment.currentToForm = oldAttachment.currentToForm;
            newAttachment.remainingTicks = oldAttachment.remainingTicks;
            newAttachment.currentEffect = oldAttachment.currentEffect;
        }
        if (newAttachment.currentEffect != null && EffectManager.currentRegEffect != null) {
            ShapeShifterCurseFabric.LOGGER.info("re-apply potion effect here");
            RegTStatusEffect.removeVisualEffects((class_1657)newPlayer);
            newPlayer.method_6092(new class_1293((class_1291)EffectManager.currentRegEffect, newAttachment.remainingTicks));
        }
    }

    private static void copyFormAndAbility(class_3222 oldPlayer, class_3222 newPlayer) {
        PlayerFormComponent oldComponent = (PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)oldPlayer);
        PlayerFormComponent newComponent = (PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)newPlayer);
        newComponent.setCurrentForm(oldComponent.getCurrentForm());
        newComponent.setCurrentForm(oldComponent.getCurrentForm());
        FormAbilityManager.applyForm((class_1657)newPlayer, newComponent.getCurrentForm());
    }

    private static void handleEntityTeam(class_3218 world) {
        class_2995 scoreboard = world.method_14170();
        class_268 sorceryTeam = scoreboard.method_1153("sorcery_team");
        for (class_1297 entity : world.method_27909()) {
            if (entity.method_5864() != class_1299.field_6090 && entity.method_5864() != class_1299.field_6145 && entity.method_5864() != class_1299.field_6117 && entity.method_5864() != class_1299.field_6105 && entity.method_5864() != class_1299.field_6134 || sorceryTeam == null) continue;
            scoreboard.method_1172(entity.method_5820(), sorceryTeam);
        }
    }
}

