/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.cursed_moon;

import java.util.Arrays;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.data.CursedMoonData;
import net.onixary.shapeShifterCurseFabric.networking.ModPacketsS2CServer;
import net.onixary.shapeShifterCurseFabric.player_form.RegPlayerForms;
import net.onixary.shapeShifterCurseFabric.player_form.ability.FormAbilityManager;
import net.onixary.shapeShifterCurseFabric.player_form.ability.PlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.ability.RegPlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.transform.TransformManager;

public class CursedMoon {
    public static long day_time = 0L;
    public static int day = 0;
    public static boolean midday_message_sent = false;
    public static boolean clientIsCursedMoon = false;
    public static boolean clientIsNight = false;

    public static long getDayTime(class_1937 world) {
        return world.method_8532();
    }

    public static int getDay(class_1937 world) {
        return (int)(CursedMoon.getDayTime(world) / 24000L) + 1;
    }

    public static boolean isNight(class_1937 world) {
        long timeDayMoon = CursedMoon.getDayTime(world) - (long)(CursedMoon.getDay(world) - 1) * 24000L;
        return timeDayMoon > 12000L && timeDayMoon < 23000L;
    }

    public static boolean isDaytime(class_1937 world) {
        long timeDayMoon = CursedMoon.getDayTime(world) - (long)(CursedMoon.getDay(world) - 1) * 24000L;
        return timeDayMoon >= 0L && timeDayMoon <= 12000L;
    }

    public static boolean isCursedMoon(class_1937 world) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return clientIsCursedMoon;
        }
        CursedMoonData currentData = ShapeShifterCurseFabric.cursedMoonData.getInstance();
        if (currentData.isActive) {
            return CursedMoon.isCursedMoonByPhase(world);
        }
        return false;
    }

    public static boolean isCursedMoonByPhase(int moonPhase) {
        int[] curseMoonPhase = ShapeShifterCurseFabric.commonConfig.curseMoonPhase;
        return Arrays.stream(curseMoonPhase).anyMatch(phase -> phase == moonPhase);
    }

    public static boolean isCursedMoonByPhase(class_1937 world) {
        int moonPhase = world.method_30273();
        return CursedMoon.isCursedMoonByPhase(moonPhase);
    }

    public static boolean isNight() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return clientIsNight;
        }
        long timeDayMoon = day_time - (long)(day - 1) * 24000L;
        return timeDayMoon > 12000L && timeDayMoon < 23000L;
    }

    public static boolean isDaytime() {
        long timeDayMoon = day_time - (long)(day - 1) * 24000L;
        return timeDayMoon >= 0L && timeDayMoon <= 12000L;
    }

    public static void checkCursedMoonProbability(class_3218 world) {
        CursedMoonData data = ShapeShifterCurseFabric.cursedMoonData.getInstance();
        if (!data.isActive || !CursedMoon.isDaytime()) {
            return;
        }
        if (data.isTonightCursedMoon) {
            return;
        }
        if (world.method_8510() % 200L == 0L) {
            ShapeShifterCurseFabric.LOGGER.info("CursedMoon probability check: currentPerSecondProbability=" + data.currentPerSecondProbability + ", multiplier=" + data.probabilityIncrease);
        }
        if ((data.currentPerSecondProbability - data.basePerSecondProbability) / data.probabilityIncrease < 1200.0f) {
            data.currentPerSecondProbability += data.probabilityIncrease;
            if (data.currentPerSecondProbability > 0.05f) {
                data.currentPerSecondProbability = 0.05f;
            }
            return;
        }
        float random = world.method_8409().method_43057();
        if (random < data.currentPerSecondProbability) {
            data.isTonightCursedMoon = true;
            data.resetProbability(world);
            data.save(world);
            ShapeShifterCurseFabric.LOGGER.info("CursedMoon triggered for tonight! Day: " + day + ", random: " + random + ", probability: " + data.currentPerSecondProbability);
            for (class_3222 player : world.method_8503().method_3760().method_14571()) {
                if (FormAbilityManager.getForm((class_1657)player).equals(RegPlayerForms.ORIGINAL_BEFORE_ENABLE)) continue;
                if (player.method_37908().method_27983() == class_1937.field_25179) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.before_cursed_moon").method_27692(class_124.field_1064));
                    continue;
                }
                player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.before_cursed_moon_nether").method_27692(class_124.field_1064));
            }
            for (class_3222 player : world.method_8503().method_3760().method_14571()) {
                ModPacketsS2CServer.sendCursedMoonData(player, day_time, day, true, false);
            }
        } else {
            data.currentPerSecondProbability += data.probabilityIncrease;
            if (data.currentPerSecondProbability > 0.05f) {
                data.currentPerSecondProbability = 0.05f;
            }
            data.save(world);
        }
    }

    public static Optional<Integer> getNextCurseMoonPhase(int NowPhase) {
        int MoonPhaseCount = 8;
        for (int DaySkip = 0; DaySkip < MoonPhaseCount; ++DaySkip) {
            int CurrentPhase = (NowPhase + DaySkip) % MoonPhaseCount;
            if (!CursedMoon.isCursedMoonByPhase(CurrentPhase)) continue;
            return Optional.of(CurrentPhase);
        }
        return Optional.empty();
    }

    public static void forceTriggerCursedMoon(class_3218 world) {
        CursedMoonData data = ShapeShifterCurseFabric.cursedMoonData.getInstance();
        if (!data.isActive) {
            ShapeShifterCurseFabric.LOGGER.warn("Cannot trigger CursedMoon: system is not active");
            return;
        }
        int currentPhase = world.method_30273();
        Optional<Integer> nextCursedPhase = CursedMoon.getNextCurseMoonPhase(currentPhase);
        if (nextCursedPhase.isEmpty()) {
            ShapeShifterCurseFabric.LOGGER.warn("Cannot trigger CursedMoon: no next cursed phase found");
            return;
        }
        int targetPhase = nextCursedPhase.get();
        int daysToSkip = (targetPhase - currentPhase + 8) % 8;
        if (daysToSkip == 0) {
            daysToSkip = 8;
        }
        long currentTime = world.method_8532();
        long newTime = currentTime + (long)daysToSkip * 24000L;
        world.method_29199(newTime);
        data.save(world);
        ShapeShifterCurseFabric.LOGGER.info("CursedMoon manually triggered! Skipped " + daysToSkip + " days to reach moon phase " + targetPhase);
        for (class_3222 player : world.method_8503().method_3760().method_14571()) {
            if (FormAbilityManager.getForm((class_1657)player).equals(RegPlayerForms.ORIGINAL_BEFORE_ENABLE)) continue;
            player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.cursed_moon_forced").method_27692(class_124.field_1064));
        }
        boolean currentIsNight = CursedMoon.isNight((class_1937)world);
        for (class_3222 player : world.method_8503().method_3760().method_14571()) {
            ModPacketsS2CServer.sendCursedMoonData(player, newTime, CursedMoon.getDay((class_1937)world), true, currentIsNight);
        }
    }

    public static void applyMoonEffect(class_3222 player) {
        PlayerFormComponent formComp = (PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player);
        if (!formComp.isMoonEffectApplied()) {
            boolean isOverworld;
            boolean bl = isOverworld = player.method_37908().method_27983() == class_1937.field_25179;
            if (FormAbilityManager.getForm((class_1657)player).equals(RegPlayerForms.ORIGINAL_BEFORE_ENABLE)) {
                if (isOverworld) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.on_cursed_moon_before_enable").method_27692(class_124.field_1076));
                }
            } else {
                if (isOverworld) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.on_cursed_moon").method_27692(class_124.field_1076));
                } else {
                    player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.on_cursed_moon_nether").method_27692(class_124.field_1076));
                }
                ShapeShifterCurseFabric.ON_TRIGGER_CURSED_MOON.trigger(player);
            }
            ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCure(false);
            RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
            ShapeShifterCurseFabric.LOGGER.info("Cursed Moon rises!");
            if (!((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).isByCursedMoon() && !((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).isByCure()) {
                TransformManager.handleProgressiveTransform((class_1657)player, true);
            }
            formComp.setMoonEffectApplied(true);
            RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        }
    }

    public static void applyEndMoonEffect(class_3222 player) {
        PlayerFormComponent formComp = (PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player);
        if (!formComp.isEndMoonEffectApplied()) {
            boolean wasByCursedMoon = ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).isByCursedMoon();
            ShapeShifterCurseFabric.LOGGER.info("is player form by cursed moon? : " + wasByCursedMoon);
            if (FormAbilityManager.getForm((class_1657)player).equals(RegPlayerForms.ORIGINAL_BEFORE_ENABLE)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.end_cursed_moon_before_enable").method_27692(class_124.field_1076));
            } else if (FormAbilityManager.getForm((class_1657)player).getIndex() == 0 && !((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).isByCursedMoon()) {
                ShapeShifterCurseFabric.ON_END_CURSED_MOON_BUGGED_FORM_2.trigger(player);
            } else {
                PlayerFormComponent currentFormComponent = (PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player);
                if (currentFormComponent.isByCure()) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.end_cursed_moon_by_cure").method_27692(class_124.field_1076));
                    ShapeShifterCurseFabric.ON_END_CURSED_MOON_CURED.trigger(player);
                    if (currentFormComponent.getCurrentForm().getIndex() == -1) {
                        ShapeShifterCurseFabric.ON_END_CURSED_MOON_CURED_FORM_2.trigger(player);
                    }
                } else if (FormAbilityManager.getForm((class_1657)player).equals(RegPlayerForms.ORIGINAL_SHIFTER)) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.end_cursed_moon_special").method_27692(class_124.field_1076));
                } else if (FormAbilityManager.getForm((class_1657)player).getIndex() != 3 && currentFormComponent.isByCursedMoon()) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.end_cursed_moon").method_27692(class_124.field_1076));
                    ShapeShifterCurseFabric.ON_END_CURSED_MOON.trigger(player);
                }
            }
            ShapeShifterCurseFabric.LOGGER.info("Cursed Moon ends!");
            TransformManager.setIsByCursedMoonEnd(player, true);
            ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCursedMoon(true);
            FormAbilityManager.saveForm((class_1657)player);
            RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
            if (wasByCursedMoon && !((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).isByCure()) {
                TransformManager.handleMoonEndTransform((class_1657)player);
            }
            formComp.setEndMoonEffectApplied(true);
            FormAbilityManager.saveForm((class_1657)player);
            RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
            FormAbilityManager.saveForm((class_1657)player);
        }
    }

    public static void resetMoonEffect(class_3222 player) {
        PlayerFormComponent formComp = (PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player);
        formComp.setEndMoonEffectApplied(false);
        formComp.setMoonEffectApplied(false);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        FormAbilityManager.saveForm((class_1657)player);
    }

    public static void resetCursedMoonForNewDay(class_3218 world) {
        clientIsCursedMoon = CursedMoon.isCursedMoonByPhase((class_1937)world);
        clientIsNight = CursedMoon.isNight((class_1937)world);
        ShapeShifterCurseFabric.LOGGER.info("Updated Cursed Moon status for new day: " + day + ", Moon Phase: " + world.method_30273() + ", Is Cursed: " + clientIsCursedMoon);
    }
}

