/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.data;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.player_form.ability.PlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.ability.RegPlayerFormComponent;

public class CursedMoonData {
    private static final CursedMoonData instance = new CursedMoonData();
    public float basePerSecondProbability = 1.0E-4f;
    public float currentPerSecondProbability = 1.0E-4f;
    public float probabilityIncrease = 4.2E-7f;
    public boolean isTonightCursedMoon = false;
    public int lastCheckedDay = 0;
    public float lastTriggerTime;
    public int startDay = 0;
    public int perDay = 3;
    public boolean isActive = false;
    private static final Path LEGACY_SAVE_DIR = Paths.get("config", "shape_shifter_curse_fabric");

    private static Path getSaveDir(class_3218 world) {
        return world.method_8503().method_27050(class_5218.field_24188).resolve("shape-shifter-curse");
    }

    private static Path getLegacyWorldSaveDir(class_3218 world) {
        Path worldSavePath = world.method_8503().method_27050(class_5218.field_24188);
        String worldName = worldSavePath.getFileName().toString();
        return LEGACY_SAVE_DIR.resolve(worldName);
    }

    private class_2487 serialize() {
        class_2487 moonData = new class_2487();
        moonData.method_10548("basePerSecondProbability", this.basePerSecondProbability);
        moonData.method_10548("currentPerSecondProbability", this.currentPerSecondProbability);
        moonData.method_10548("probabilityIncrease", this.probabilityIncrease);
        moonData.method_10556("isTonightCursedMoon", this.isTonightCursedMoon);
        moonData.method_10569("lastCheckedDay", this.lastCheckedDay);
        moonData.method_10548("lastTriggerTime", this.lastTriggerTime);
        moonData.method_10569("startDay", this.startDay);
        moonData.method_10569("perDay", this.perDay);
        moonData.method_10556("isActive", this.isActive);
        return moonData;
    }

    private void deserialize(class_2487 nbt) {
        if (nbt == null) {
            ShapeShifterCurseFabric.LOGGER.error("Failed to get Cursed Moon Data");
            return;
        }
        try {
            this.basePerSecondProbability = nbt.method_10583("basePerSecondProbability");
            this.currentPerSecondProbability = nbt.method_10583("currentPerSecondProbability");
            this.probabilityIncrease = nbt.method_10583("probabilityIncrease");
            this.isTonightCursedMoon = nbt.method_10577("isTonightCursedMoon");
            this.lastCheckedDay = nbt.method_10550("lastCheckedDay");
            this.lastTriggerTime = nbt.method_10583("lastTriggerTime");
            this.startDay = nbt.method_10550("startDay");
            this.perDay = nbt.method_10550("perDay");
            this.isActive = nbt.method_10577("isActive");
        }
        catch (Exception e) {
            ShapeShifterCurseFabric.LOGGER.error("Failed to read Cursed Moon Data", (Throwable)e);
        }
    }

    public void save(class_3218 world) {
        try {
            Path worldSaveDir = CursedMoonData.getSaveDir(world);
            if (!worldSaveDir.toFile().exists()) {
                worldSaveDir.toFile().mkdirs();
            }
            class_2487 nbt = this.serialize();
            class_2507.method_10630((class_2487)nbt, (File)worldSaveDir.resolve("cursed_moon_data.dat").toFile());
        }
        catch (Exception e) {
            ShapeShifterCurseFabric.LOGGER.error("Failed to save Cursed Moon Data", (Throwable)e);
        }
    }

    public void load(class_3218 world) {
        try {
            Path saveDir = CursedMoonData.getSaveDir(world);
            Path legacySaveDir = CursedMoonData.getLegacyWorldSaveDir(world);
            Path dataFile = saveDir.resolve("cursed_moon_data.dat");
            Path legacyDataFile = legacySaveDir.resolve("cursed_moon_data.dat");
            class_2487 nbt = null;
            if (dataFile.toFile().exists()) {
                nbt = class_2507.method_10633((File)dataFile.toFile());
            } else if (legacyDataFile.toFile().exists()) {
                ShapeShifterCurseFabric.LOGGER.info("Migrating Cursed Moon Data for world: " + world.method_8503().method_27050(class_5218.field_24188).getFileName().toString());
                nbt = class_2507.method_10633((File)legacyDataFile.toFile());
                if (nbt != null) {
                    this.deserialize(nbt);
                    this.save(world);
                    legacyDataFile.toFile().delete();
                }
            }
            if (nbt != null) {
                this.deserialize(nbt);
            }
        }
        catch (Exception e) {
            ShapeShifterCurseFabric.LOGGER.error("Failed to load Cursed Moon Data", (Throwable)e);
        }
    }

    public CursedMoonData getInstance() {
        return instance;
    }

    public void enableCursedMoon(class_3218 world) {
        this.isActive = true;
    }

    public void disableCursedMoon(class_3218 world) {
        this.isActive = false;
        ShapeShifterCurseFabric.LOGGER.info("Cursed Moon disabled");
        this.basePerSecondProbability = 0.0f;
        this.currentPerSecondProbability = 0.0f;
        this.probabilityIncrease = 0.0f;
        this.save(world);
    }

    public void resetProbability(class_3218 world) {
        this.currentPerSecondProbability = this.basePerSecondProbability = 1.0E-4f;
        this.lastTriggerTime = world.method_8532();
        this.probabilityIncrease = 4.2E-7f;
        this.save(world);
        ShapeShifterCurseFabric.LOGGER.info("CursedMoon probability system reset");
    }

    public void saveTonightStatus(class_3218 world) {
        this.save(world);
        ShapeShifterCurseFabric.LOGGER.info("\u4fdd\u5b58\u8bc5\u5492\u4e4b\u6708\u72b6\u6001: " + this.isTonightCursedMoon);
    }

    public void savePlayerStates(class_3218 world, class_3222 player) {
        PlayerFormComponent formComp = (PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player);
        class_2487 playerData = new class_2487();
        playerData.method_10556("moonEffectApplied", formComp.isMoonEffectApplied());
        playerData.method_10556("endMoonEffectApplied", formComp.isEndMoonEffectApplied());
        try {
            Path playerSaveDir = this.getPlayerSaveDir(world, player);
            if (!playerSaveDir.toFile().exists()) {
                playerSaveDir.toFile().mkdirs();
            }
            class_2507.method_10630((class_2487)playerData, (File)playerSaveDir.resolve(player.method_5667().toString() + ".dat").toFile());
        }
        catch (Exception e) {
            ShapeShifterCurseFabric.LOGGER.error("\u4fdd\u5b58\u73a9\u5bb6\u6708\u4eae\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
    }

    public void loadPlayerStates(class_3218 world, class_3222 player) {
        try {
            Path playerSaveDir = this.getPlayerSaveDir(world, player);
            class_2487 playerData = class_2507.method_10633((File)playerSaveDir.resolve(player.method_5667().toString() + ".dat").toFile());
            if (playerData != null) {
                PlayerFormComponent formComp = (PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player);
                formComp.setMoonEffectApplied(playerData.method_10577("moonEffectApplied"));
                formComp.setEndMoonEffectApplied(playerData.method_10577("endMoonEffectApplied"));
            }
        }
        catch (Exception e) {
            ShapeShifterCurseFabric.LOGGER.error("\u52a0\u8f7d\u73a9\u5bb6\u6708\u4eae\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
    }

    private Path getPlayerSaveDir(class_3218 world, class_3222 player) {
        return world.method_8503().method_27050(class_5218.field_24188).resolve("shape-shifter-curse").resolve("moon_states");
    }
}

