/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.integration.origins.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;

public class Scheduler {
    private final Int2ObjectMap<List<Consumer<MinecraftServer>>> taskQueue = new Int2ObjectOpenHashMap();
    private int currentTick = 0;

    public Scheduler() {
        ServerTickEvents.END_SERVER_TICK.register(m -> {
            this.currentTick = m.method_3780();
            List runnables = (List)this.taskQueue.remove(this.currentTick);
            if (runnables != null) {
                for (int i = 0; i < runnables.size(); ++i) {
                    Repeating repeating;
                    Consumer runnable = (Consumer)runnables.get(i);
                    runnable.accept(m);
                    if (!(runnable instanceof Repeating) || !(repeating = (Repeating)runnable).shouldQueue(this.currentTick)) continue;
                    this.queue(runnable, ((Repeating)runnable).next);
                }
            }
        });
    }

    public void queue(Consumer<MinecraftServer> task, int tick) {
        ((List)this.taskQueue.computeIfAbsent(this.currentTick + tick + 1, t -> new ArrayList())).add(task);
    }

    public void repeating(Consumer<MinecraftServer> task, int tick, int interval) {
        this.repeatWhile(task, null, tick, interval);
    }

    public void repeatWhile(Consumer<MinecraftServer> task, IntPredicate requeue, int tick, int interval) {
        this.queue(new Repeating(task, requeue, interval), tick);
    }

    public void repeatN(Consumer<MinecraftServer> task, final int times, int tick, int interval) {
        this.repeatWhile(task, new IntPredicate(){
            private int remaining;
            {
                this.remaining = times;
            }

            @Override
            public boolean test(int value) {
                return this.remaining-- > 0;
            }
        }, tick, interval);
    }

    private static final class Repeating
    implements Consumer<MinecraftServer> {
        private final Consumer<MinecraftServer> task;
        private final IntPredicate requeue;
        public final int next;

        private Repeating(Consumer<MinecraftServer> task, IntPredicate requeue, int interval) {
            this.task = task;
            this.requeue = requeue;
            this.next = interval;
        }

        public boolean shouldQueue(int predicate) {
            if (this.requeue == null) {
                return true;
            }
            return this.requeue.test(predicate);
        }

        @Override
        public void accept(MinecraftServer server) {
            this.task.accept(server);
        }
    }
}

