/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.mixin;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import io.github.apace100.apoli.component.PowerHolderComponent;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1268;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1786;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.additional_power.BatBlockAttachPower;
import net.onixary.shapeShifterCurseFabric.additional_power.CrawlingPower;
import net.onixary.shapeShifterCurseFabric.client.ClientPlayerStateManager;
import net.onixary.shapeShifterCurseFabric.client.ShapeShifterCurseFabricClient;
import net.onixary.shapeShifterCurseFabric.player_animation.AnimationHolder;
import net.onixary.shapeShifterCurseFabric.player_animation.PlayerAnimState;
import net.onixary.shapeShifterCurseFabric.player_animation.form_animation.AnimationTransform;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormBase;
import net.onixary.shapeShifterCurseFabric.player_form.RegPlayerForms;
import net.onixary.shapeShifterCurseFabric.player_form.ability.PlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.ability.RegPlayerFormComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class PlayerEntityAnimOverrideMixin
extends class_1657 {
    @Unique
    private final ModifierLayer<IAnimation> CONTAINER = new ModifierLayer();
    public PlayerAnimState currentState = PlayerAnimState.NONE;
    public PlayerAnimState previousState = PlayerAnimState.NONE;
    public float momentum = 0.0f;
    public float turnDelta = 0.0f;
    public class_243 lastPos = new class_243(0.0, 0.0, 0.0);
    public boolean lastOnGround = false;
    public boolean hasSlowFall = false;
    private int tickCounter = 0;
    private PlayerFormBase curForm;
    KeyframeAnimation currentAnimation = null;
    boolean overrideHandAnim = false;
    AnimationHolder animToPlay = null;
    boolean isAttackAnim = false;
    int continueSwingAnimCounter = 0;
    PlayerFormBase transformCurrentForm;
    PlayerFormBase transformToForm;
    private boolean modified = false;
    private boolean armAnimationsEnabled = true;

    @Unique
    private boolean CanClimbAnim() {
        if (!this.method_6101() || this.method_24828() || this.method_31549().field_7479 || this.method_6128()) {
            return false;
        }
        class_2338 down1pos = this.method_24515().method_10074();
        class_2680 down1block = this.method_37908().method_8320(down1pos);
        class_243 ClimbAnimTestPoint = this.method_19538().method_1031(0.0, (double)-0.6f, 0.0);
        class_3965 HitResult = down1block.method_26220((class_1922)this.method_37908(), down1pos).method_1092(this.method_19538(), ClimbAnimTestPoint, down1pos);
        if (HitResult == null) {
            return true;
        }
        return HitResult.method_17783() == class_239.class_240.field_1333;
    }

    public PlayerEntityAnimOverrideMixin(class_638 world, GameProfile gameProfile) {
        super((class_1937)world, world.method_43126(), world.method_43127(), gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void shape_shifter_curse$init(class_638 level, GameProfile profile, CallbackInfo info) {
        PlayerAnimationAccess.getPlayerAnimLayer((class_742)((class_742)this)).addAnimLayer(1, this.CONTAINER);
        AnimationTransform.registerAnims();
        RegPlayerForms.playerForms.forEach((formID, form) -> form.Anim_registerAnims());
        this.currentAnimation = null;
        this.CONTAINER.setAnimation(null);
    }

    public void method_5773() {
        PlayerFormBase latestForm;
        ClientPlayerStateManager.PlayerAttachState otherPlayerState;
        boolean isWalkingForwards;
        super.method_5773();
        ++this.tickCounter;
        if (this.tickCounter == 20) {
            this.tickCounter = 0;
        }
        class_1937 world = this.method_5770();
        boolean onGround = this.method_24828();
        float delta = 0.05f;
        class_243 pos = this.method_19538();
        this.curForm = ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)this)).getCurrentForm();
        if (!this.method_24828() && this.lastOnGround && this.method_18798().field_1351 > 0.0) {
            this.currentState = this.method_5715() ? PlayerAnimState.ANIM_SNEAK_JUMP : PlayerAnimState.ANIM_JUMP;
        }
        if (!this.method_24828() && this.lastOnGround && (Math.abs(this.method_18798().field_1350) > 0.15 || Math.abs(this.method_18798().field_1352) > 0.15) && this.curForm.getCanRushJump()) {
            this.currentState = PlayerAnimState.ANIM_RUSH_JUMP;
        }
        class_2248 standingBlock = world.method_8320(this.method_24515().method_10074()).method_26204();
        Vec3f movementVector = new Vec3f((float)(pos.field_1352 - this.lastPos.field_1352), 0.0f, (float)(pos.field_1350 - this.lastPos.field_1350));
        Vec3f lookVector = new Vec3f((float)Math.cos(Math.toRadians(this.field_6283 + 90.0f)), 0.0f, (float)Math.sin(Math.toRadians(this.field_6283 + 90.0f)));
        float movementLength = (float)Math.sqrt(((Float)movementVector.getX()).floatValue() * ((Float)movementVector.getX()).floatValue() + ((Float)movementVector.getY()).floatValue() * ((Float)movementVector.getY()).floatValue() + ((Float)movementVector.getZ()).floatValue() * ((Float)movementVector.getZ()).floatValue());
        boolean isWalking = movementLength > 0.0f;
        float dotProduct = ((Float)movementVector.getX()).floatValue() * ((Float)lookVector.getX()).floatValue() + ((Float)movementVector.getY()).floatValue() * ((Float)lookVector.getY()).floatValue() + ((Float)movementVector.getZ()).floatValue() * ((Float)lookVector.getZ()).floatValue();
        boolean bl = isWalkingForwards = isWalking && dotProduct > 0.0f;
        float walk_sign = isWalking ? (isWalkingForwards ? 1.0f : -1.0f) : 0.0f;
        float sprint_multiplier = this.method_5624() && isWalkingForwards ? 2 : 1;
        this.momentum = class_3532.method_16439((float)(delta * 2.0f * sprint_multiplier), (float)this.momentum, (float)(walk_sign * sprint_multiplier));
        boolean onGroundInWater = this.method_5869() && this.method_43261().method_26220((class_1922)this.method_37908(), this.method_24515()).method_1110();
        boolean isInShallowWater = this.method_5816() && !this.method_5869() && this.method_24828();
        int handSwingDuration = 0;
        if (class_1292.method_5576((class_1309)this)) {
            handSwingDuration = 6 - (1 + class_1292.method_5575((class_1309)this));
        } else {
            int n = handSwingDuration = this.method_6059(class_1294.field_5901) ? 6 + (1 + this.method_6112(class_1294.field_5901).method_5578()) * 2 : 6;
        }
        if (this.method_6115()) {
            this.currentState = PlayerAnimState.ANIM_IDLE;
        } else if (!this.field_6252) {
            if (this.method_5854() != null) {
                this.currentState = this.method_5854() instanceof class_1690 ? PlayerAnimState.ANIM_BOAT_IDLE : PlayerAnimState.ANIM_RIDE_IDLE;
            }
            if (this.CanClimbAnim()) {
                this.currentState = PlayerAnimState.ANIM_CLIMB_IDLE;
                if (this.method_18798().field_1351 > 0.0) {
                    this.currentState = PlayerAnimState.ANIM_CLIMB;
                }
            } else if (this.method_6115()) {
                if (this.method_6047().method_7909().method_19263()) {
                    // empty if block
                }
                if (this.method_6047().method_7976() == class_1839.field_8946) {
                    // empty if block
                }
            } else if (this.method_31549().field_7479) {
                this.currentState = PlayerAnimState.ANIM_CREATIVE_FLY;
            } else if (this.method_6128()) {
                this.currentState = PlayerAnimState.ANIM_ELYTRA_FLY;
            } else if ((this.method_24828() || onGroundInWater) && !this.isAttackAnim) {
                this.currentState = this.method_6113() ? PlayerAnimState.ANIM_SLEEP : PlayerAnimState.ANIM_IDLE;
                if ((this.method_5816() || this.method_5771()) && !onGroundInWater && !isInShallowWater) {
                    if (this.method_5681() || this.method_5624()) {
                        this.currentState = PlayerAnimState.ANIM_SWIM;
                    }
                } else if (this.method_5715()) {
                    this.currentState = PlayerAnimState.ANIM_SNEAK_IDLE;
                    if (isWalking || this.turnDelta != 0.0f) {
                        this.currentState = this.curForm.getCanSneakRush() ? (this.method_7344().method_7586() >= 6 ? PlayerAnimState.ANIM_SNEAK_RUSH : PlayerAnimState.ANIM_SNEAK_WALK) : PlayerAnimState.ANIM_SNEAK_WALK;
                    }
                } else if (isWalking) {
                    this.currentState = this.method_5624() && !this.method_6115() ? PlayerAnimState.ANIM_RUN : PlayerAnimState.ANIM_WALK;
                }
            } else if (!this.method_24828() && this.method_18798().field_1351 < 0.0) {
                if (this.hasSlowFall) {
                    this.currentState = PlayerAnimState.ANIM_SLOW_FALL;
                } else if (this.field_6017 > 0.6f) {
                    this.currentState = this.method_5715() ? PlayerAnimState.ANIM_SNEAK_FALL : PlayerAnimState.ANIM_FALL;
                }
            }
            if (this.method_20448() || PowerHolderComponent.hasPower((class_1297)this, CrawlingPower.class) && this.method_5715() && !this.method_5681()) {
                this.currentState = isWalking ? PlayerAnimState.ANIM_CRAWL : PlayerAnimState.ANIM_CRAWL_IDLE;
            } else if (this.method_5869() || this.method_5771()) {
                this.currentState = this.method_5681() || this.method_5624() ? PlayerAnimState.ANIM_SWIM : PlayerAnimState.ANIM_SWIM_IDLE;
            }
            this.continueSwingAnimCounter = 0;
        } else if (this.continueSwingAnimCounter < 10) {
            ++this.continueSwingAnimCounter;
            this.currentState = this.method_5715() ? PlayerAnimState.ANIM_SNEAK_ATTACK_ONCE : PlayerAnimState.ANIM_ATTACK_ONCE;
        } else {
            this.currentState = this.method_6113() ? PlayerAnimState.ANIM_SLEEP : (!this.method_24828() ? PlayerAnimState.ANIM_FALL : (this.method_5715() ? PlayerAnimState.ANIM_SNEAK_TOOL_SWING : PlayerAnimState.ANIM_TOOL_SWING));
        }
        AtomicBoolean foundLocalPower = new AtomicBoolean(false);
        PowerHolderComponent.getPowers((class_1297)this, BatBlockAttachPower.class).stream().filter(power -> power.isAttached()).findFirst().ifPresent(attachPower -> {
            if (attachPower.getAttachType() == BatBlockAttachPower.AttachType.SIDE) {
                this.currentState = PlayerAnimState.ANIM_ATTACH_SIDE;
            } else if (attachPower.getAttachType() == BatBlockAttachPower.AttachType.BOTTOM) {
                this.currentState = PlayerAnimState.ANIM_ATTACH_BOTTOM;
            }
            foundLocalPower.set(true);
        });
        if (!foundLocalPower.get() && (otherPlayerState = ClientPlayerStateManager.getPlayerAttachState(this.method_5667())) != null && otherPlayerState.isAttached) {
            if (otherPlayerState.attachType == BatBlockAttachPower.AttachType.SIDE) {
                this.currentState = PlayerAnimState.ANIM_ATTACH_SIDE;
            } else if (otherPlayerState.attachType == BatBlockAttachPower.AttachType.BOTTOM) {
                this.currentState = PlayerAnimState.ANIM_ATTACH_BOTTOM;
            }
        }
        if (ShapeShifterCurseFabricClient.isClientTransforming()) {
            String fromFormName = ShapeShifterCurseFabricClient.getClientTransformFromForm();
            String toFormName = ShapeShifterCurseFabricClient.getClientTransformToForm();
            try {
                this.transformCurrentForm = fromFormName != null ? RegPlayerForms.getPlayerForm(fromFormName) : null;
                this.transformToForm = toFormName != null ? RegPlayerForms.getPlayerForm(toFormName) : null;
            }
            catch (IllegalArgumentException e) {
                this.transformCurrentForm = this.curForm;
                this.transformToForm = this.curForm;
            }
            this.currentState = PlayerAnimState.ANIM_ON_TRANSFORM;
        } else if (this.previousState == PlayerAnimState.ANIM_ON_TRANSFORM && !(latestForm = ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)this)).getCurrentForm()).equals(this.curForm)) {
            this.curForm = latestForm;
            ShapeShifterCurseFabric.LOGGER.info("Animation system updated curForm after transform: " + String.valueOf(this.curForm));
        }
        this.lastPos = new class_243(pos.field_1352, pos.field_1351, pos.field_1350);
        this.lastOnGround = onGround;
        if (this.previousState != this.currentState) {
            this.previousState = this.currentState;
        }
        this.animToPlay = null;
        if (this.currentState == PlayerAnimState.ANIM_ON_TRANSFORM) {
            this.animToPlay = AnimationTransform.getFormAnimToPlay(this.transformCurrentForm, this.transformToForm);
        } else {
            this.animToPlay = this.curForm.Anim_getFormAnimToPlay(this.currentState);
            this.hasSlowFall = this.curForm.getHasSlowFall();
            this.overrideHandAnim = this.curForm.getOverrideHandAnim();
        }
        if (this.animToPlay != null) {
            this.playAnimation(this.animToPlay.getAnimation(), this.animToPlay.getSpeed(), this.animToPlay.getFade());
        } else {
            this.CONTAINER.setAnimation(null);
            this.currentAnimation = null;
        }
    }

    public void playAnimation(KeyframeAnimation anim) {
        this.playAnimation(anim, 1.0f, 10);
    }

    public void playAnimation(KeyframeAnimation anim, float speed, int fade) {
        this.playAnimation(this.CONTAINER, anim, speed, fade);
    }

    public void playAnimation(ModifierLayer<IAnimation> container, KeyframeAnimation anim, float speed, int fade) {
        if (this.currentAnimation == anim || anim == null) {
            return;
        }
        this.currentAnimation = anim;
        KeyframeAnimation.AnimationBuilder builder = anim.mutableCopy();
        builder.leftArm.setEnabled(this.armAnimationsEnabled);
        builder.rightArm.setEnabled(this.armAnimationsEnabled);
        anim = builder.build();
        if (this.modified) {
            container.removeModifier(0);
        }
        this.modified = true;
        container.addModifierBefore((AbstractModifier)new SpeedModifier(speed));
        container.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fade, (Ease)Ease.LINEAR), (IAnimation)new KeyframeAnimationPlayer(anim));
        container.setupAnim(0.05f);
    }

    public void method_6104(class_1268 hand) {
        super.method_6104(hand);
        if (this.method_6030().method_7909() instanceof class_1786 && this.method_6115()) {
            return;
        }
        this.currentState = PlayerAnimState.ANIM_TOOL_SWING;
    }

    public void disableArmAnimations() {
        if (this.currentAnimation != null && this.armAnimationsEnabled) {
            this.armAnimationsEnabled = false;
            ModifierLayer<IAnimation> animationContainer = this.CONTAINER;
            KeyframeAnimation.AnimationBuilder builder = this.currentAnimation.mutableCopy();
            builder.leftArm.setEnabled(false);
            builder.rightArm.setEnabled(false);
            this.currentAnimation = builder.build();
            if (this.modified) {
                animationContainer.removeModifier(0);
            }
            this.modified = true;
            animationContainer.addModifierBefore((AbstractModifier)new SpeedModifier(1.0f));
            animationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.LINEAR), (IAnimation)new KeyframeAnimationPlayer(this.currentAnimation));
            animationContainer.setupAnim(0.05f);
            animationContainer.tick();
        }
    }
}

