/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.mixin;

import io.github.apace100.apoli.component.PowerHolderComponent;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.additional_power.BatBlockAttachPower;
import net.onixary.shapeShifterCurseFabric.additional_power.JumpEventCondition;
import net.onixary.shapeShifterCurseFabric.additional_power.SprintingStateTracker;
import net.onixary.shapeShifterCurseFabric.networking.ModPackets;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerMovementControlMixin {
    @Inject(method={"travel"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventTravelWhenAttached(class_243 movementInput, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.getNullable((Object)player);
        if (component == null) {
            return;
        }
        BatBlockAttachPower attachPower = PowerHolderComponent.getPowers((class_1297)player, BatBlockAttachPower.class).stream().filter(BatBlockAttachPower::isAttached).findFirst().orElse(null);
        if (attachPower != null) {
            player.method_18800(0.0, 0.0, 0.0);
            ci.cancel();
        }
    }

    @Inject(method={"getMovementSpeed()F"}, at={@At(value="RETURN")}, cancellable=true)
    private void zeroMovementSpeedWhenAttached(CallbackInfoReturnable<Float> cir) {
        class_1657 player = (class_1657)this;
        PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.getNullable((Object)player);
        if (component == null) {
            return;
        }
        BatBlockAttachPower attachPower = PowerHolderComponent.getPowers((class_1297)player, BatBlockAttachPower.class).stream().filter(BatBlockAttachPower::isAttached).findFirst().orElse(null);
        if (attachPower != null) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    @Inject(method={"jump"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleJump(CallbackInfo ci) {
        class_2540 buf;
        class_1657 player = (class_1657)this;
        PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.getNullable((Object)player);
        if (component == null) {
            return;
        }
        BatBlockAttachPower attachPower = PowerHolderComponent.getPowers((class_1297)player, BatBlockAttachPower.class).stream().filter(BatBlockAttachPower::isAttached).findFirst().orElse(null);
        if (attachPower != null) {
            if (player.method_37908().method_8608()) {
                buf = PacketByteBufs.create();
                ClientPlayNetworking.send((class_2960)ModPackets.JUMP_DETACH_REQUEST_ID, (class_2540)buf);
            }
            ci.cancel();
        }
        JumpEventCondition.setJumping(player, true);
        if (player.method_37908().method_8608()) {
            buf = PacketByteBufs.create();
            buf.method_10797(player.method_5667());
            ClientPlayNetworking.send((class_2960)ModPackets.JUMP_EVENT_ID, (class_2540)buf);
        }
    }

    @Inject(method={"checkFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventElytraCheckWhenAttached(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657)this;
        PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.getNullable((Object)player);
        if (component == null) {
            return;
        }
        BatBlockAttachPower attachPower = PowerHolderComponent.getPowers((class_1297)player, BatBlockAttachPower.class).stream().filter(BatBlockAttachPower::isAttached).findFirst().orElse(null);
        if (attachPower != null) {
            if (player.method_37908().method_8608()) {
                class_2540 buf = PacketByteBufs.create();
                ClientPlayNetworking.send((class_2960)ModPackets.JUMP_DETACH_REQUEST_ID, (class_2540)buf);
            }
            player.method_23670();
            player.method_24830(true);
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void trackSprintingState(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        boolean wasSprintingLastTick = SprintingStateTracker.wasSprintingLastTick(player);
        boolean isCurrentlySprinting = player.method_5624();
        boolean isCurrentlySneaking = player.method_5715();
        SprintingStateTracker.updateSprintingState(player, isCurrentlySprinting);
        if (wasSprintingLastTick && isCurrentlySneaking && SprintingStateTracker.canTrigger(player)) {
            ShapeShifterCurseFabric.LOGGER.info("Triggering sprint-to-sneak action for player: {}", (Object)player.method_5477().getString());
            SprintingStateTracker.setTriggered(player);
            if (player.method_37908().method_8608()) {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10797(player.method_5667());
                ClientPlayNetworking.send((class_2960)ModPackets.SPRINTING_TO_SNEAKING_EVENT_ID, (class_2540)buf);
            }
        }
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private void cleanupSprintingState(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        SprintingStateTracker.removePlayer(player);
    }
}

