/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.player_form.transform;

import dev.tr7zw.firstperson.FirstPersonModelCore;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.client.ShapeShifterCurseFabricClient;
import net.onixary.shapeShifterCurseFabric.cursed_moon.CursedMoon;
import net.onixary.shapeShifterCurseFabric.networking.ModPackets;
import net.onixary.shapeShifterCurseFabric.networking.ModPacketsS2CServer;
import net.onixary.shapeShifterCurseFabric.player_form.FormRandomSelector;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormBase;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormGroup;
import net.onixary.shapeShifterCurseFabric.player_form.RegPlayerForms;
import net.onixary.shapeShifterCurseFabric.player_form.ability.FormAbilityManager;
import net.onixary.shapeShifterCurseFabric.player_form.ability.PlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.ability.RegPlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.effect.PlayerTransformEffectManager;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.InstinctTicker;
import net.onixary.shapeShifterCurseFabric.screen_effect.TransformFX;
import net.onixary.shapeShifterCurseFabric.screen_effect.TransformOverlay;
import net.onixary.shapeShifterCurseFabric.status_effects.attachment.EffectManager;
import net.onixary.shapeShifterCurseFabric.status_effects.attachment.PlayerEffectAttachment;

public class TransformManager {
    private static final boolean IS_FIRST_PERSON_MOD_LOADED = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && FabricLoader.getInstance().isModLoaded("firstperson");
    public static final PlayerTransformData LocalPlayerTransformData = new PlayerTransformData();
    public static final HashMap<UUID, PlayerTransformData> PlayerTransformDataMap = new HashMap();

    public static PlayerTransformData getPlayerTransformData(class_1657 player) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && (player instanceof class_746 || player == null)) {
            if (player != null) {
                TransformManager.LocalPlayerTransformData.curPlayer = player;
            }
            return LocalPlayerTransformData;
        }
        UUID uuid = player.method_5667();
        if (!PlayerTransformDataMap.containsKey(uuid)) {
            PlayerTransformDataMap.put(uuid, new PlayerTransformData());
        }
        PlayerTransformData data = PlayerTransformDataMap.get(uuid);
        data.curPlayer = player;
        return data;
    }

    private static void setTransformingState(boolean transforming, class_1657 player) {
        PlayerTransformData data = TransformManager.getPlayerTransformData(player);
        data.isTransforming = transforming;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            String fromFormName = data.curFromForm != null ? data.curFromForm.name() : null;
            String toFormName = data.curToForm != null ? data.curToForm.name() : null;
            ModPacketsS2CServer.sendTransformState(serverPlayer, transforming, fromFormName, toFormName);
            ShapeShifterCurseFabric.LOGGER.info("Sent transform state to client: " + transforming + ", from: " + fromFormName + ", to: " + toFormName);
        }
    }

    public static void handleProgressiveTransform(class_1657 player, boolean isByCursedMoon) {
        PlayerFormBase currentForm;
        PlayerTransformData data = TransformManager.getPlayerTransformData(player);
        data._isByCursedMoon = isByCursedMoon;
        data._isRegressedFromFinal = false;
        data._isByCure = false;
        data.curFromForm = currentForm = ((PlayerFormComponent)player.getComponent(RegPlayerFormComponent.PLAYER_FORM)).getCurrentForm();
        ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCursedMoon(isByCursedMoon);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        FormAbilityManager.saveForm(player);
        ShapeShifterCurseFabric.LOGGER.info("Progressive transform started, isByCursedMoon: " + isByCursedMoon + ", from: " + String.valueOf(data.curFromForm));
        int currentFormIndex = currentForm.getIndex();
        PlayerFormGroup currentFormGroup = currentForm.getGroup();
        PlayerFormBase toForm = null;
        switch (currentFormIndex) {
            case -2: {
                break;
            }
            case -1: {
                toForm = TransformManager.getRandomOrBuffForm(player);
                ShapeShifterCurseFabric.ON_TRANSFORM_0.trigger((class_3222)player);
                break;
            }
            case 0: {
                toForm = currentFormGroup.getForm(1);
                break;
            }
            case 1: {
                toForm = currentFormGroup.getForm(2);
                break;
            }
            case 2: {
                if (isByCursedMoon) {
                    toForm = currentFormGroup.getForm(0);
                    data._isRegressedFromFinal = true;
                    ShapeShifterCurseFabric.ON_TRIGGER_CURSED_MOON_FORM_2.trigger((class_3222)player);
                    break;
                }
                ShapeShifterCurseFabric.LOGGER.info("Triggered transformation when at max phase, this should not happen!");
                break;
            }
            case 3: {
                player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.on_cursed_moon_permanent").method_27692(class_124.field_1054));
                break;
            }
            case 5: {
                if (!isByCursedMoon) break;
                player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.on_cursed_moon_special").method_27692(class_124.field_1054));
            }
        }
        if (toForm == null) {
            ShapeShifterCurseFabric.LOGGER.info("No next form found, unless you haven't unlock mod contents, then this should not happen!");
            return;
        }
        data.curPlayer = player;
        data.curToForm = toForm;
        ShapeShifterCurseFabric.LOGGER.info("Cur Player: " + String.valueOf(data.curPlayer) + " To Form: " + String.valueOf(data.curToForm));
        PlayerTransformEffectManager.applyStartTransformEffect((class_3222)player, 60);
        TransformManager.handleTransformEffect(player);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        FormAbilityManager.saveForm(player);
        MinecraftServer server = player.method_5682();
        TransformManager.syncCursedMoonData(player, server);
    }

    public static void handleMoonEndTransform(class_1657 player) {
        PlayerFormBase currentForm;
        PlayerTransformData data = TransformManager.getPlayerTransformData(player);
        data.curFromForm = currentForm = ((PlayerFormComponent)player.getComponent(RegPlayerFormComponent.PLAYER_FORM)).getCurrentForm();
        int currentFormIndex = currentForm.getIndex();
        PlayerFormGroup currentFormGroup = currentForm.getGroup();
        PlayerFormBase toForm = null;
        switch (currentFormIndex) {
            case -2: {
                ShapeShifterCurseFabric.LOGGER.error("Moon end transformation triggered when mod is not enabled, this should not happen!");
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                if (((PlayerFormComponent)player.getComponent(RegPlayerFormComponent.PLAYER_FORM)).isRegressedFromFinal()) {
                    toForm = currentFormGroup.getForm(2);
                    break;
                }
                toForm = RegPlayerForms.ORIGINAL_SHIFTER;
                break;
            }
            case 1: {
                toForm = currentFormGroup.getForm(0);
                break;
            }
            case 2: {
                toForm = currentFormGroup.getForm(1);
            }
            case 3: 
            case 5: {
                break;
            }
        }
        if (toForm == null) {
            ShapeShifterCurseFabric.LOGGER.info("No next form found, this should not happen!");
            return;
        }
        data.curPlayer = player;
        data.curToForm = toForm;
        ShapeShifterCurseFabric.LOGGER.info("Cur Player: " + String.valueOf(data.curPlayer) + " To Form: " + String.valueOf(data.curToForm));
        data._isByCursedMoonEnd = true;
        data._isByCursedMoon = true;
        ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCursedMoon(true);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        PlayerTransformEffectManager.applyStartTransformEffect((class_3222)player, 60);
        TransformManager.handleTransformEffect(player);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        ShapeShifterCurseFabric.LOGGER.info("Moon end transform\uff0c_isByCursedMoonEnd=" + data._isByCursedMoonEnd + "\uff0ccomponent isByCursedMoon=" + ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).isByCursedMoon());
        MinecraftServer server = player.method_5682();
        TransformManager.syncCursedMoonData(player, server);
    }

    static PlayerFormBase getRandomOrBuffForm(class_1657 player) {
        PlayerEffectAttachment currentTransformEffect = EffectManager.getCurrentEffectAttachment(player);
        if (currentTransformEffect != null && currentTransformEffect.currentEffect != null) {
            return currentTransformEffect.currentToForm;
        }
        return FormRandomSelector.getRandomFormFromPredefined();
    }

    public static void update(class_3222 player) {
        PlayerTransformData data = TransformManager.getPlayerTransformData((class_1657)player);
        if (data.isEffectActive) {
            TransformManager.updateClientOverlayEffect((class_1657)player);
            --data.beginTransformEffectTicks;
            if (data.beginTransformEffectTicks <= 0) {
                data.isEffectActive = false;
                data.isEndEffectActive = true;
                if (data.curPlayer != null) {
                    boolean isCursedMoonRelated;
                    boolean bl = isCursedMoonRelated = ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)data.curPlayer)).isByCursedMoon() || data._isByCursedMoonEnd || data._isByCursedMoon;
                    if (!isCursedMoonRelated) {
                        InstinctTicker.clearInstinct(data.curPlayer);
                    }
                    FormAbilityManager.applyForm(data.curPlayer, data.curToForm);
                    ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)data.curPlayer)).setRegressedFromFinal(data._isRegressedFromFinal);
                    ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)data.curPlayer)).setByCure(data._isByCure);
                    RegPlayerFormComponent.PLAYER_FORM.sync((Object)data.curPlayer);
                } else {
                    ShapeShifterCurseFabric.LOGGER.error("curPlayer is null when trying to apply form!");
                }
                PlayerTransformEffectManager.applyEndTransformEffect((class_3222)data.curPlayer, 100);
            }
        } else if (data.isEndEffectActive) {
            TransformManager.updateClientOverlayFadeEffect((class_1657)player);
            --data.endTransformEffectTicks;
            if (data.endTransformEffectTicks <= 0) {
                if (data.curFromForm.equals(RegPlayerForms.ORIGINAL_BEFORE_ENABLE)) {
                    data.curPlayer.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.on_enable_mod_after").method_27692(class_124.field_1076));
                }
                TransformManager.sendClientTransformCompleteEffect((class_1657)player);
                PlayerTransformEffectManager.applyFinaleTransformEffect((class_3222)data.curPlayer, 5);
                InstinctTicker.isPausing = false;
                if (data._isByCursedMoonEnd) {
                    ShapeShifterCurseFabric.LOGGER.info("Finalizing moon end transform");
                    data._isByCursedMoon = false;
                    ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)data.curPlayer)).setByCursedMoon(false);
                    RegPlayerFormComponent.PLAYER_FORM.sync((Object)data.curPlayer);
                    data._isByCursedMoonEnd = false;
                }
                data.isTransforming = false;
                data.isEndEffectActive = false;
                data.beginTransformEffectTicks = 0;
                data.endTransformEffectTicks = 0;
                if (data.curPlayer != null) {
                    TransformManager.setTransformingState(false, data.curPlayer);
                }
            }
        }
    }

    private static void updateClientOverlayEffect(class_1657 player) {
        PlayerTransformData data = TransformManager.getPlayerTransformData(player);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && player instanceof class_746) {
            TransformManager.handleClientOverlayUpdate(1.0f - (float)data.beginTransformEffectTicks / 60.0f, data.beginTransformEffectTicks);
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.writeFloat(1.0f - (float)data.beginTransformEffectTicks / 60.0f);
        buf.writeInt(data.beginTransformEffectTicks);
        ServerPlayNetworking.send((class_3222)((class_3222)data.curPlayer), (class_2960)ModPackets.UPDATE_OVERLAY_EFFECT, (class_2540)buf);
    }

    private static void updateClientOverlayFadeEffect(class_1657 player) {
        PlayerTransformData data = TransformManager.getPlayerTransformData(player);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && player instanceof class_746) {
            TransformManager.handleClientOverlayFadeUpdate((float)data.endTransformEffectTicks / 100.0f, data.endTransformEffectTicks);
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.writeFloat((float)data.endTransformEffectTicks / 100.0f);
        buf.writeInt(data.endTransformEffectTicks);
        ServerPlayNetworking.send((class_3222)((class_3222)data.curPlayer), (class_2960)ModPackets.UPDATE_OVERLAY_FADE_EFFECT, (class_2540)buf);
    }

    private static void sendClientTransformCompleteEffect(class_1657 player) {
        PlayerTransformData data = TransformManager.getPlayerTransformData(player);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && player instanceof class_746) {
            TransformManager.executeClientTransformCompleteEffect();
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        ServerPlayNetworking.send((class_3222)((class_3222)data.curPlayer), (class_2960)ModPackets.TRANSFORM_COMPLETE_EFFECT, (class_2540)buf);
    }

    public static void executeClientTransformCompleteEffect() {
        if (IS_FIRST_PERSON_MOD_LOADED) {
            FirstPersonModelCore fpm = FirstPersonModelCore.instance;
            fpm.getConfig().xOffset = 0;
            fpm.getConfig().sitXOffset = 0;
            fpm.getConfig().sneakXOffset = 0;
        }
        TransformOverlay.INSTANCE.setEnableOverlay(false);
    }

    public static void handleClientOverlayUpdate(float nauseaStrength, int ticks) {
        PlayerTransformData data = TransformManager.getPlayerTransformData(null);
        data.nauesaStrength = nauseaStrength;
        data.blackStrength = data.nauesaStrength > 0.8f ? (data.nauesaStrength - 0.8f) / 0.2f : 0.0f;
        TransformOverlay.INSTANCE.setNauesaStrength(data.nauesaStrength);
        TransformOverlay.INSTANCE.setBlackStrength(data.blackStrength);
    }

    public static void handleClientOverlayFadeUpdate(float nauseaStrength, int ticks) {
        PlayerTransformData data = TransformManager.getPlayerTransformData(null);
        data.nauesaStrength = nauseaStrength;
        data.blackStrength = data.nauesaStrength > 0.6f ? 1.0f : data.nauesaStrength / 0.6f;
        TransformOverlay.INSTANCE.setNauesaStrength(data.nauesaStrength);
        TransformOverlay.INSTANCE.setBlackStrength(data.blackStrength);
    }

    public static void handleDirectTransform(class_1657 player, PlayerFormBase toForm, boolean isByCure) {
        PlayerTransformData data = TransformManager.getPlayerTransformData(player);
        data.curPlayer = player;
        data.curToForm = toForm;
        data.curFromForm = ((PlayerFormComponent)player.getComponent(RegPlayerFormComponent.PLAYER_FORM)).getCurrentForm();
        data._isByCure = isByCure;
        if (!CursedMoon.isCursedMoon(player.method_37908())) {
            data._isByCure = false;
        }
        int toFormIndex = data.curToForm.getIndex();
        if (!isByCure) {
            switch (toFormIndex) {
                case 0: {
                    ShapeShifterCurseFabric.ON_TRANSFORM_0.trigger((class_3222)player);
                    break;
                }
                case 1: {
                    ShapeShifterCurseFabric.ON_TRANSFORM_1.trigger((class_3222)player);
                    break;
                }
                case 2: {
                    ShapeShifterCurseFabric.ON_TRANSFORM_2.trigger((class_3222)player);
                    break;
                }
            }
        }
        ShapeShifterCurseFabric.LOGGER.info("Cur Player: " + String.valueOf(data.curPlayer) + " To Form: " + String.valueOf(data.curToForm));
        TransformManager.handleTransformEffect(player);
        PlayerTransformEffectManager.applyStartTransformEffect((class_3222)player, 60);
        MinecraftServer server = player.method_5682();
        TransformManager.syncCursedMoonData(player, server);
    }

    private static void syncCursedMoonData(class_1657 player, MinecraftServer server) {
        ShapeShifterCurseFabric.LOGGER.info("Cursed moon data saved by syncCursedMoonData");
        ShapeShifterCurseFabric.cursedMoonData.getInstance().save(server.method_30002());
    }

    private static void handleTransformEffect(class_1657 player) {
        PlayerTransformData data = TransformManager.getPlayerTransformData(player);
        data.isTransforming = true;
        data.beginTransformEffectTicks = 60;
        data.endTransformEffectTicks = 100;
        data.isEffectActive = true;
        InstinctTicker.isPausing = true;
        TransformManager.setTransformingState(true, player);
        if (!player.method_37908().field_9236 && player instanceof class_3222) {
            class_2540 buf = PacketByteBufs.create();
            ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)ModPackets.TRANSFORM_EFFECT_ID, (class_2540)buf);
        }
    }

    public static void playClientTransformEffect() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        PlayerTransformData data = TransformManager.getPlayerTransformData(null);
        data.isTransforming = true;
        data.beginTransformEffectTicks = 60;
        data.endTransformEffectTicks = 100;
        data.isEffectActive = true;
        InstinctTicker.isPausing = true;
        ShapeShifterCurseFabricClient.emitTransformParticle(60);
        TransformFX.beginTransformEffect();
        TransformOverlay.INSTANCE.setEnableOverlay(true);
    }

    public static void setFormDirectly(class_1657 player, PlayerFormBase toForm) {
        PlayerTransformData data = TransformManager.getPlayerTransformData(player);
        data.curPlayer = player;
        data.curToForm = toForm;
        FormAbilityManager.applyForm(data.curPlayer, data.curToForm);
        TransformManager.clearFormFlag(data.curPlayer);
        InstinctTicker.clearInstinct(data.curPlayer);
        TransformManager.sendClientFirstPersonReset(player);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)data.curPlayer);
        MinecraftServer server = player.method_5682();
        TransformManager.syncCursedMoonData(player, server);
    }

    private static void sendClientFirstPersonReset(class_1657 player) {
        PlayerTransformData data = TransformManager.getPlayerTransformData(player);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && player instanceof class_746) {
            TransformManager.executeClientFirstPersonReset();
        } else if (data.curPlayer instanceof class_3222) {
            class_2540 buf = PacketByteBufs.create();
            ServerPlayNetworking.send((class_3222)((class_3222)data.curPlayer), (class_2960)ModPackets.RESET_FIRST_PERSON, (class_2540)buf);
        }
    }

    public static void executeClientFirstPersonReset() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        if (IS_FIRST_PERSON_MOD_LOADED) {
            FirstPersonModelCore fpm = FirstPersonModelCore.instance;
            fpm.getConfig().xOffset = 0;
            fpm.getConfig().sitXOffset = 0;
            fpm.getConfig().sneakXOffset = 0;
            new Thread(() -> {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                fpm.getConfig().xOffset = 0;
                fpm.getConfig().sitXOffset = 0;
                fpm.getConfig().sneakXOffset = 0;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                fpm.getConfig().xOffset = 0;
                fpm.getConfig().sitXOffset = 0;
                fpm.getConfig().sneakXOffset = 0;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                fpm.getConfig().xOffset = 0;
                fpm.getConfig().sitXOffset = 0;
                fpm.getConfig().sneakXOffset = 0;
                try {
                    Thread.sleep(800L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                fpm.getConfig().xOffset = 0;
                fpm.getConfig().sitXOffset = 0;
                fpm.getConfig().sneakXOffset = 0;
            }).start();
        }
    }

    public static void clearFormFlag(class_1657 player) {
        PlayerTransformData data = TransformManager.getPlayerTransformData(player);
        boolean wasByCursedMoon = ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).isByCursedMoon();
        ShapeShifterCurseFabric.LOGGER.info("Clearing form flags, wasByCursedMoon: " + wasByCursedMoon + ", _isByCursedMoonEnd: " + data._isByCursedMoonEnd);
        if (data._isByCursedMoonEnd) {
            data._isByCursedMoon = false;
            ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCursedMoon(false);
            ShapeShifterCurseFabric.LOGGER.info("Cleared cursed moon flag due to moon end");
        }
        data._isRegressedFromFinal = false;
        data._isByCure = false;
        data._isByCursedMoonEnd = false;
        ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setRegressedFromFinal(false);
        ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCure(false);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
    }

    public static void setIsByCursedMoonEnd(class_3222 player, boolean value) {
        PlayerTransformData data = TransformManager.getPlayerTransformData((class_1657)player);
        data._isByCursedMoonEnd = value;
        ShapeShifterCurseFabric.LOGGER.info("\u8bbe\u7f6e_isByCursedMoonEnd=" + value);
    }

    public static void clearMoonEndFlags(class_1657 player) {
        ShapeShifterCurseFabric.LOGGER.info("\u5b89\u5168\u6e05\u9664\u6708\u4eae\u7ed3\u675f\u6807\u8bb0");
        PlayerTransformData data = TransformManager.getPlayerTransformData(player);
        boolean wasByCursedMoon = ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).isByCursedMoon();
        if (data._isByCursedMoonEnd) {
            ShapeShifterCurseFabric.LOGGER.info("Clearing moon end flags (instinct should be preserved)");
            data._isByCursedMoon = false;
            data._isByCursedMoonEnd = false;
            ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCursedMoon(false);
            RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        }
        data._isRegressedFromFinal = false;
        data._isByCure = false;
        ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setRegressedFromFinal(false);
        ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCure(false);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        ShapeShifterCurseFabric.LOGGER.info("\u6708\u4eae\u6807\u8bb0\u5df2\u6e05\u9664\uff0c\u539f\u72b6\u6001\uff1a" + wasByCursedMoon);
    }

    public static class PlayerTransformData {
        public int beginTransformEffectTicks = 0;
        public int endTransformEffectTicks = 0;
        public boolean isEffectActive = false;
        public boolean isEndEffectActive = false;
        public class_1657 curPlayer = null;
        public PlayerFormBase curFromForm = null;
        public PlayerFormBase curToForm = null;
        public boolean _isByCursedMoon = false;
        public boolean _isByCursedMoonEnd = false;
        public boolean _isRegressedFromFinal = false;
        public boolean _isByCure = false;
        public float nauesaStrength = 0.0f;
        public float blackStrength = 0.0f;
        public boolean isTransforming = false;
    }
}

