/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.status_effects.attachment;

import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.data.PlayerNbtStorage;
import net.onixary.shapeShifterCurseFabric.networking.ModPacketsS2CServer;
import net.onixary.shapeShifterCurseFabric.status_effects.BaseTransformativeStatusEffect;
import net.onixary.shapeShifterCurseFabric.status_effects.RegTStatusEffect;
import net.onixary.shapeShifterCurseFabric.status_effects.attachment.PlayerEffectAttachment;

public class EffectManager {
    public static final AttachmentType<PlayerEffectAttachment> EFFECT_ATTACHMENT = AttachmentRegistry.create((class_2960)new class_2960("shape-shifter-curse", "effect_data"));
    public static BaseTransformativeStatusEffect currentRegEffect;

    public static void overrideEffect(class_1657 player, BaseTransformativeStatusEffect regEffect) {
        ShapeShifterCurseFabric.LOGGER.info("get attach here");
        PlayerEffectAttachment attachment = (PlayerEffectAttachment)player.getAttached(EFFECT_ATTACHMENT);
        ShapeShifterCurseFabric.LOGGER.info("remove old effect here");
        if (attachment.currentEffect != null && attachment.currentEffect.getToForm() != regEffect.getToForm()) {
            attachment.currentEffect.onEffectCanceled(player);
        }
        ShapeShifterCurseFabric.LOGGER.info("apply new effect here");
        currentRegEffect = attachment.currentRegEffect = regEffect;
        attachment.currentToForm = regEffect.getToForm();
        attachment.remainingTicks = 8000;
        attachment.currentEffect = regEffect;
        ShapeShifterCurseFabric.LOGGER.info("apply potion effect here");
        player.method_6092(new class_1293((class_1291)regEffect, 8000));
        ShapeShifterCurseFabric.ON_GET_TRANSFORM_EFFECT.trigger((class_3222)player);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ModPacketsS2CServer.sendSyncEffectAttachment(serverPlayer, attachment);
        }
    }

    public static void loadEffect(class_1657 player, PlayerEffectAttachment loadedAttachment) {
        if (loadedAttachment.currentRegEffect != null) {
            player.method_6092(new class_1293((class_1291)loadedAttachment.currentRegEffect, loadedAttachment.remainingTicks));
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ModPacketsS2CServer.sendSyncEffectAttachment(serverPlayer, loadedAttachment);
        }
    }

    public static void applyEffect(class_1657 player) {
        PlayerEffectAttachment attachment = (PlayerEffectAttachment)player.getAttached(EFFECT_ATTACHMENT);
        ShapeShifterCurseFabric.LOGGER.info(attachment == null ? "attachment is null" : "attachment is not null");
        if (attachment != null && attachment.currentEffect != null) {
            attachment.currentRegEffect = null;
            currentRegEffect = null;
            attachment.currentEffect.onEffectApplied(player);
            attachment.currentToForm = null;
            attachment.remainingTicks = 0;
            attachment.currentEffect = null;
        }
    }

    public static void cancelEffect(class_1657 player) {
        PlayerEffectAttachment attachment = (PlayerEffectAttachment)player.getAttached(EFFECT_ATTACHMENT);
        ShapeShifterCurseFabric.LOGGER.info(attachment == null ? "attachment is null" : "attachment is not null");
        if (attachment != null && attachment.currentEffect != null) {
            attachment.currentRegEffect = null;
            currentRegEffect = null;
            attachment.currentEffect.onEffectCanceled(player);
            attachment.currentToForm = null;
            attachment.remainingTicks = 0;
            attachment.currentEffect = null;
        }
    }

    public static PlayerEffectAttachment getCurrentEffectAttachment(class_1657 player) {
        return (PlayerEffectAttachment)player.getAttached(EFFECT_ATTACHMENT);
    }

    public static boolean saveCurrentAttachment(class_3218 world, class_1657 player) {
        PlayerEffectAttachment attachment = (PlayerEffectAttachment)player.getAttached(EFFECT_ATTACHMENT);
        if (attachment != null) {
            PlayerNbtStorage.saveAttachment(world, player.method_5667().toString(), attachment);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ModPacketsS2CServer.sendSyncEffectAttachment(serverPlayer, attachment);
            }
            return true;
        }
        ShapeShifterCurseFabric.LOGGER.info("save attachment failed");
        return false;
    }

    public static boolean loadCurrentAttachment(class_3218 world, class_1657 player) {
        PlayerEffectAttachment attachment = PlayerNbtStorage.loadAttachment(world, player.method_5667().toString());
        player.setAttached(EFFECT_ATTACHMENT, (Object)attachment);
        if (attachment == null) {
            ShapeShifterCurseFabric.LOGGER.info("no attachment found in file");
            return false;
        }
        if (attachment.currentToForm != null) {
            ShapeShifterCurseFabric.LOGGER.info("load attachment success, currentToForm: " + String.valueOf(attachment.currentToForm));
            EffectManager.loadEffect(player, attachment);
            return true;
        }
        ShapeShifterCurseFabric.LOGGER.info("loaded attachment is empty, reset attachment");
        return false;
    }

    public static void resetAttachment(class_1657 player) {
        player.setAttached(EFFECT_ATTACHMENT, (Object)new PlayerEffectAttachment());
        RegTStatusEffect.removeVisualEffects(player);
    }
}

