/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.additional_power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;

public class AttractByEntityPower
extends Power {
    private final Predicate<class_1297> entityCondition;
    private final ActionFactory.Instance entityAction;
    private final ActionFactory.Instance selfAction;
    private final float attractionSpeed;
    private final float attractionRadius;
    private final float stopRadius;
    private final float escapeAttractionSpeed;
    private final float escapeAngleThreshold;
    private int tickCounter = 0;
    private class_1297 targetEntity;

    public AttractByEntityPower(PowerType<?> type, class_1309 entity, Predicate<class_1297> entityCondition, ActionFactory.Instance entityAction, ActionFactory.Instance selfAction, float attractionSpeed, float attractionRadius, float stopRadius, float escapeAttractionSpeed, float escapeAngleThreshold) {
        super(type, entity);
        this.entityCondition = entityCondition;
        this.entityAction = entityAction;
        this.selfAction = selfAction;
        this.attractionSpeed = attractionSpeed;
        this.attractionRadius = attractionRadius;
        this.stopRadius = stopRadius;
        this.escapeAttractionSpeed = escapeAttractionSpeed;
        this.escapeAngleThreshold = escapeAngleThreshold;
        this.setTicking(true);
    }

    public void tick() {
        class_1657 player;
        class_1309 class_13092 = this.entity;
        if (!(class_13092 instanceof class_1657) || (player = (class_1657)class_13092).method_7325()) {
            return;
        }
        if (this.tickCounter++ % 5 == 0) {
            class_238 searchBox = class_238.method_29968((class_243)player.method_19538()).method_1014((double)this.attractionRadius);
            List entities = player.method_37908().method_8333((class_1297)player, searchBox, e -> this.entityCondition.test((class_1297)e));
            this.targetEntity = entities.stream().filter(entity -> entity.method_5805() && !entity.method_7325()).min(Comparator.comparingDouble(e -> e.method_5858((class_1297)player))).orElse(null);
            if (this.targetEntity != null && player.method_5858(this.targetEntity) < (double)(this.stopRadius * this.stopRadius)) {
                this.targetEntity = null;
            }
            if (this.isPlayerInVehicle(player) || !player.method_24828()) {
                this.targetEntity = null;
                return;
            }
            if (this.targetEntity != null) {
                class_243 actorEyePos = this.entity.method_33571();
                class_243 targetEyePos = this.targetEntity.method_33571();
                class_3959 context = new class_3959(actorEyePos, targetEyePos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.entity);
                if (this.entity.method_37908().method_17742(context).method_17783() == class_239.class_240.field_1332) {
                    this.targetEntity = null;
                }
            }
        }
        if (this.targetEntity != null) {
            class_243 attractDirection = this.targetEntity.method_19538().method_1020(player.method_19538()).method_18805(1.0, 0.0, 1.0).method_1029();
            class_243 currentVelocity = player.method_18798();
            class_243 horizontalVelocity = new class_243(currentVelocity.field_1352, 0.0, currentVelocity.field_1350);
            class_243 playerFacing = player.method_5720().method_18805(1.0, 0.0, 1.0).method_1029();
            float effectiveSpeed = this.calculateEffectiveSpeed(attractDirection, horizontalVelocity, playerFacing);
            class_243 finalVelocity = attractDirection.method_1021((double)effectiveSpeed).method_1031(0.0, currentVelocity.field_1351, 0.0);
            player.method_18799(finalVelocity);
            player.field_6037 = true;
            if (this.entityAction != null) {
                this.entityAction.accept((Object)this.targetEntity);
            }
            if (this.selfAction != null) {
                this.selfAction.accept((Object)player);
            }
            PowerHolderComponent.syncPower((class_1297)this.entity, (PowerType)this.type);
        }
    }

    private boolean isPlayerInVehicle(class_1657 player) {
        class_1297 vehicle = player.method_5854();
        return vehicle != null && (vehicle instanceof class_1690 || vehicle instanceof class_1695 || vehicle.method_5864().method_35050().contains("vehicle") || vehicle.method_5864().method_35050().contains("mount"));
    }

    private float calculateEffectiveSpeed(class_243 attractDirection, class_243 playerVelocity, class_243 playerFacing) {
        class_243 faceDirection = playerFacing.method_1029();
        double dotProduct = faceDirection.method_1026(attractDirection);
        double angle = Math.acos(class_3532.method_15350((double)dotProduct, (double)-1.0, (double)1.0));
        if (dotProduct < 0.0) {
            return this.escapeAttractionSpeed;
        }
        return this.attractionSpeed;
    }

    public void onAdded() {
        super.onAdded();
        this.targetEntity = null;
    }

    public void onRemoved() {
        super.onRemoved();
        this.targetEntity = null;
    }

    public class_1297 getTargetEntity() {
        return this.targetEntity;
    }

    public static PowerFactory<?> getFactory() {
        return new PowerFactory(Apoli.identifier((String)"attract_by_entity"), new SerializableData().add("entity_condition", ApoliDataTypes.ENTITY_CONDITION, null).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("self_action", ApoliDataTypes.ENTITY_ACTION, null).add("attraction_speed", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.1f)).add("attraction_radius", SerializableDataTypes.FLOAT, (Object)Float.valueOf(8.0f)).add("stop_radius", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("escape_attraction_speed", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.025f)).add("escape_angle", SerializableDataTypes.FLOAT, (Object)Float.valueOf((float)Math.toRadians(80.0))), data -> (powerType, entity) -> new AttractByEntityPower((PowerType<?>)powerType, (class_1309)entity, (Predicate)data.get("entity_condition"), (ActionFactory.Instance)data.get("entity_action"), (ActionFactory.Instance)data.get("self_action"), data.getFloat("attraction_speed"), data.getFloat("attraction_radius"), data.getFloat("stop_radius"), data.getFloat("escape_attraction_speed"), data.getFloat("escape_angle"))).allowCondition();
    }
}

