/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.additional_power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.onixary.shapeShifterCurseFabric.additional_power.BatAttachEventHandler;
import net.onixary.shapeShifterCurseFabric.networking.ModPacketsS2CServer;

public class BatBlockAttachPower
extends Power {
    private final Predicate<class_2694> blockCondition;
    private final Consumer<class_1309> sideAttachAction;
    private final Consumer<class_1309> bottomAttachAction;
    private final int bottomAttachInterval;
    private boolean isAttached = false;
    private AttachType attachType = AttachType.NONE;
    private class_2338 attachedBlockPos = null;
    private class_2350 attachedSide = null;
    private int bottomAttachTimer = 0;

    public BatBlockAttachPower(PowerType<?> type, class_1309 entity, Predicate<class_2694> blockCondition, Consumer<class_1309> sideAttachAction, Consumer<class_1309> bottomAttachAction, int bottomAttachInterval) {
        super(type, entity);
        this.blockCondition = blockCondition;
        this.sideAttachAction = sideAttachAction;
        this.bottomAttachAction = bottomAttachAction;
        this.bottomAttachInterval = bottomAttachInterval;
        this.setTicking(true);
        this.shouldTickWhenInactive();
    }

    public static void syncClientState(class_1657 player, boolean isAttached, int attachTypeOrdinal, class_2338 attachedPos, class_2350 attachedSide) {
        BatBlockAttachPower power = BatAttachEventHandler.getBatAttachPower(player);
        if (power != null) {
            power.isAttached = isAttached;
            power.attachType = AttachType.values()[attachTypeOrdinal];
            power.attachedBlockPos = attachedPos;
            power.attachedSide = attachedSide;
            power.bottomAttachTimer = 0;
            if (isAttached && attachedPos != null && attachedSide != null) {
                class_243 targetPos = power.attachType == AttachType.SIDE ? class_243.method_24953((class_2382)attachedPos).method_1019(class_243.method_24954((class_2382)attachedSide.method_10163()).method_1021(0.75)).method_1031(0.0, -0.5, 0.0) : class_243.method_24953((class_2382)attachedPos).method_1031(0.0, -1.5, 0.0);
                player.method_5814(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);
                player.method_18799(class_243.field_1353);
            }
        }
    }

    public void tick() {
        super.tick();
        class_1309 class_13092 = this.entity;
        if (!(class_13092 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_13092;
        if (!player.method_37908().method_8608()) {
            class_1937 world;
            class_2680 blockState;
            if (this.isAttached && this.attachedBlockPos != null && (blockState = (world = this.entity.method_37908()).method_8320(this.attachedBlockPos)).method_26215()) {
                this.detach(player, false);
                return;
            }
            if (this.isAttached && this.attachType == AttachType.BOTTOM && this.bottomAttachAction != null) {
                ++this.bottomAttachTimer;
                if (this.bottomAttachTimer >= this.bottomAttachInterval) {
                    this.bottomAttachAction.accept(this.entity);
                    this.bottomAttachTimer = 0;
                }
            }
        }
        if (this.isAttached) {
            this.maintainAttachPosition(player);
            if (this.attachType == AttachType.SIDE && this.attachedSide != null) {
                this.maintainFacingDirection(player);
            }
        }
    }

    public boolean tryAttach(class_1657 player, class_3965 hitResult) {
        if (this.isAttached || !player.method_6047().method_7960() || player.method_24828()) {
            return false;
        }
        class_2338 blockPos = hitResult.method_17777();
        if (this.blockCondition != null && !this.blockCondition.test(new class_2694((class_4538)this.entity.method_37908(), blockPos, true))) {
            return false;
        }
        class_2350 hitSide = hitResult.method_17780();
        boolean attached = false;
        if (hitSide == class_2350.field_11033) {
            this.attachToBottom(player, blockPos);
            attached = true;
        } else if (hitSide.method_10166().method_10179()) {
            this.attachToSide(player, blockPos, hitSide);
            attached = true;
        }
        if (attached && !player.method_37908().method_8608() && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            player.method_37908().method_8503().execute(() -> {
                ModPacketsS2CServer.sendBatAttachState(serverPlayer, this.isAttached, this.attachType.ordinal(), this.attachedBlockPos, this.attachedSide);
                ModPacketsS2CServer.broadcastBatAttachState(serverPlayer, this.isAttached, this.attachType.ordinal(), this.attachedBlockPos, this.attachedSide);
            });
        }
        return attached;
    }

    private void attachToSide(class_1657 player, class_2338 blockPos, class_2350 side) {
        this.isAttached = true;
        this.attachType = AttachType.SIDE;
        this.attachedBlockPos = blockPos;
        this.attachedSide = side;
        class_243 attachPos = class_243.method_24953((class_2382)blockPos).method_1019(class_243.method_24954((class_2382)side.method_10163()).method_1021(0.75)).method_1031(0.0, -0.5, 0.0);
        player.method_5814(attachPos.field_1352, attachPos.field_1351, attachPos.field_1350);
        player.method_18799(class_243.field_1353);
        player.method_24830(true);
        player.field_6007 = true;
        player.field_6037 = true;
    }

    private void attachToBottom(class_1657 player, class_2338 blockPos) {
        this.isAttached = true;
        this.attachType = AttachType.BOTTOM;
        this.attachedBlockPos = blockPos;
        this.attachedSide = class_2350.field_11033;
        this.bottomAttachTimer = 0;
        class_243 attachPos = class_243.method_24953((class_2382)blockPos).method_1031(0.0, -1.5, 0.0);
        player.method_5814(attachPos.field_1352, attachPos.field_1351, attachPos.field_1350);
        player.method_18799(class_243.field_1353);
        player.method_24830(true);
        player.field_6007 = true;
        player.field_6037 = true;
    }

    public void detach(class_1657 player, boolean isByJump) {
        if (!this.isAttached) {
            return;
        }
        if (this.attachType == AttachType.SIDE && this.sideAttachAction != null) {
            this.sideAttachAction.accept(this.entity);
        }
        this.isAttached = false;
        AttachType oldAttachType = this.attachType;
        this.attachType = AttachType.NONE;
        this.attachedBlockPos = null;
        this.attachedSide = null;
        this.bottomAttachTimer = 0;
        player.method_24830(false);
        player.method_18799(class_243.field_1353);
        player.method_5762(0.0, 0.2, 0.0);
        if (isByJump) {
            float yaw = player.method_36454();
            double yawRadians = Math.toRadians(yaw);
            double dirX = -Math.sin(yawRadians);
            double dirZ = Math.cos(yawRadians);
            double jumpSpeed = 1.25;
            player.method_5762(dirX * jumpSpeed, 0.0, dirZ * jumpSpeed);
        }
        player.field_6007 = true;
        player.field_6037 = true;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ModPacketsS2CServer.sendBatAttachState(serverPlayer, false, AttachType.NONE.ordinal(), null, null);
            ModPacketsS2CServer.broadcastBatAttachState(serverPlayer, false, AttachType.NONE.ordinal(), null, null);
        }
    }

    private void maintainAttachPosition(class_1657 player) {
        if (this.attachedBlockPos == null || this.attachedSide == null) {
            return;
        }
        class_243 targetPos = this.attachType == AttachType.SIDE ? class_243.method_24953((class_2382)this.attachedBlockPos).method_1019(class_243.method_24954((class_2382)this.attachedSide.method_10163())) : class_243.method_24953((class_2382)this.attachedBlockPos).method_1031(0.0, -1.5, 0.0);
        class_243 currentVelocity = player.method_18798();
        player.method_18800(0.0, 0.0, 0.0);
        player.method_5814(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);
        player.method_5844(player.method_36601(), new class_243(0.0, 0.0, 0.0));
        player.method_24830(true);
        player.field_6017 = 0.0f;
        player.field_5973 = 0.0f;
        player.field_5994 = 0.0f;
        player.field_28627 = 0.0f;
        player.field_6212 = 0.0f;
        player.field_6227 = 0.0f;
        player.field_6250 = 0.0f;
        player.field_6007 = true;
        player.field_6037 = true;
    }

    private void maintainFacingDirection(class_1657 player) {
        if (this.attachedSide == null) {
            return;
        }
        float targetYaw = this.getTargetYaw();
        player.method_5636(targetYaw);
        player.field_6220 = targetYaw;
    }

    public float getTargetYaw() {
        if (this.attachedSide == null) {
            return this.entity.method_36454();
        }
        return switch (this.attachedSide) {
            case class_2350.field_11043 -> 0.0f;
            case class_2350.field_11035 -> 180.0f;
            case class_2350.field_11039 -> -90.0f;
            case class_2350.field_11034 -> 90.0f;
            default -> this.entity.method_36454();
        };
    }

    public boolean isAttached() {
        return this.isAttached;
    }

    public AttachType getAttachType() {
        return this.attachType;
    }

    public class_2338 getAttachedBlockPos() {
        return this.attachedBlockPos;
    }

    public class_2350 getAttachedSide() {
        return this.attachedSide;
    }

    public void handleJump(class_1657 player) {
        if (this.isAttached) {
            this.detach(player, true);
        }
    }

    public void handleRightClick(class_1657 player) {
        if (this.isAttached) {
            this.detach(player, false);
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier((String)"bat_block_attach"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null).add("side_attach_action", ApoliDataTypes.ENTITY_ACTION, null).add("bottom_attach_action", ApoliDataTypes.ENTITY_ACTION, null).add("bottom_attach_interval", SerializableDataTypes.INT, (Object)20), data -> (type, entity) -> new BatBlockAttachPower((PowerType<?>)type, (class_1309)entity, (Predicate)data.get("block_condition"), (Consumer)data.get("side_attach_action"), (Consumer)data.get("bottom_attach_action"), data.getInt("bottom_attach_interval"))).allowCondition();
    }

    public static enum AttachType {
        NONE,
        SIDE,
        BOTTOM;

    }
}

