/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.additional_power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.AttributedEntityAttributeModifier;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;

public class DelayAttributePower
extends Power {
    private final int TargetDelay;
    private int NowDelay;
    private final List<AttributedEntityAttributeModifier> modifiers = new LinkedList<AttributedEntityAttributeModifier>();
    private final boolean updateHealth;
    private final int tickRate;
    private boolean IsModActive = false;

    public DelayAttributePower(PowerType<?> type, class_1309 entity, SerializableData.Instance data) {
        super(type, entity);
        this.tickRate = data.getInt("tick_rate");
        this.updateHealth = data.getBoolean("updateHealth");
        this.NowDelay = this.TargetDelay = data.getInt("delay");
        if (data.isPresent("modifier")) {
            this.addModifier((AttributedEntityAttributeModifier)data.get("modifier"));
        }
        if (data.isPresent("modifiers")) {
            List modifierList = (List)data.get("modifiers");
            modifierList.forEach(this::addModifier);
        }
        this.setTicking(true);
    }

    public void tick() {
        if (this.entity.field_6012 % this.tickRate == 0) {
            if (this.isActive()) {
                if (!this.IsModActive) {
                    if (this.NowDelay >= this.TargetDelay) {
                        this.addMods();
                        this.NowDelay = 0;
                        return;
                    }
                    ++this.NowDelay;
                    return;
                }
                this.addMods();
            } else {
                if (this.IsModActive) {
                    if (this.NowDelay >= this.TargetDelay) {
                        this.removeMods();
                        this.NowDelay = 0;
                        return;
                    }
                    ++this.NowDelay;
                    return;
                }
                this.removeMods();
            }
            this.NowDelay = 0;
        }
    }

    public void onRemoved() {
        this.removeMods();
    }

    public void addMods() {
        this.IsModActive = true;
        float previousMaxHealth = this.entity.method_6063();
        float previousHealthPercent = this.entity.method_6032() / previousMaxHealth;
        this.modifiers.forEach(mod -> {
            class_1324 instance;
            if (this.entity.method_6127().method_27306(mod.getAttribute()) && (instance = this.entity.method_5996(mod.getAttribute())) != null && !instance.method_6196(mod.getModifier())) {
                instance.method_26835(mod.getModifier());
            }
        });
        float afterMaxHealth = this.entity.method_6063();
        if (this.updateHealth && afterMaxHealth != previousMaxHealth) {
            this.entity.method_6033(afterMaxHealth * previousHealthPercent);
        }
    }

    public void removeMods() {
        this.IsModActive = false;
        float previousMaxHealth = this.entity.method_6063();
        float previousHealthPercent = this.entity.method_6032() / previousMaxHealth;
        this.modifiers.forEach(mod -> {
            class_1324 instance;
            if (this.entity.method_6127().method_27306(mod.getAttribute()) && (instance = this.entity.method_5996(mod.getAttribute())) != null && instance.method_6196(mod.getModifier())) {
                instance.method_6202(mod.getModifier());
            }
        });
        float afterMaxHealth = this.entity.method_6063();
        if (this.updateHealth && afterMaxHealth != previousMaxHealth) {
            this.entity.method_6033(afterMaxHealth * previousHealthPercent);
        }
    }

    public DelayAttributePower addModifier(class_1320 attribute, class_1322 modifier) {
        AttributedEntityAttributeModifier mod = new AttributedEntityAttributeModifier(attribute, modifier);
        this.modifiers.add(mod);
        return this;
    }

    public DelayAttributePower addModifier(AttributedEntityAttributeModifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    public static PowerFactory<?> createFactory() {
        return new PowerFactory(Apoli.identifier((String)"delay_attribute"), new SerializableData().add("tick_rate", SerializableDataTypes.INT, (Object)1).add("updateHealth", SerializableDataTypes.BOOLEAN, (Object)true).add("modifier", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIER, null).add("modifiers", ApoliDataTypes.ATTRIBUTED_ATTRIBUTE_MODIFIERS, null).add("delay", SerializableDataTypes.INT, (Object)0), data -> (powerType, livingEntity) -> new DelayAttributePower((PowerType<?>)powerType, (class_1309)livingEntity, (SerializableData.Instance)data)).allowCondition();
    }
}

