/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.additional_power;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;

public class SprintingStateTracker {
    private static final Map<UUID, Boolean> sprintingStates = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> hasTriggered = new HashMap<UUID, Boolean>();

    public static boolean wasSprintingLastTick(class_1657 player) {
        return sprintingStates.getOrDefault(player.method_5667(), false);
    }

    public static void updateSprintingState(class_1657 player, boolean isSprinting) {
        UUID uuid = player.method_5667();
        boolean wasSprintingBefore = sprintingStates.getOrDefault(uuid, false);
        sprintingStates.put(uuid, isSprinting);
        if (!wasSprintingBefore && isSprinting) {
            hasTriggered.put(uuid, false);
            ShapeShifterCurseFabric.LOGGER.debug("Player {} started sprinting, reset trigger flag", (Object)player.method_5477().getString());
        }
    }

    public static boolean canTrigger(class_1657 player) {
        return hasTriggered.getOrDefault(player.method_5667(), false) == false;
    }

    public static void setTriggered(class_1657 player) {
        hasTriggered.put(player.method_5667(), true);
        ShapeShifterCurseFabric.LOGGER.debug("Player {} trigger flag set to true", (Object)player.method_5477().getString());
    }

    public static void removePlayer(class_1657 player) {
        UUID uuid = player.method_5667();
        sprintingStates.remove(uuid);
        hasTriggered.remove(uuid);
    }
}

