/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.additional_power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.class_1309;

public class TripleJumpPower
extends Power {
    private final ActionFactory.Instance firstJumpAction;
    private final ActionFactory.Instance secondJumpAction;
    private final ActionFactory.Instance thirdJumpAction;
    private final float firstJumpMultiplier;
    private final float secondJumpMultiplier;
    private final float thirdJumpMultiplier;
    private final int resetTicksOnGround;
    private int jumpCount = 0;
    private int ticksOnGround = 0;
    private float activeMultiplier = 1.0f;

    public TripleJumpPower(PowerType<?> type, class_1309 entity, ActionFactory.Instance firstJumpAction, ActionFactory.Instance secondJumpAction, ActionFactory.Instance thirdJumpAction, float firstJumpMultiplier, float secondJumpMultiplier, float thirdJumpMultiplier, int resetTicksOnGround) {
        super(type, entity);
        this.firstJumpAction = firstJumpAction;
        this.secondJumpAction = secondJumpAction;
        this.thirdJumpAction = thirdJumpAction;
        this.firstJumpMultiplier = firstJumpMultiplier;
        this.secondJumpMultiplier = secondJumpMultiplier;
        this.thirdJumpMultiplier = thirdJumpMultiplier;
        this.resetTicksOnGround = resetTicksOnGround;
        this.setTicking(true);
    }

    public void tick() {
        boolean shouldReset = false;
        if (!this.entity.method_5624()) {
            shouldReset = true;
        }
        if (this.entity.method_24828()) {
            ++this.ticksOnGround;
            if (this.ticksOnGround > this.resetTicksOnGround) {
                shouldReset = true;
            }
        } else {
            this.ticksOnGround = 0;
        }
        if (shouldReset) {
            this.jumpCount = 0;
        }
    }

    public void onJump() {
        if (!(this.isActive() && this.entity.method_24828() && this.entity.method_5624())) {
            this.activeMultiplier = 1.0f;
            return;
        }
        this.ticksOnGround = 0;
        ++this.jumpCount;
        ActionFactory.Instance action = null;
        switch (this.jumpCount) {
            case 1: {
                this.activeMultiplier = this.firstJumpMultiplier;
                action = this.firstJumpAction;
                break;
            }
            case 2: {
                this.activeMultiplier = this.secondJumpMultiplier;
                action = this.secondJumpAction;
                break;
            }
            case 3: {
                this.activeMultiplier = this.thirdJumpMultiplier;
                action = this.thirdJumpAction;
                this.jumpCount = 0;
                break;
            }
            default: {
                this.jumpCount = 0;
                this.activeMultiplier = 1.0f;
            }
        }
        if (action != null) {
            action.accept((Object)this.entity);
        }
    }

    public float getActiveJumpMultiplier() {
        return this.activeMultiplier;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier((String)"triple_jump"), new SerializableData().add("first_jump_action", ApoliDataTypes.ENTITY_ACTION, null).add("second_jump_action", ApoliDataTypes.ENTITY_ACTION, null).add("third_jump_action", ApoliDataTypes.ENTITY_ACTION, null).add("first_jump_multiplier", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("second_jump_multiplier", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.5f)).add("third_jump_multiplier", SerializableDataTypes.FLOAT, (Object)Float.valueOf(2.0f)).add("reset_ticks_on_ground", SerializableDataTypes.INT, (Object)10), data -> (type, entity) -> new TripleJumpPower((PowerType<?>)type, (class_1309)entity, (ActionFactory.Instance)data.get("first_jump_action"), (ActionFactory.Instance)data.get("second_jump_action"), (ActionFactory.Instance)data.get("third_jump_action"), data.getFloat("first_jump_multiplier"), data.getFloat("second_jump_multiplier"), data.getFloat("third_jump_multiplier"), data.getInt("reset_ticks_on_ground"))).allowCondition();
    }
}

