/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormBase;
import net.onixary.shapeShifterCurseFabric.player_form.RegPlayerForms;

public class PlayerDataStorage {
    private static final Gson GSON = new Gson();
    private static final String DATA_FILE_NAME = "player_data.json";
    private static final String MOD_DATA_DIR = "shape-shifter-curse";
    private static final Map<Path, JsonObject> cachedData = new ConcurrentHashMap<Path, JsonObject>();

    public static void initialize(MinecraftServer server) {
        PlayerDataStorage.getCachedData(server);
        ShapeShifterCurseFabric.LOGGER.info("PlayerDataStorage initialized for server.");
    }

    private static Path getNewSavePath(MinecraftServer server) {
        return server.method_27050(class_5218.field_24188).resolve("data").resolve(MOD_DATA_DIR).resolve(DATA_FILE_NAME);
    }

    private static Path getOldSavePath() {
        return Path.of("config", DATA_FILE_NAME);
    }

    private static void migrateData(MinecraftServer server) {
        Path oldPath = PlayerDataStorage.getOldSavePath();
        Path newPath = PlayerDataStorage.getNewSavePath(server);
        if (Files.exists(oldPath, new LinkOption[0]) && !Files.exists(newPath, new LinkOption[0])) {
            try {
                Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                Files.copy(oldPath, newPath, StandardCopyOption.REPLACE_EXISTING);
                ShapeShifterCurseFabric.LOGGER.info("Migrated global player data from '{}' to world-specific '{}'", (Object)oldPath, (Object)newPath);
            }
            catch (IOException e) {
                ShapeShifterCurseFabric.LOGGER.error("Failed to migrate player data.", (Throwable)e);
            }
        }
    }

    public static void savePlayerData(MinecraftServer server, String key, int value) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        data.addProperty(key, (Number)value);
        PlayerDataStorage.updateCache(server, data);
    }

    public static void savePlayerData(MinecraftServer server, String key, boolean value) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        data.addProperty(key, Boolean.valueOf(value));
        PlayerDataStorage.updateCache(server, data);
    }

    public static void savePlayerData(MinecraftServer server, String key, String value) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        data.addProperty(key, value);
        PlayerDataStorage.updateCache(server, data);
    }

    public static void savePlayerData(MinecraftServer server, String key, float value) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        data.addProperty(key, (Number)Float.valueOf(value));
        PlayerDataStorage.updateCache(server, data);
    }

    public static void savePlayerData(MinecraftServer server, String key, JsonObject value) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        data.add(key, (JsonElement)value);
        PlayerDataStorage.updateCache(server, data);
    }

    public static void savePlayerData(MinecraftServer server, String key, JsonArray value) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        data.add(key, (JsonElement)value);
        PlayerDataStorage.updateCache(server, data);
    }

    public static void savePlayerData(MinecraftServer server, String key, Enum<?> value) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        data.addProperty(key, value.name());
        PlayerDataStorage.updateCache(server, data);
    }

    public static void savePlayerForm(MinecraftServer server, String key, PlayerFormBase state) {
        PlayerDataStorage.savePlayerData(server, key, state.FormID.toString());
    }

    public static PlayerFormBase loadPlayerForm(MinecraftServer server, String key) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        return data.has(key) ? RegPlayerForms.getPlayerForm(data.get(key).getAsString()) : RegPlayerForms.ORIGINAL_SHIFTER;
    }

    public static int loadPlayerDataAsInt(MinecraftServer server, String key) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        return data.has(key) ? data.get(key).getAsInt() : 0;
    }

    public static boolean loadPlayerDataAsBoolean(MinecraftServer server, String key) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        return data.has(key) && data.get(key).getAsBoolean();
    }

    public static String loadPlayerDataAsString(MinecraftServer server, String key) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        return data.has(key) ? data.get(key).getAsString() : "";
    }

    public static JsonObject loadPlayerDataAsJsonObject(MinecraftServer server, String key) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        return data.has(key) ? data.get(key).getAsJsonObject() : new JsonObject();
    }

    public static JsonArray loadPlayerDataAsJsonArray(MinecraftServer server, String key) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        return data.has(key) ? data.get(key).getAsJsonArray() : new JsonArray();
    }

    public static <T extends Enum<T>> T loadPlayerDataAsEnum(MinecraftServer server, String key, Class<T> enumClass) {
        JsonObject data = PlayerDataStorage.getCachedData(server);
        return data.has(key) ? (T)Enum.valueOf(enumClass, data.get(key).getAsString()) : null;
    }

    private static JsonObject getCachedData(MinecraftServer server) {
        Path savePath = PlayerDataStorage.getNewSavePath(server);
        return cachedData.computeIfAbsent(savePath, path -> PlayerDataStorage.loadData(server));
    }

    private static JsonObject loadData(MinecraftServer server) {
        PlayerDataStorage.migrateData(server);
        Path dataFile = PlayerDataStorage.getNewSavePath(server);
        if (Files.exists(dataFile, new LinkOption[0])) {
            JsonObject jsonObject;
            FileReader reader = new FileReader(dataFile.toFile());
            try {
                JsonObject data = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                jsonObject = data != null ? data : new JsonObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return jsonObject;
        }
        return new JsonObject();
    }

    private static void updateCache(MinecraftServer server, JsonObject data) {
        Path savePath = PlayerDataStorage.getNewSavePath(server);
        cachedData.put(savePath, data);
        PlayerDataStorage.saveDataToFile(server, data);
    }

    private static void saveDataToFile(MinecraftServer server, JsonObject data) {
        Path dataFile = PlayerDataStorage.getNewSavePath(server);
        try {
            Files.createDirectories(dataFile.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(dataFile.toFile());){
                GSON.toJson((JsonElement)data, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

