/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.data;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.player_form.ability.FormAbilityManager;
import net.onixary.shapeShifterCurseFabric.player_form.ability.PlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.ability.RegPlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.PlayerInstinctComponent;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.RegPlayerInstinctComponent;
import net.onixary.shapeShifterCurseFabric.status_effects.attachment.EffectManager;
import net.onixary.shapeShifterCurseFabric.status_effects.attachment.PlayerEffectAttachment;

public class PlayerNbtStorage {
    private static final String MOD_DATA_DIR = "shape-shifter-curse";
    private static final Path OLD_SAVE_DIR_ROOT = Paths.get("config", "shape_shifter_curse_fabric");

    private static Path getNewWorldSaveDir(class_3218 world) {
        return world.method_8503().method_27050(class_5218.field_24188).resolve("data").resolve(MOD_DATA_DIR);
    }

    private static Path getOldWorldSaveDir(class_3218 world) {
        String worldName = world.method_8503().method_27050(class_5218.field_24188).getFileName().toString();
        return OLD_SAVE_DIR_ROOT.resolve(worldName);
    }

    private static void migrateData(class_3218 world, String fileName) {
        try {
            Path oldDir = PlayerNbtStorage.getOldWorldSaveDir(world);
            Path newDir = PlayerNbtStorage.getNewWorldSaveDir(world);
            Path oldFile = oldDir.resolve(fileName);
            Path newFile = newDir.resolve(fileName);
            ShapeShifterCurseFabric.LOGGER.info("Checking for migration: oldFile={}, newFile={}", (Object)oldFile, (Object)newFile);
            if (Files.exists(oldFile, new LinkOption[0]) && !Files.exists(newFile, new LinkOption[0])) {
                Files.createDirectories(newDir, new FileAttribute[0]);
                Files.copy(oldFile, newFile, StandardCopyOption.REPLACE_EXISTING);
                ShapeShifterCurseFabric.LOGGER.info("Migrated player data '{}' from old location to new location.", (Object)fileName);
                ShapeShifterCurseFabric.LOGGER.info("Migration completed: newFile exists = {}, size = {}", (Object)Files.exists(newFile, new LinkOption[0]), (Object)Files.size(newFile));
                Files.delete(oldFile);
            } else if (Files.exists(newFile, new LinkOption[0])) {
                ShapeShifterCurseFabric.LOGGER.info("New file already exists, skipping migration: {}", (Object)newFile);
            } else {
                ShapeShifterCurseFabric.LOGGER.info("No old file found for migration: {}", (Object)oldFile);
            }
        }
        catch (IOException e) {
            ShapeShifterCurseFabric.LOGGER.error("Failed to migrate player data file: " + fileName, (Throwable)e);
        }
    }

    public static void saveAttachment(class_3218 world, String playerId, PlayerEffectAttachment attachment) {
        try {
            Path worldSaveDir = PlayerNbtStorage.getNewWorldSaveDir(world);
            Files.createDirectories(worldSaveDir, new FileAttribute[0]);
            Path savePath = worldSaveDir.resolve(playerId + "_attachment.dat");
            class_2487 nbt = attachment.toNbt();
            class_2507.method_10630((class_2487)nbt, (File)savePath.toFile());
        }
        catch (IOException e) {
            ShapeShifterCurseFabric.LOGGER.error("Failed to save attachment for player: " + playerId, (Throwable)e);
        }
    }

    public static PlayerEffectAttachment loadAttachment(class_3218 world, String playerId) {
        String fileName = playerId + "_attachment.dat";
        PlayerNbtStorage.migrateData(world, fileName);
        try {
            Path savePath = PlayerNbtStorage.getNewWorldSaveDir(world).resolve(fileName);
            if (!Files.exists(savePath, new LinkOption[0])) {
                return null;
            }
            class_2487 nbt = class_2507.method_10633((File)savePath.toFile());
            if (nbt == null) {
                return null;
            }
            return PlayerEffectAttachment.fromNbt(nbt);
        }
        catch (IOException e) {
            ShapeShifterCurseFabric.LOGGER.error("Failed to load attachment for player: " + playerId, (Throwable)e);
            return null;
        }
    }

    public static void savePlayerFormComponent(class_3218 world, String playerId, PlayerFormComponent component) {
        try {
            Path worldSaveDir = PlayerNbtStorage.getNewWorldSaveDir(world);
            Files.createDirectories(worldSaveDir, new FileAttribute[0]);
            Path savePath = worldSaveDir.resolve(playerId + "_form.dat");
            class_2487 nbt = new class_2487();
            component.writeToNbt(nbt);
            class_2507.method_10630((class_2487)nbt, (File)savePath.toFile());
        }
        catch (IOException e) {
            ShapeShifterCurseFabric.LOGGER.error("Failed to save PlayerFormComponent for player: " + playerId, (Throwable)e);
        }
    }

    public static PlayerFormComponent loadPlayerFormComponent(class_3218 world, String playerId) {
        String fileName = playerId + "_form.dat";
        PlayerNbtStorage.migrateData(world, fileName);
        try {
            Path savePath = PlayerNbtStorage.getNewWorldSaveDir(world).resolve(fileName);
            ShapeShifterCurseFabric.LOGGER.info("Loading PlayerFormComponent: file exists = {}, path = {}", (Object)Files.exists(savePath, new LinkOption[0]), (Object)savePath);
            if (Files.exists(savePath, new LinkOption[0])) {
                class_2487 nbt = class_2507.method_10633((File)savePath.toFile());
                ShapeShifterCurseFabric.LOGGER.info("NBT loaded: nbt != null = {}, nbt.isEmpty() = {}", (Object)(nbt != null ? 1 : 0), nbt != null ? Boolean.valueOf(nbt.method_33133()) : "null");
                if (nbt != null && !nbt.method_33133()) {
                    PlayerFormComponent component = new PlayerFormComponent();
                    component.readFromNbt(nbt);
                    ShapeShifterCurseFabric.LOGGER.info("PlayerFormComponent loaded successfully");
                    return component;
                }
            }
        }
        catch (IOException e) {
            ShapeShifterCurseFabric.LOGGER.error("Failed to load PlayerFormComponent for player: " + playerId, (Throwable)e);
        }
        ShapeShifterCurseFabric.LOGGER.info("PlayerFormComponent load failed, returning null");
        return null;
    }

    public static void savePlayerInstinctComponent(class_3218 world, String playerId, PlayerInstinctComponent component) {
        try {
            Path worldSaveDir = PlayerNbtStorage.getNewWorldSaveDir(world);
            Files.createDirectories(worldSaveDir, new FileAttribute[0]);
            Path savePath = worldSaveDir.resolve(playerId + "_instinct.dat");
            class_2487 nbt = new class_2487();
            component.writeToNbt(nbt);
            class_2507.method_10630((class_2487)nbt, (File)savePath.toFile());
        }
        catch (IOException e) {
            ShapeShifterCurseFabric.LOGGER.error("Failed to save PlayerInstinctComponent for player: " + playerId, (Throwable)e);
        }
    }

    public static PlayerInstinctComponent loadPlayerInstinctComponent(class_3218 world, String playerId) {
        String fileName = playerId + "_instinct.dat";
        PlayerNbtStorage.migrateData(world, fileName);
        try {
            Path savePath = PlayerNbtStorage.getNewWorldSaveDir(world).resolve(fileName);
            ShapeShifterCurseFabric.LOGGER.info("Loading PlayerInstinctComponent: file exists = {}, path = {}", (Object)Files.exists(savePath, new LinkOption[0]), (Object)savePath);
            if (Files.exists(savePath, new LinkOption[0])) {
                class_2487 nbt = class_2507.method_10633((File)savePath.toFile());
                ShapeShifterCurseFabric.LOGGER.info("NBT loaded: nbt != null = {}, nbt.isEmpty() = {}", (Object)(nbt != null ? 1 : 0), nbt != null ? Boolean.valueOf(nbt.method_33133()) : "null");
                if (nbt != null && !nbt.method_33133()) {
                    PlayerInstinctComponent component = new PlayerInstinctComponent();
                    component.readFromNbt(nbt);
                    ShapeShifterCurseFabric.LOGGER.info("PlayerInstinctComponent loaded successfully");
                    return component;
                }
            }
        }
        catch (IOException e) {
            ShapeShifterCurseFabric.LOGGER.error("Failed to load PlayerInstinctComponent for player: " + playerId, (Throwable)e);
        }
        ShapeShifterCurseFabric.LOGGER.info("PlayerInstinctComponent load failed, returning null");
        return null;
    }

    public static void saveAll(class_3218 world, class_3222 player) {
        FormAbilityManager.saveForm((class_1657)player);
        PlayerNbtStorage.savePlayerFormComponent(world, player.method_5667().toString(), (PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player));
        PlayerEffectAttachment attachment = (PlayerEffectAttachment)player.getAttached(EffectManager.EFFECT_ATTACHMENT);
        if (attachment != null) {
            PlayerNbtStorage.saveAttachment(world, player.method_5667().toString(), attachment);
        }
        PlayerInstinctComponent comp = (PlayerInstinctComponent)player.getComponent(RegPlayerInstinctComponent.PLAYER_INSTINCT_COMP);
        PlayerNbtStorage.savePlayerInstinctComponent(world, player.method_5667().toString(), comp);
    }
}

