/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.form_giving_custom_entity.axolotl;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4592;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5762;
import net.minecraft.class_630;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class AxolotlEntityModel<T extends class_5762>
extends class_4592<T> {
    public static final float MOVING_IN_WATER_LEG_PITCH = 1.8849558f;
    private final class_630 tail;
    private final class_630 leftHindLeg;
    private final class_630 rightHindLeg;
    private final class_630 leftFrontLeg;
    private final class_630 rightFrontLeg;
    private final class_630 body;
    private final class_630 head;
    private final class_630 topGills;
    private final class_630 leftGills;
    private final class_630 rightGills;

    public AxolotlEntityModel(class_630 root) {
        super(true, 8.0f, 3.35f);
        this.body = root.method_32086("body");
        this.head = this.body.method_32086("head");
        this.rightHindLeg = this.body.method_32086("right_hind_leg");
        this.leftHindLeg = this.body.method_32086("left_hind_leg");
        this.rightFrontLeg = this.body.method_32086("right_front_leg");
        this.leftFrontLeg = this.body.method_32086("left_front_leg");
        this.tail = this.body.method_32086("tail");
        this.topGills = this.head.method_32086("top_gills");
        this.leftGills = this.head.method_32086("left_gills");
        this.rightGills = this.head.method_32086("right_gills");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 modelPartData2 = modelPartData.method_32117("body", class_5606.method_32108().method_32101(0, 11).method_32097(-4.0f, -2.0f, -9.0f, 8.0f, 4.0f, 10.0f).method_32101(2, 17).method_32097(0.0f, -3.0f, -8.0f, 0.0f, 5.0f, 9.0f), class_5603.method_32090((float)0.0f, (float)20.0f, (float)5.0f));
        class_5605 dilation = new class_5605(0.001f);
        class_5610 modelPartData3 = modelPartData2.method_32117("head", class_5606.method_32108().method_32101(0, 1).method_32098(-4.0f, -3.0f, -5.0f, 8.0f, 5.0f, 5.0f, dilation), class_5603.method_32090((float)0.0f, (float)0.0f, (float)-9.0f));
        class_5606 modelPartBuilder = class_5606.method_32108().method_32101(3, 37).method_32098(-4.0f, -3.0f, 0.0f, 8.0f, 3.0f, 0.0f, dilation);
        class_5606 modelPartBuilder2 = class_5606.method_32108().method_32101(0, 40).method_32098(-3.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, dilation);
        class_5606 modelPartBuilder3 = class_5606.method_32108().method_32101(11, 40).method_32098(0.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, dilation);
        modelPartData3.method_32117("top_gills", modelPartBuilder, class_5603.method_32090((float)0.0f, (float)-3.0f, (float)-1.0f));
        modelPartData3.method_32117("left_gills", modelPartBuilder2, class_5603.method_32090((float)-4.0f, (float)0.0f, (float)-1.0f));
        modelPartData3.method_32117("right_gills", modelPartBuilder3, class_5603.method_32090((float)4.0f, (float)0.0f, (float)-1.0f));
        class_5606 modelPartBuilder4 = class_5606.method_32108().method_32101(2, 13).method_32098(-1.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, dilation);
        class_5606 modelPartBuilder5 = class_5606.method_32108().method_32101(2, 13).method_32098(-2.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, dilation);
        modelPartData2.method_32117("right_hind_leg", modelPartBuilder5, class_5603.method_32090((float)-3.5f, (float)1.0f, (float)-1.0f));
        modelPartData2.method_32117("left_hind_leg", modelPartBuilder4, class_5603.method_32090((float)3.5f, (float)1.0f, (float)-1.0f));
        modelPartData2.method_32117("right_front_leg", modelPartBuilder5, class_5603.method_32090((float)-3.5f, (float)1.0f, (float)-8.0f));
        modelPartData2.method_32117("left_front_leg", modelPartBuilder4, class_5603.method_32090((float)3.5f, (float)1.0f, (float)-8.0f));
        modelPartData2.method_32117("tail", class_5606.method_32108().method_32101(2, 19).method_32097(0.0f, -3.0f, 0.0f, 0.0f, 5.0f, 12.0f), class_5603.method_32090((float)0.0f, (float)0.0f, (float)1.0f));
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)64);
    }

    protected Iterable<class_630> method_22946() {
        return ImmutableList.of();
    }

    protected Iterable<class_630> method_22948() {
        return ImmutableList.of((Object)this.body);
    }

    public void setAngles(T axolotlEntity, float f, float g, float h, float i, float j) {
        this.resetAngles(axolotlEntity, i, j);
        if (axolotlEntity.method_33226()) {
            this.setPlayingDeadAngles(i);
            this.updateAnglesCache(axolotlEntity);
        } else {
            boolean bl;
            boolean bl2 = bl = g > 1.0E-5f || axolotlEntity.method_36455() != ((class_5762)axolotlEntity).field_6004 || axolotlEntity.method_36454() != ((class_5762)axolotlEntity).field_5982;
            if (axolotlEntity.method_5816()) {
                if (bl) {
                    this.setMovingInWaterAngles(h, j);
                } else {
                    this.setStandingInWaterAngles(h);
                }
                this.updateAnglesCache(axolotlEntity);
            } else {
                if (axolotlEntity.method_24828()) {
                    if (bl) {
                        this.setMovingOnGroundAngles(h, i);
                    } else {
                        this.setStandingOnGroundAngles(h, i);
                    }
                }
                this.updateAnglesCache(axolotlEntity);
            }
        }
    }

    private void updateAnglesCache(T axolotl) {
        Map map = axolotl.method_36976();
        map.put("body", this.getAngles(this.body));
        map.put("head", this.getAngles(this.head));
        map.put("right_hind_leg", this.getAngles(this.rightHindLeg));
        map.put("left_hind_leg", this.getAngles(this.leftHindLeg));
        map.put("right_front_leg", this.getAngles(this.rightFrontLeg));
        map.put("left_front_leg", this.getAngles(this.leftFrontLeg));
        map.put("tail", this.getAngles(this.tail));
        map.put("top_gills", this.getAngles(this.topGills));
        map.put("left_gills", this.getAngles(this.leftGills));
        map.put("right_gills", this.getAngles(this.rightGills));
    }

    private Vector3f getAngles(class_630 part) {
        return new Vector3f(part.field_3654, part.field_3675, part.field_3674);
    }

    private void setAngles(class_630 part, Vector3f angles) {
        part.method_33425(angles.x(), angles.y(), angles.z());
    }

    private void resetAngles(T axolotl, float headYaw, float headPitch) {
        this.body.field_3657 = 0.0f;
        this.head.field_3656 = 0.0f;
        this.body.field_3656 = 20.0f;
        Map map = axolotl.method_36976();
        if (map.isEmpty()) {
            this.body.method_33425(headPitch * ((float)Math.PI / 180), headYaw * ((float)Math.PI / 180), 0.0f);
            this.head.method_33425(0.0f, 0.0f, 0.0f);
            this.leftHindLeg.method_33425(0.0f, 0.0f, 0.0f);
            this.rightHindLeg.method_33425(0.0f, 0.0f, 0.0f);
            this.leftFrontLeg.method_33425(0.0f, 0.0f, 0.0f);
            this.rightFrontLeg.method_33425(0.0f, 0.0f, 0.0f);
            this.leftGills.method_33425(0.0f, 0.0f, 0.0f);
            this.rightGills.method_33425(0.0f, 0.0f, 0.0f);
            this.topGills.method_33425(0.0f, 0.0f, 0.0f);
            this.tail.method_33425(0.0f, 0.0f, 0.0f);
        } else {
            this.setAngles(this.body, (Vector3f)map.get("body"));
            this.setAngles(this.head, (Vector3f)map.get("head"));
            this.setAngles(this.leftHindLeg, (Vector3f)map.get("left_hind_leg"));
            this.setAngles(this.rightHindLeg, (Vector3f)map.get("right_hind_leg"));
            this.setAngles(this.leftFrontLeg, (Vector3f)map.get("left_front_leg"));
            this.setAngles(this.rightFrontLeg, (Vector3f)map.get("right_front_leg"));
            this.setAngles(this.leftGills, (Vector3f)map.get("left_gills"));
            this.setAngles(this.rightGills, (Vector3f)map.get("right_gills"));
            this.setAngles(this.topGills, (Vector3f)map.get("top_gills"));
            this.setAngles(this.tail, (Vector3f)map.get("tail"));
        }
    }

    private float lerpAngleDegrees(float start, float end) {
        return this.lerpAngleDegrees(0.05f, start, end);
    }

    private float lerpAngleDegrees(float delta, float start, float end) {
        return class_3532.method_17821((float)delta, (float)start, (float)end);
    }

    private void setAngles(class_630 part, float pitch, float yaw, float roll) {
        part.method_33425(this.lerpAngleDegrees(part.field_3654, pitch), this.lerpAngleDegrees(part.field_3675, yaw), this.lerpAngleDegrees(part.field_3674, roll));
    }

    private void setStandingOnGroundAngles(float animationProgress, float headYaw) {
        float f = animationProgress * 0.09f;
        float g = class_3532.method_15374((float)f);
        float h = class_3532.method_15362((float)f);
        float i = g * g - 2.0f * g;
        float j = h * h - 3.0f * g;
        this.head.field_3654 = this.lerpAngleDegrees(this.head.field_3654, -0.09f * i);
        this.head.field_3675 = this.lerpAngleDegrees(this.head.field_3675, 0.0f);
        this.head.field_3674 = this.lerpAngleDegrees(this.head.field_3674, -0.2f);
        this.tail.field_3675 = this.lerpAngleDegrees(this.tail.field_3675, -0.1f + 0.1f * i);
        this.topGills.field_3654 = this.lerpAngleDegrees(this.topGills.field_3654, 0.6f + 0.05f * j);
        this.leftGills.field_3675 = this.lerpAngleDegrees(this.leftGills.field_3675, -this.topGills.field_3654);
        this.rightGills.field_3675 = this.lerpAngleDegrees(this.rightGills.field_3675, -this.leftGills.field_3675);
        this.setAngles(this.leftHindLeg, 1.1f, 1.0f, 0.0f);
        this.setAngles(this.leftFrontLeg, 0.8f, 2.3f, -0.5f);
        this.copyLegAngles();
        this.body.field_3654 = this.lerpAngleDegrees(0.2f, this.body.field_3654, 0.0f);
        this.body.field_3675 = this.lerpAngleDegrees(this.body.field_3675, headYaw * ((float)Math.PI / 180));
        this.body.field_3674 = this.lerpAngleDegrees(this.body.field_3674, 0.0f);
    }

    private void setMovingOnGroundAngles(float animationProgress, float headYaw) {
        float f = animationProgress * 0.11f;
        float g = class_3532.method_15362((float)f);
        float h = (g * g - 2.0f * g) / 5.0f;
        float i = 0.7f * g;
        this.head.field_3654 = this.lerpAngleDegrees(this.head.field_3654, 0.0f);
        this.head.field_3675 = this.lerpAngleDegrees(this.head.field_3675, 0.09f * g);
        this.head.field_3674 = this.lerpAngleDegrees(this.head.field_3674, 0.0f);
        this.tail.field_3675 = this.lerpAngleDegrees(this.tail.field_3675, this.head.field_3675);
        this.topGills.field_3654 = this.lerpAngleDegrees(this.topGills.field_3654, 0.6f - 0.08f * (g * g + 2.0f * class_3532.method_15374((float)f)));
        this.leftGills.field_3675 = this.lerpAngleDegrees(this.leftGills.field_3675, -this.topGills.field_3654);
        this.rightGills.field_3675 = this.lerpAngleDegrees(this.rightGills.field_3675, -this.leftGills.field_3675);
        this.setAngles(this.leftHindLeg, 0.9424779f, 1.5f - h, -0.1f);
        this.setAngles(this.leftFrontLeg, 1.0995574f, 1.5707964f - i, 0.0f);
        this.setAngles(this.rightHindLeg, this.leftHindLeg.field_3654, -1.0f - h, 0.0f);
        this.setAngles(this.rightFrontLeg, this.leftFrontLeg.field_3654, -1.5707964f - i, 0.0f);
        this.body.field_3654 = this.lerpAngleDegrees(0.2f, this.body.field_3654, 0.0f);
        this.body.field_3675 = this.lerpAngleDegrees(this.body.field_3675, headYaw * ((float)Math.PI / 180));
        this.body.field_3674 = this.lerpAngleDegrees(this.body.field_3674, 0.0f);
    }

    private void setStandingInWaterAngles(float animationProgress) {
        float f = animationProgress * 0.075f;
        float g = class_3532.method_15362((float)f);
        float h = class_3532.method_15374((float)f) * 0.15f;
        this.body.field_3654 = this.lerpAngleDegrees(this.body.field_3654, -0.15f + 0.075f * g);
        this.body.field_3656 -= h;
        this.head.field_3654 = this.lerpAngleDegrees(this.head.field_3654, -this.body.field_3654);
        this.topGills.field_3654 = this.lerpAngleDegrees(this.topGills.field_3654, 0.2f * g);
        this.leftGills.field_3675 = this.lerpAngleDegrees(this.leftGills.field_3675, -0.3f * g - 0.19f);
        this.rightGills.field_3675 = this.lerpAngleDegrees(this.rightGills.field_3675, -this.leftGills.field_3675);
        this.setAngles(this.leftHindLeg, 2.3561945f - g * 0.11f, 0.47123894f, 1.7278761f);
        this.setAngles(this.leftFrontLeg, 0.7853982f - g * 0.2f, 2.042035f, 0.0f);
        this.copyLegAngles();
        this.tail.field_3675 = this.lerpAngleDegrees(this.tail.field_3675, 0.5f * g);
        this.head.field_3675 = this.lerpAngleDegrees(this.head.field_3675, 0.0f);
        this.head.field_3674 = this.lerpAngleDegrees(this.head.field_3674, 0.0f);
    }

    private void setMovingInWaterAngles(float animationProgress, float headPitch) {
        float f = animationProgress * 0.33f;
        float g = class_3532.method_15374((float)f);
        float h = class_3532.method_15362((float)f);
        float i = 0.13f * g;
        this.body.field_3654 = this.lerpAngleDegrees(0.1f, this.body.field_3654, headPitch * ((float)Math.PI / 180) + i);
        this.head.field_3654 = -i * 1.8f;
        this.body.field_3656 -= 0.45f * h;
        this.topGills.field_3654 = this.lerpAngleDegrees(this.topGills.field_3654, -0.5f * g - 0.8f);
        this.leftGills.field_3675 = this.lerpAngleDegrees(this.leftGills.field_3675, 0.3f * g + 0.9f);
        this.rightGills.field_3675 = this.lerpAngleDegrees(this.rightGills.field_3675, -this.leftGills.field_3675);
        this.tail.field_3675 = this.lerpAngleDegrees(this.tail.field_3675, 0.3f * class_3532.method_15362((float)(f * 0.9f)));
        this.setAngles(this.leftHindLeg, 1.8849558f, -0.4f * g, 1.5707964f);
        this.setAngles(this.leftFrontLeg, 1.8849558f, -0.2f * h - 0.1f, 1.5707964f);
        this.copyLegAngles();
        this.head.field_3675 = this.lerpAngleDegrees(this.head.field_3675, 0.0f);
        this.head.field_3674 = this.lerpAngleDegrees(this.head.field_3674, 0.0f);
    }

    private void setPlayingDeadAngles(float headYaw) {
        this.setAngles(this.leftHindLeg, 1.4137167f, 1.0995574f, 0.7853982f);
        this.setAngles(this.leftFrontLeg, 0.7853982f, 2.042035f, 0.0f);
        this.body.field_3654 = this.lerpAngleDegrees(this.body.field_3654, -0.15f);
        this.body.field_3674 = this.lerpAngleDegrees(this.body.field_3674, 0.35f);
        this.copyLegAngles();
        this.body.field_3675 = this.lerpAngleDegrees(this.body.field_3675, headYaw * ((float)Math.PI / 180));
        this.head.field_3654 = this.lerpAngleDegrees(this.head.field_3654, 0.0f);
        this.head.field_3675 = this.lerpAngleDegrees(this.head.field_3675, 0.0f);
        this.head.field_3674 = this.lerpAngleDegrees(this.head.field_3674, 0.0f);
        this.tail.field_3675 = this.lerpAngleDegrees(this.tail.field_3675, 0.0f);
        this.setAngles(this.topGills, 0.0f, 0.0f, 0.0f);
        this.setAngles(this.leftGills, 0.0f, 0.0f, 0.0f);
        this.setAngles(this.rightGills, 0.0f, 0.0f, 0.0f);
    }

    private void copyLegAngles() {
        this.setAngles(this.rightHindLeg, this.leftHindLeg.field_3654, -this.leftHindLeg.field_3675, -this.leftHindLeg.field_3674);
        this.setAngles(this.rightFrontLeg, this.leftFrontLeg.field_3654, -this.leftFrontLeg.field_3675, -this.leftFrontLeg.field_3674);
    }
}

