/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.integration.origins.util;

import com.google.common.collect.ImmutableList;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.MultiplePowerType;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import java.util.HashMap;
import net.minecraft.class_2960;

public class PowerKeyManager {
    private static final HashMap<class_2960, String> KEY_CACHE = new HashMap();

    public static void clearCache() {
        KEY_CACHE.clear();
    }

    public static String getKeyIdentifier(class_2960 powerId) {
        if (KEY_CACHE.containsKey(powerId)) {
            return KEY_CACHE.get(powerId);
        }
        String key = PowerKeyManager.getKeyFromPower(powerId);
        KEY_CACHE.put(powerId, key);
        return key;
    }

    private static String getKeyFromPower(class_2960 powerId) {
        if (PowerTypeRegistry.contains((class_2960)powerId)) {
            PowerType powerType = PowerTypeRegistry.get((class_2960)powerId);
            Power power = powerType.create(null);
            String key = "";
            if (power instanceof Active) {
                key = ((Active)power).getKey().key;
            } else if (powerType instanceof MultiplePowerType) {
                ImmutableList subs = ((MultiplePowerType)powerType).getSubPowers();
                for (class_2960 sub : subs) {
                    String subKey = PowerKeyManager.getKeyFromPower(sub);
                    if (subKey.isEmpty()) continue;
                    return subKey;
                }
            }
            return key.equals("none") ? "key.origins.primary_active" : key;
        }
        return "";
    }
}

