/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.networking;

import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.additional_power.BatBlockAttachPower;
import net.onixary.shapeShifterCurseFabric.client.ClientPlayerStateManager;
import net.onixary.shapeShifterCurseFabric.client.ShapeShifterCurseFabricClient;
import net.onixary.shapeShifterCurseFabric.cursed_moon.CursedMoon;
import net.onixary.shapeShifterCurseFabric.networking.ClientEffectAttachmentCache;
import net.onixary.shapeShifterCurseFabric.networking.ModPackets;
import net.onixary.shapeShifterCurseFabric.player_form.transform.TransformManager;

public class ModPacketsS2C {
    public static void register() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.TRANSFORM_EFFECT_ID, ModPacketsS2C::receiveTransformEffect);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.INSTINCT_THRESHOLD_EFFECT_ID, ModPacketsS2C::receiveInstinctThresholdEffect);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.SYNC_CURSED_MOON_DATA, ModPacketsS2C::receiveCursedMoonData);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.SYNC_FORM_CHANGE, ModPacketsS2C::receiveFormChange);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.SYNC_TRANSFORM_STATE, ModPacketsS2C::receiveTransformState);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.SYNC_BAT_ATTACH_STATE, ModPacketsS2C::receiveBatAttachState);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.SYNC_EFFECT_ATTACHMENT, ModPacketsS2C::handleSyncEffectAttachment);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.UPDATE_OVERLAY_EFFECT, ModPacketsS2C::receiveUpdateOverlayEffect);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.UPDATE_OVERLAY_FADE_EFFECT, ModPacketsS2C::receiveUpdateOverlayFadeEffect);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.TRANSFORM_COMPLETE_EFFECT, ModPacketsS2C::receiveTransformCompleteEffect);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.RESET_FIRST_PERSON, ModPacketsS2C::receiveResetFirstPerson);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.SYNC_OTHER_PLAYER_BAT_ATTACH_STATE, ModPacketsS2C::receiveOtherPlayerBatAttachState);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.SYNC_FORCE_SNEAK_STATE, ModPacketsS2C::receiveForceSneakState);
    }

    public static void handleSyncEffectAttachment(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        class_2487 nbt = buf.method_10798();
        client.execute(() -> ClientEffectAttachmentCache.update(nbt));
    }

    public static void receiveTransformEffect(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        client.execute(() -> TransformManager.playClientTransformEffect());
    }

    public static void receiveInstinctThresholdEffect(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        client.execute(() -> ShapeShifterCurseFabricClient.applyInstinctThresholdEffect());
    }

    public static void receiveCursedMoonData(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        long dayTime = buf.readLong();
        int day = buf.readInt();
        boolean isCursedMoon = buf.readBoolean();
        boolean isNight = buf.readBoolean();
        client.execute(() -> {
            CursedMoon.day_time = dayTime;
            CursedMoon.day = day;
            CursedMoon.clientIsCursedMoon = isCursedMoon;
            CursedMoon.clientIsNight = isNight;
        });
    }

    public static void receiveFormChange(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        String newFormName = buf.method_19772();
        client.execute(() -> {
            if (client.field_1724 != null) {
                ShapeShifterCurseFabric.LOGGER.info("Client received form change: " + newFormName);
                ShapeShifterCurseFabricClient.refreshPlayerAnimations();
            }
        });
    }

    public static void receiveTransformState(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        boolean isTransforming = buf.readBoolean();
        String fromForm = buf.method_19772();
        String toForm = buf.method_19772();
        client.execute(() -> {
            if (client.field_1724 != null) {
                ShapeShifterCurseFabric.LOGGER.info("Client received transform state: isTransforming=" + isTransforming);
                ShapeShifterCurseFabricClient.updateTransformState(isTransforming, fromForm.isEmpty() ? null : fromForm, toForm.isEmpty() ? null : toForm);
            }
        });
    }

    public static void receiveUpdateOverlayEffect(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        float nauseaStrength = buf.readFloat();
        int ticks = buf.readInt();
        client.execute(() -> TransformManager.handleClientOverlayUpdate(nauseaStrength, ticks));
    }

    public static void receiveUpdateOverlayFadeEffect(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        float nauseaStrength = buf.readFloat();
        int ticks = buf.readInt();
        client.execute(() -> TransformManager.handleClientOverlayFadeUpdate(nauseaStrength, ticks));
    }

    public static void receiveTransformCompleteEffect(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        client.execute(TransformManager::executeClientTransformCompleteEffect);
    }

    public static void receiveResetFirstPerson(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        client.execute(TransformManager::executeClientFirstPersonReset);
    }

    public static void receiveBatAttachState(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        boolean isAttached = buf.readBoolean();
        int attachTypeOrdinal = buf.readInt();
        class_2338 attachedPos = buf.readBoolean() ? buf.method_10811() : null;
        class_2350 attachedSide = buf.readBoolean() ? class_2350.method_10143((int)buf.readInt()) : null;
        client.execute(() -> {
            if (client.field_1724 != null) {
                BatBlockAttachPower.syncClientState((class_1657)client.field_1724, isAttached, attachTypeOrdinal, attachedPos, attachedSide);
            }
        });
    }

    public static void receiveOtherPlayerBatAttachState(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        UUID targetPlayerUuid = buf.method_10790();
        boolean isAttached = buf.readBoolean();
        int attachType = buf.readInt();
        class_2338 attachedPos = buf.readBoolean() ? buf.method_10811() : null;
        class_2350 attachedSide = buf.readBoolean() ? class_2350.method_10143((int)buf.readInt()) : null;
        client.execute(() -> ClientPlayerStateManager.updatePlayerAttachState(targetPlayerUuid, isAttached, attachType, attachedPos, attachedSide));
    }

    private static void receiveForceSneakState(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        boolean shouldForce = buf.readBoolean();
        client.execute(() -> {
            ClientPlayerStateManager.shouldForceSneak = shouldForce;
        });
    }
}

