/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.player_form.ability;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.data.PlayerNbtStorage;
import net.onixary.shapeShifterCurseFabric.integration.origins.component.OriginComponent;
import net.onixary.shapeShifterCurseFabric.integration.origins.origin.Origin;
import net.onixary.shapeShifterCurseFabric.integration.origins.origin.OriginLayer;
import net.onixary.shapeShifterCurseFabric.integration.origins.origin.OriginLayers;
import net.onixary.shapeShifterCurseFabric.integration.origins.origin.OriginRegistry;
import net.onixary.shapeShifterCurseFabric.integration.origins.registry.ModComponents;
import net.onixary.shapeShifterCurseFabric.networking.ModPacketsS2CServer;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormBase;
import net.onixary.shapeShifterCurseFabric.player_form.RegPlayerForms;
import net.onixary.shapeShifterCurseFabric.player_form.ability.PlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.ability.RegPlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.status_effects.attachment.EffectManager;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleTypes;

public class FormAbilityManager {
    private static class_3218 world;

    public static PlayerFormBase getForm(class_1657 player) {
        PlayerFormComponent component = (PlayerFormComponent)player.getComponent(RegPlayerFormComponent.PLAYER_FORM);
        return component.getCurrentForm();
    }

    public static void getServerWorld(class_3218 world) {
        FormAbilityManager.world = world;
    }

    public static void applyForm(class_1657 player, PlayerFormBase newForm) {
        PlayerFormComponent component = (PlayerFormComponent)player.getComponent(RegPlayerFormComponent.PLAYER_FORM);
        PlayerFormBase oldForm = component.getCurrentForm();
        FormAbilityManager.clearFormEffects(player, oldForm);
        FormAbilityManager.applyFormOrigin(player, "origin", newForm.getFormOriginID());
        EffectManager.cancelEffect(player);
        component.setCurrentForm(newForm);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        FormAbilityManager.saveForm(player);
        if (!player.method_37908().method_8608() && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            try {
                ModPacketsS2CServer.sendFormChange(serverPlayer, newForm.name());
                ShapeShifterCurseFabric.LOGGER.info("Sent form change notification to client: " + newForm.name());
            }
            catch (Exception e) {
                ShapeShifterCurseFabric.LOGGER.error("Failed to send form change notification: ", (Throwable)e);
            }
        }
    }

    public static void loadForm(class_1657 player) {
        PlayerFormComponent component = (PlayerFormComponent)player.getComponent(RegPlayerFormComponent.PLAYER_FORM);
        PlayerFormBase savedForm = FormAbilityManager.loadSavedForm(player);
        if (savedForm != null) {
            FormAbilityManager.applyForm(player, savedForm);
        } else {
            FormAbilityManager.applyForm(player, RegPlayerForms.ORIGINAL_BEFORE_ENABLE);
        }
    }

    public static void saveForm(class_1657 player) {
        if (world == null && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            world = serverPlayer.method_51469();
        }
        if (world != null) {
            PlayerFormComponent component = (PlayerFormComponent)player.getComponent(RegPlayerFormComponent.PLAYER_FORM);
            PlayerNbtStorage.savePlayerFormComponent(world, player.method_5667().toString(), component);
        } else {
            ShapeShifterCurseFabric.LOGGER.warn("Cannot save form: world is null");
        }
    }

    private static PlayerFormBase loadSavedForm(class_1657 player) {
        PlayerFormComponent formComponent = PlayerNbtStorage.loadPlayerFormComponent(world, player.method_5667().toString());
        return formComponent != null ? formComponent.getCurrentForm() : null;
    }

    private static void clearFormEffects(class_1657 player, PlayerFormBase oldForm) {
        ScaleData scaleData = ScaleTypes.BASE.getScaleData((class_1297)player);
        scaleData.setScale(1.0f);
    }

    private static void applyScale(class_1657 player, float scale) {
        ScaleData scaleDataWidth = ScaleTypes.WIDTH.getScaleData((class_1297)player);
        ScaleData scaleDataHeight = ScaleTypes.HEIGHT.getScaleData((class_1297)player);
        scaleDataWidth.setScale(scale);
        scaleDataWidth.setPersistence(Boolean.valueOf(true));
        scaleDataHeight.setScale(scale);
        scaleDataHeight.setPersistence(Boolean.valueOf(true));
    }

    private static void applyFormOrigin(class_1657 playerEntity, String originLayerId, String originId) {
        Origin origin;
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)playerEntity);
        OriginLayer layer = OriginLayers.getLayer(class_2960.method_43902((String)"origins", (String)originLayerId));
        class_2960 id = class_2960.method_43902((String)"origins", (String)originId);
        if (layer != null && id != null && layer.contains(origin = OriginRegistry.get(id), playerEntity)) {
            component.setOrigin(layer, origin);
            component.sync();
            ShapeShifterCurseFabric.LOGGER.info("Set form origin " + originId + " for player " + String.valueOf(playerEntity.method_5477()));
        }
    }

    private static void applyPower(class_1657 player, class_2960 powerId) {
        PowerType powerType = PowerTypeRegistry.get((class_2960)powerId);
        if (powerType != null) {
            PowerHolderComponent powerHolder = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)player);
            powerHolder.addPower(powerType, powerId);
        }
    }
}

