/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.player_form.instinct;

import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.onixary.shapeShifterCurseFabric.data.PlayerNbtStorage;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.InstinctEffect;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.InstinctTicker;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.PlayerInstinctComponent;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.RegPlayerInstinctComponent;

public class InstinctManager {
    private static class_3218 world;

    public static void getServerWorld(class_3218 world) {
        InstinctManager.world = world;
    }

    public static void applyImmediateEffect(class_1657 player, InstinctEffect effect) {
        if (!effect.isSustained()) {
            PlayerInstinctComponent comp = (PlayerInstinctComponent)player.getComponent(RegPlayerInstinctComponent.PLAYER_INSTINCT_COMP);
            comp.immediateEffects.add(effect);
            RegPlayerInstinctComponent.PLAYER_INSTINCT_COMP.sync((Object)player);
        }
    }

    public static void applyImmediateEffect(class_1657 player, String effectID, float effectValue) {
        if (!effectID.isEmpty()) {
            InstinctEffect effect = new InstinctEffect(effectID, effectValue, 0, false);
            InstinctManager.applyImmediateEffect(player, effect);
        }
    }

    public static void applySustainedEffect(class_1657 player, InstinctEffect effect) {
        if (effect.isSustained()) {
            PlayerInstinctComponent comp = (PlayerInstinctComponent)player.getComponent(RegPlayerInstinctComponent.PLAYER_INSTINCT_COMP);
            comp.sustainedEffects.removeIf(e -> Objects.equals(e.ID, effect.ID));
            comp.sustainedEffects.add(effect);
            RegPlayerInstinctComponent.PLAYER_INSTINCT_COMP.sync((Object)player);
        }
    }

    public static void applySustainedEffect(class_1657 player, String effectID, float effectValue, int duration) {
        if (!effectID.isEmpty()) {
            InstinctEffect effect = new InstinctEffect(effectID, effectValue, duration, true);
            InstinctManager.applySustainedEffect(player, effect);
        }
    }

    public static void applyEffect(class_1657 player, String effectID, float effectValue, int duration) {
        if (duration == 0) {
            InstinctManager.applyImmediateEffect(player, effectID, effectValue);
        } else {
            InstinctManager.applySustainedEffect(player, effectID, effectValue, duration);
        }
    }

    public static void removeSustainedEffect(class_1657 player, InstinctEffect effect) {
        PlayerInstinctComponent comp = (PlayerInstinctComponent)player.getComponent(RegPlayerInstinctComponent.PLAYER_INSTINCT_COMP);
        comp.sustainedEffects.removeIf(e -> Objects.equals(e.ID, effect.ID));
        RegPlayerInstinctComponent.PLAYER_INSTINCT_COMP.sync((Object)player);
    }

    public static void saveInstinctComp(class_1657 player) {
        PlayerInstinctComponent comp = (PlayerInstinctComponent)player.getComponent(RegPlayerInstinctComponent.PLAYER_INSTINCT_COMP);
        comp.instinctValue = InstinctTicker.currentInstinctValue;
        PlayerNbtStorage.savePlayerInstinctComponent(world, player.method_5667().toString(), comp);
    }

    public static PlayerInstinctComponent loadInstinctComp(class_1657 player) {
        return PlayerNbtStorage.loadPlayerInstinctComponent(world, player.method_5667().toString());
    }
}

