/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.player_form.instinct;

import java.util.Iterator;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.onixary.shapeShifterCurseFabric.cursed_moon.CursedMoon;
import net.onixary.shapeShifterCurseFabric.networking.ModPackets;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormBase;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormPhase;
import net.onixary.shapeShifterCurseFabric.player_form.ability.FormAbilityManager;
import net.onixary.shapeShifterCurseFabric.player_form.ability.PlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.ability.RegPlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.InstinctEffect;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.InstinctManager;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.PlayerInstinctComponent;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.RegPlayerInstinctComponent;
import net.onixary.shapeShifterCurseFabric.player_form.transform.TransformManager;

public class InstinctTicker {
    public static float currentInstinctValue = 0.0f;
    public static boolean showInstinctBar = false;
    public static boolean isInstinctLock = false;
    public static boolean isUnderCursedMoon = false;
    public static boolean isPausing = false;

    public static void loadInstinct(class_1657 player) {
        PlayerInstinctComponent comp = InstinctManager.loadInstinctComp(player);
        if (comp != null) {
            PlayerInstinctComponent thisComp = (PlayerInstinctComponent)RegPlayerInstinctComponent.PLAYER_INSTINCT_COMP.get((Object)player);
            thisComp.instinctValue = comp.instinctValue;
            thisComp.immediateEffects = comp.immediateEffects;
            thisComp.sustainedEffects = comp.sustainedEffects;
            isPausing = false;
        }
    }

    public static void clearInstinct(class_1657 player) {
        PlayerInstinctComponent comp = (PlayerInstinctComponent)player.getComponent(RegPlayerInstinctComponent.PLAYER_INSTINCT_COMP);
        comp.instinctValue = 0.0f;
        comp.immediateEffects.clear();
        comp.sustainedEffects.clear();
        RegPlayerInstinctComponent.PLAYER_INSTINCT_COMP.sync((Object)player);
    }

    public static void tick(class_1657 player) {
        PlayerInstinctComponent comp = (PlayerInstinctComponent)player.getComponent(RegPlayerInstinctComponent.PLAYER_INSTINCT_COMP);
        isUnderCursedMoon = CursedMoon.isCursedMoon(player.method_37908()) && CursedMoon.isNight();
        InstinctTicker.processImmediateEffects(comp);
        comp.currentInstinctRate = isPausing || isUnderCursedMoon ? 0.0f : InstinctTicker.calculateCurrentRate(player, comp);
        comp.instinctValue = class_3532.method_15363((float)(comp.instinctValue + comp.currentInstinctRate), (float)0.0f, (float)100.0f);
        if (comp.instinctValue >= 80.0f && comp.instinctValue < 99.99f && !player.method_37908().field_9236 && player instanceof class_3222) {
            class_2540 buf = PacketByteBufs.create();
            ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)ModPackets.INSTINCT_THRESHOLD_EFFECT_ID, (class_2540)buf);
        }
        InstinctTicker.judgeInstinctState(player, comp);
        currentInstinctValue = comp.instinctValue;
        InstinctTicker.checkThreshold(player, comp);
        player.syncComponent(RegPlayerInstinctComponent.PLAYER_INSTINCT_COMP);
    }

    private static float judgeInstinctGrowRate(class_1657 player) {
        PlayerFormComponent formComp = (PlayerFormComponent)player.getComponent(RegPlayerFormComponent.PLAYER_FORM);
        PlayerFormPhase currentPhase = formComp.getCurrentForm().getPhase();
        switch (currentPhase) {
            case PHASE_CLEAR: {
                return 0.0f;
            }
            case PHASE_0: {
                return 5.5555557E-4f;
            }
            case PHASE_1: {
                return 5.5555557E-4f;
            }
            case PHASE_2: {
                return 100.0f;
            }
            case PHASE_3: {
                return 100.0f;
            }
            case PHASE_SP: {
                return 100.0f;
            }
        }
        return 0.0f;
    }

    private static void judgeInstinctState(class_1657 player, PlayerInstinctComponent comp) {
        PlayerFormBase form = FormAbilityManager.getForm(player);
        PlayerFormPhase currentPhase = form.getPhase();
        showInstinctBar = currentPhase != PlayerFormPhase.PHASE_CLEAR && currentPhase != PlayerFormPhase.PHASE_3;
        float baseRate = InstinctTicker.judgeInstinctGrowRate(player);
        if (comp.currentInstinctRate > baseRate) {
            comp.isInstinctIncreasing = true;
            comp.isInstinctDecreasing = false;
        } else if (comp.currentInstinctRate < baseRate) {
            comp.isInstinctIncreasing = false;
            comp.isInstinctDecreasing = true;
        } else {
            comp.isInstinctIncreasing = false;
            comp.isInstinctDecreasing = false;
        }
        isInstinctLock = FormAbilityManager.getForm((class_1657)player).FormIndex < 2 ? isUnderCursedMoon : true;
    }

    private static void processImmediateEffects(PlayerInstinctComponent comp) {
        while (!comp.immediateEffects.isEmpty()) {
            InstinctEffect effect = comp.immediateEffects.poll();
            comp.instinctValue = class_3532.method_15363((float)(comp.instinctValue + effect.getValue()), (float)0.0f, (float)100.0f);
        }
    }

    public static float calculateCurrentRate(class_1657 player, PlayerInstinctComponent comp) {
        float rate = InstinctTicker.judgeInstinctGrowRate(player);
        Iterator<InstinctEffect> iterator = comp.sustainedEffects.iterator();
        while (iterator.hasNext()) {
            InstinctEffect effect = iterator.next();
            if (effect.IsEffectExist()) {
                rate += effect.getRateModifier();
                continue;
            }
            iterator.remove();
        }
        return rate;
    }

    private static void checkThreshold(class_1657 player, PlayerInstinctComponent comp) {
        if (comp.instinctValue >= 100.0f) {
            if (FormAbilityManager.getForm((class_1657)player).FormIndex < 2) {
                TransformManager.handleProgressiveTransform(player, false);
            }
            comp.instinctValue = 0.0f;
        }
    }
}

