/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.player_form.transform;

import dev.tr7zw.firstperson.FirstPersonModelCore;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.client.ShapeShifterCurseFabricClient;
import net.onixary.shapeShifterCurseFabric.cursed_moon.CursedMoon;
import net.onixary.shapeShifterCurseFabric.networking.ModPackets;
import net.onixary.shapeShifterCurseFabric.networking.ModPacketsS2CServer;
import net.onixary.shapeShifterCurseFabric.player_form.FormRandomSelector;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormBase;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormGroup;
import net.onixary.shapeShifterCurseFabric.player_form.RegPlayerForms;
import net.onixary.shapeShifterCurseFabric.player_form.ability.FormAbilityManager;
import net.onixary.shapeShifterCurseFabric.player_form.ability.PlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.ability.RegPlayerFormComponent;
import net.onixary.shapeShifterCurseFabric.player_form.effect.PlayerTransformEffectManager;
import net.onixary.shapeShifterCurseFabric.player_form.instinct.InstinctTicker;
import net.onixary.shapeShifterCurseFabric.screen_effect.TransformFX;
import net.onixary.shapeShifterCurseFabric.screen_effect.TransformOverlay;
import net.onixary.shapeShifterCurseFabric.status_effects.attachment.EffectManager;
import net.onixary.shapeShifterCurseFabric.status_effects.attachment.PlayerEffectAttachment;

public class TransformManager {
    private static int beginTransformEffectTicks = 0;
    private static int endTransformEffectTicks = 0;
    private static boolean isEffectActive = false;
    private static boolean isEndEffectActive = false;
    private static class_1657 curPlayer = null;
    public static PlayerFormBase curFromForm = null;
    public static PlayerFormBase curToForm = null;
    private static boolean _isByCursedMoon = false;
    private static boolean _isByCursedMoonEnd = false;
    private static boolean _isRegressedFromFinal = false;
    private static boolean _isByCure = false;
    private static float nauesaStrength = 0.0f;
    private static float blackStrength = 0.0f;
    private static boolean isTransforming = false;
    private static final boolean IS_FIRST_PERSON_MOD_LOADED = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && FabricLoader.getInstance().isModLoaded("firstperson");

    private TransformManager() {
    }

    public static boolean isTransforming() {
        return isTransforming;
    }

    private static void setTransformingState(boolean transforming, class_1657 player) {
        isTransforming = transforming;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            String fromFormName = curFromForm != null ? curFromForm.name() : null;
            String toFormName = curToForm != null ? curToForm.name() : null;
            ModPacketsS2CServer.sendTransformState(serverPlayer, transforming, fromFormName, toFormName);
            ShapeShifterCurseFabric.LOGGER.info("Sent transform state to client: " + transforming + ", from: " + fromFormName + ", to: " + toFormName);
        }
    }

    public static void handleProgressiveTransform(class_1657 player, boolean isByCursedMoon) {
        PlayerFormBase currentForm;
        _isByCursedMoon = isByCursedMoon;
        _isRegressedFromFinal = false;
        _isByCure = false;
        curFromForm = currentForm = ((PlayerFormComponent)player.getComponent(RegPlayerFormComponent.PLAYER_FORM)).getCurrentForm();
        ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCursedMoon(isByCursedMoon);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        FormAbilityManager.saveForm(player);
        ShapeShifterCurseFabric.LOGGER.info("Progressive transform started, isByCursedMoon: " + isByCursedMoon + ", from: " + String.valueOf(curFromForm));
        int currentFormIndex = currentForm.getIndex();
        PlayerFormGroup currentFormGroup = currentForm.getGroup();
        PlayerFormBase toForm = null;
        switch (currentFormIndex) {
            case -2: {
                break;
            }
            case -1: {
                toForm = TransformManager.getRandomOrBuffForm(player);
                ShapeShifterCurseFabric.ON_TRANSFORM_0.trigger((class_3222)player);
                break;
            }
            case 0: {
                toForm = currentFormGroup.getForm(1);
                break;
            }
            case 1: {
                toForm = currentFormGroup.getForm(2);
                break;
            }
            case 2: {
                if (isByCursedMoon) {
                    toForm = currentFormGroup.getForm(0);
                    _isRegressedFromFinal = true;
                    ShapeShifterCurseFabric.ON_TRIGGER_CURSED_MOON_FORM_2.trigger((class_3222)player);
                    break;
                }
                ShapeShifterCurseFabric.LOGGER.info("Triggered transformation when at max phase, this should not happen!");
                break;
            }
            case 3: {
                player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.on_cursed_moon_permanent").method_27692(class_124.field_1054));
                break;
            }
            case 5: {
                if (!isByCursedMoon) break;
                player.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.on_cursed_moon_special").method_27692(class_124.field_1054));
            }
        }
        if (toForm == null) {
            ShapeShifterCurseFabric.LOGGER.info("No next form found, unless you haven't unlock mod contents, then this should not happen!");
            return;
        }
        curPlayer = player;
        curToForm = toForm;
        ShapeShifterCurseFabric.LOGGER.info("Cur Player: " + String.valueOf(curPlayer) + " To Form: " + String.valueOf(curToForm));
        PlayerTransformEffectManager.applyStartTransformEffect((class_3222)player, 60);
        TransformManager.handleTransformEffect(player);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        FormAbilityManager.saveForm(player);
        MinecraftServer server = player.method_5682();
        TransformManager.syncCursedMoonData(player, server);
    }

    public static void handleMoonEndTransform(class_1657 player) {
        PlayerFormBase currentForm;
        curFromForm = currentForm = ((PlayerFormComponent)player.getComponent(RegPlayerFormComponent.PLAYER_FORM)).getCurrentForm();
        int currentFormIndex = currentForm.getIndex();
        PlayerFormGroup currentFormGroup = currentForm.getGroup();
        PlayerFormBase toForm = null;
        switch (currentFormIndex) {
            case -2: {
                ShapeShifterCurseFabric.LOGGER.error("Moon end transformation triggered when mod is not enabled, this should not happen!");
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                if (((PlayerFormComponent)player.getComponent(RegPlayerFormComponent.PLAYER_FORM)).isRegressedFromFinal()) {
                    toForm = currentFormGroup.getForm(2);
                    break;
                }
                toForm = RegPlayerForms.ORIGINAL_SHIFTER;
                break;
            }
            case 1: {
                toForm = currentFormGroup.getForm(0);
                break;
            }
            case 2: {
                toForm = currentFormGroup.getForm(1);
            }
            case 3: 
            case 5: {
                break;
            }
        }
        if (toForm == null) {
            ShapeShifterCurseFabric.LOGGER.info("No next form found, this should not happen!");
            return;
        }
        curPlayer = player;
        curToForm = toForm;
        ShapeShifterCurseFabric.LOGGER.info("Cur Player: " + String.valueOf(curPlayer) + " To Form: " + String.valueOf(curToForm));
        _isByCursedMoonEnd = true;
        _isByCursedMoon = true;
        ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCursedMoon(true);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        PlayerTransformEffectManager.applyStartTransformEffect((class_3222)player, 60);
        TransformManager.handleTransformEffect(player);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        ShapeShifterCurseFabric.LOGGER.info("Moon end transform\uff0c_isByCursedMoonEnd=" + _isByCursedMoonEnd + "\uff0ccomponent isByCursedMoon=" + ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).isByCursedMoon());
        MinecraftServer server = player.method_5682();
        TransformManager.syncCursedMoonData(player, server);
    }

    static PlayerFormBase getRandomOrBuffForm(class_1657 player) {
        PlayerEffectAttachment currentTransformEffect = EffectManager.getCurrentEffectAttachment(player);
        if (currentTransformEffect != null && currentTransformEffect.currentEffect != null) {
            return currentTransformEffect.currentToForm;
        }
        return FormRandomSelector.getRandomFormFromPredefined();
    }

    public static void update() {
        if (isEffectActive) {
            TransformManager.updateClientOverlayEffect();
            if (--beginTransformEffectTicks <= 0) {
                isEffectActive = false;
                isEndEffectActive = true;
                if (curPlayer != null) {
                    boolean isCursedMoonRelated;
                    boolean bl = isCursedMoonRelated = ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)curPlayer)).isByCursedMoon() || _isByCursedMoonEnd || _isByCursedMoon;
                    if (!isCursedMoonRelated) {
                        InstinctTicker.clearInstinct(curPlayer);
                    }
                    FormAbilityManager.applyForm(curPlayer, curToForm);
                    ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)curPlayer)).setRegressedFromFinal(_isRegressedFromFinal);
                    ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)curPlayer)).setByCure(_isByCure);
                    RegPlayerFormComponent.PLAYER_FORM.sync((Object)curPlayer);
                } else {
                    ShapeShifterCurseFabric.LOGGER.error("curPlayer is null when trying to apply form!");
                }
                PlayerTransformEffectManager.applyEndTransformEffect((class_3222)curPlayer, 100);
            }
        } else if (isEndEffectActive) {
            TransformManager.updateClientOverlayFadeEffect();
            if (--endTransformEffectTicks <= 0) {
                if (curFromForm.equals(RegPlayerForms.ORIGINAL_BEFORE_ENABLE)) {
                    curPlayer.method_43496((class_2561)class_2561.method_43471((String)"info.shape-shifter-curse.on_enable_mod_after").method_27692(class_124.field_1076));
                }
                TransformManager.sendClientTransformCompleteEffect();
                PlayerTransformEffectManager.applyFinaleTransformEffect((class_3222)curPlayer, 5);
                InstinctTicker.isPausing = false;
                if (_isByCursedMoonEnd) {
                    ShapeShifterCurseFabric.LOGGER.info("Finalizing moon end transform");
                    _isByCursedMoon = false;
                    ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)curPlayer)).setByCursedMoon(false);
                    RegPlayerFormComponent.PLAYER_FORM.sync((Object)curPlayer);
                    _isByCursedMoonEnd = false;
                }
                isTransforming = false;
                isEndEffectActive = false;
                beginTransformEffectTicks = 0;
                endTransformEffectTicks = 0;
                if (curPlayer != null) {
                    TransformManager.setTransformingState(false, curPlayer);
                }
            }
        }
    }

    private static void updateClientOverlayEffect() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            nauesaStrength = 1.0f - (float)beginTransformEffectTicks / 60.0f;
            blackStrength = nauesaStrength > 0.8f ? (nauesaStrength - 0.8f) / 0.2f : 0.0f;
            TransformOverlay.INSTANCE.setNauesaStrength(nauesaStrength);
            TransformOverlay.INSTANCE.setBlackStrength(blackStrength);
        } else if (curPlayer instanceof class_3222) {
            class_2540 buf = PacketByteBufs.create();
            buf.writeFloat(1.0f - (float)beginTransformEffectTicks / 60.0f);
            buf.writeInt(beginTransformEffectTicks);
            ServerPlayNetworking.send((class_3222)((class_3222)curPlayer), (class_2960)ModPackets.UPDATE_OVERLAY_EFFECT, (class_2540)buf);
        }
    }

    private static void updateClientOverlayFadeEffect() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            nauesaStrength = (float)endTransformEffectTicks / 100.0f;
            blackStrength = nauesaStrength > 0.6f ? 1.0f : nauesaStrength / 0.6f;
            TransformOverlay.INSTANCE.setNauesaStrength(nauesaStrength);
            TransformOverlay.INSTANCE.setBlackStrength(blackStrength);
        } else if (curPlayer instanceof class_3222) {
            class_2540 buf = PacketByteBufs.create();
            buf.writeFloat((float)endTransformEffectTicks / 100.0f);
            buf.writeInt(endTransformEffectTicks);
            ServerPlayNetworking.send((class_3222)((class_3222)curPlayer), (class_2960)ModPackets.UPDATE_OVERLAY_FADE_EFFECT, (class_2540)buf);
        }
    }

    private static void sendClientTransformCompleteEffect() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            TransformManager.executeClientTransformCompleteEffect();
        } else if (curPlayer instanceof class_3222) {
            class_2540 buf = PacketByteBufs.create();
            ServerPlayNetworking.send((class_3222)((class_3222)curPlayer), (class_2960)ModPackets.TRANSFORM_COMPLETE_EFFECT, (class_2540)buf);
        }
    }

    public static void executeClientTransformCompleteEffect() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        if (IS_FIRST_PERSON_MOD_LOADED) {
            FirstPersonModelCore fpm = FirstPersonModelCore.instance;
            fpm.getConfig().xOffset = 0;
            fpm.getConfig().sitXOffset = 0;
            fpm.getConfig().sneakXOffset = 0;
        }
        TransformOverlay.INSTANCE.setEnableOverlay(false);
    }

    public static void handleClientOverlayUpdate(float nauseaStrength, int ticks) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        nauesaStrength = nauseaStrength;
        blackStrength = nauesaStrength > 0.8f ? (nauesaStrength - 0.8f) / 0.2f : 0.0f;
        TransformOverlay.INSTANCE.setNauesaStrength(nauesaStrength);
        TransformOverlay.INSTANCE.setBlackStrength(blackStrength);
    }

    public static void handleClientOverlayFadeUpdate(float nauseaStrength, int ticks) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        nauesaStrength = nauseaStrength;
        blackStrength = nauesaStrength > 0.6f ? 1.0f : nauesaStrength / 0.6f;
        TransformOverlay.INSTANCE.setNauesaStrength(nauesaStrength);
        TransformOverlay.INSTANCE.setBlackStrength(blackStrength);
    }

    public static void handleDirectTransform(class_1657 player, PlayerFormBase toForm, boolean isByCure) {
        curPlayer = player;
        curToForm = toForm;
        curFromForm = ((PlayerFormComponent)player.getComponent(RegPlayerFormComponent.PLAYER_FORM)).getCurrentForm();
        _isByCure = isByCure;
        if (!CursedMoon.isCursedMoon(player.method_37908())) {
            _isByCure = false;
        }
        int toFormIndex = curToForm.getIndex();
        if (!isByCure) {
            switch (toFormIndex) {
                case 0: {
                    ShapeShifterCurseFabric.ON_TRANSFORM_0.trigger((class_3222)player);
                    break;
                }
                case 1: {
                    ShapeShifterCurseFabric.ON_TRANSFORM_1.trigger((class_3222)player);
                    break;
                }
                case 2: {
                    ShapeShifterCurseFabric.ON_TRANSFORM_2.trigger((class_3222)player);
                    break;
                }
            }
        }
        ShapeShifterCurseFabric.LOGGER.info("Cur Player: " + String.valueOf(curPlayer) + " To Form: " + String.valueOf(curToForm));
        TransformManager.handleTransformEffect(player);
        PlayerTransformEffectManager.applyStartTransformEffect((class_3222)player, 60);
        MinecraftServer server = player.method_5682();
        TransformManager.syncCursedMoonData(player, server);
    }

    private static void syncCursedMoonData(class_1657 player, MinecraftServer server) {
        ShapeShifterCurseFabric.LOGGER.info("Cursed moon data saved by syncCursedMoonData");
        ShapeShifterCurseFabric.cursedMoonData.getInstance().save(server.method_30002());
    }

    private static void handleTransformEffect(class_1657 player) {
        isTransforming = true;
        beginTransformEffectTicks = 60;
        endTransformEffectTicks = 100;
        isEffectActive = true;
        InstinctTicker.isPausing = true;
        TransformManager.setTransformingState(true, player);
        if (!player.method_37908().field_9236 && player instanceof class_3222) {
            class_2540 buf = PacketByteBufs.create();
            ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)ModPackets.TRANSFORM_EFFECT_ID, (class_2540)buf);
        }
    }

    public static void playClientTransformEffect() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        isTransforming = true;
        beginTransformEffectTicks = 60;
        endTransformEffectTicks = 100;
        isEffectActive = true;
        InstinctTicker.isPausing = true;
        ShapeShifterCurseFabricClient.emitTransformParticle(60);
        TransformFX.beginTransformEffect();
        TransformOverlay.INSTANCE.setEnableOverlay(true);
    }

    public static void setFormDirectly(class_1657 player, PlayerFormBase toForm) {
        curPlayer = player;
        curToForm = toForm;
        FormAbilityManager.applyForm(curPlayer, curToForm);
        TransformManager.clearFormFlag(curPlayer);
        InstinctTicker.clearInstinct(curPlayer);
        TransformManager.sendClientFirstPersonReset();
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)curPlayer);
        MinecraftServer server = player.method_5682();
        TransformManager.syncCursedMoonData(player, server);
    }

    private static void sendClientFirstPersonReset() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            TransformManager.executeClientFirstPersonReset();
        } else if (curPlayer instanceof class_3222) {
            class_2540 buf = PacketByteBufs.create();
            ServerPlayNetworking.send((class_3222)((class_3222)curPlayer), (class_2960)ModPackets.RESET_FIRST_PERSON, (class_2540)buf);
        }
    }

    public static void executeClientFirstPersonReset() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        if (IS_FIRST_PERSON_MOD_LOADED) {
            FirstPersonModelCore fpm = FirstPersonModelCore.instance;
            fpm.getConfig().xOffset = 0;
            fpm.getConfig().sitXOffset = 0;
            fpm.getConfig().sneakXOffset = 0;
            new Thread(() -> {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                fpm.getConfig().xOffset = 0;
                fpm.getConfig().sitXOffset = 0;
                fpm.getConfig().sneakXOffset = 0;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                fpm.getConfig().xOffset = 0;
                fpm.getConfig().sitXOffset = 0;
                fpm.getConfig().sneakXOffset = 0;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                fpm.getConfig().xOffset = 0;
                fpm.getConfig().sitXOffset = 0;
                fpm.getConfig().sneakXOffset = 0;
                try {
                    Thread.sleep(800L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                fpm.getConfig().xOffset = 0;
                fpm.getConfig().sitXOffset = 0;
                fpm.getConfig().sneakXOffset = 0;
            }).start();
        }
    }

    public static void clearFormFlag(class_1657 player) {
        boolean wasByCursedMoon = ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).isByCursedMoon();
        ShapeShifterCurseFabric.LOGGER.info("Clearing form flags, wasByCursedMoon: " + wasByCursedMoon + ", _isByCursedMoonEnd: " + _isByCursedMoonEnd);
        if (_isByCursedMoonEnd) {
            _isByCursedMoon = false;
            ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCursedMoon(false);
            ShapeShifterCurseFabric.LOGGER.info("Cleared cursed moon flag due to moon end");
        }
        _isRegressedFromFinal = false;
        _isByCure = false;
        _isByCursedMoonEnd = false;
        ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setRegressedFromFinal(false);
        ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCure(false);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
    }

    public static void setIsByCursedMoonEnd(boolean value) {
        _isByCursedMoonEnd = value;
        ShapeShifterCurseFabric.LOGGER.info("\u8bbe\u7f6e_isByCursedMoonEnd=" + value);
    }

    public static void clearMoonEndFlags(class_1657 player) {
        ShapeShifterCurseFabric.LOGGER.info("\u5b89\u5168\u6e05\u9664\u6708\u4eae\u7ed3\u675f\u6807\u8bb0");
        boolean wasByCursedMoon = ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).isByCursedMoon();
        if (_isByCursedMoonEnd) {
            ShapeShifterCurseFabric.LOGGER.info("Clearing moon end flags (instinct should be preserved)");
            _isByCursedMoon = false;
            _isByCursedMoonEnd = false;
            ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCursedMoon(false);
            RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        }
        _isRegressedFromFinal = false;
        _isByCure = false;
        ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setRegressedFromFinal(false);
        ((PlayerFormComponent)RegPlayerFormComponent.PLAYER_FORM.get((Object)player)).setByCure(false);
        RegPlayerFormComponent.PLAYER_FORM.sync((Object)player);
        ShapeShifterCurseFabric.LOGGER.info("\u6708\u4eae\u6807\u8bb0\u5df2\u6e05\u9664\uff0c\u539f\u72b6\u6001\uff1a" + wasByCursedMoon);
    }
}

