/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.status_effects;

import java.util.Objects;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.form_giving_custom_entity.axolotl.TransformativeAxolotlEntity;
import net.onixary.shapeShifterCurseFabric.form_giving_custom_entity.bat.TransformativeBatEntity;
import net.onixary.shapeShifterCurseFabric.form_giving_custom_entity.ocelot.TransformativeOcelotEntity;
import net.onixary.shapeShifterCurseFabric.player_form.PlayerFormBase;
import net.onixary.shapeShifterCurseFabric.player_form.RegPlayerForms;
import net.onixary.shapeShifterCurseFabric.player_form.ability.FormAbilityManager;
import net.onixary.shapeShifterCurseFabric.status_effects.BaseTransformativeStatusEffect;
import net.onixary.shapeShifterCurseFabric.status_effects.RegTStatusEffect;
import net.onixary.shapeShifterCurseFabric.status_effects.attachment.EffectManager;
import net.onixary.shapeShifterCurseFabric.status_effects.attachment.PlayerEffectAttachment;

public class TStatusApplier {
    public static float T_BAT_STATUS_CHANCE = 0.5f;
    public static float T_AXOLOTL_STATUS_CHANCE = 0.7f;
    public static float T_OCELOT_STATUS_CHANCE = 0.5f;

    private TStatusApplier() {
    }

    public static void applyStatusFromTMob(class_1308 fromMob, class_1657 player) {
        if (fromMob instanceof TransformativeBatEntity) {
            TStatusApplier.applyStatusByChance(T_BAT_STATUS_CHANCE, player, RegTStatusEffect.TO_BAT_0_EFFECT);
        } else if (fromMob instanceof TransformativeAxolotlEntity) {
            TStatusApplier.applyStatusByChance(T_AXOLOTL_STATUS_CHANCE, player, RegTStatusEffect.TO_AXOLOTL_0_EFFECT);
        } else if (fromMob instanceof TransformativeOcelotEntity) {
            TStatusApplier.applyStatusByChance(T_OCELOT_STATUS_CHANCE, player, RegTStatusEffect.TO_OCELOT_0_EFFECT);
        }
    }

    private static void applyStatusByChance(float chance, class_1657 player, BaseTransformativeStatusEffect regStatusEffect) {
        PlayerFormBase curToForm = Objects.requireNonNull((PlayerEffectAttachment)player.getAttached(EffectManager.EFFECT_ATTACHMENT)).currentToForm;
        ShapeShifterCurseFabric.LOGGER.info("current dest form: " + String.valueOf(curToForm) + " when applyStatusByChance");
        if (player.getAttached(EffectManager.EFFECT_ATTACHMENT) == null) {
            ShapeShifterCurseFabric.LOGGER.info("attach is null when applyStatusByChance");
        }
        if (Math.random() < (double)chance && !RegPlayerForms.IsPlayerFormEqual(curToForm, regStatusEffect.getToForm()).booleanValue() && FormAbilityManager.getForm(player).equals(RegPlayerForms.ORIGINAL_SHIFTER)) {
            ShapeShifterCurseFabric.LOGGER.info("TStatusApplier applyStatusByChance");
            EffectManager.overrideEffect(player, regStatusEffect);
        }
    }
}

