/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.additional_power;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_243;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;

public class ProjectileDodgePower
extends Power {
    private final ActionFactory.Instance action;
    private final Predicate<class_1297> entityCondition;
    private final double range;
    private final double dodgeSpeed;
    private final double triggerDistance;
    private final int cooldown;
    private int timer;
    private boolean dodgeRight;

    public ProjectileDodgePower(PowerType<?> type, class_1309 entity, ActionFactory.Instance action, Predicate<class_1297> entityCondition, double range, double dodgeSpeed, double triggerDistance, int cooldown) {
        super(type, entity);
        this.action = action;
        this.entityCondition = entityCondition;
        this.range = range;
        this.dodgeSpeed = dodgeSpeed;
        this.triggerDistance = triggerDistance;
        this.cooldown = cooldown;
        this.timer = 0;
        this.dodgeRight = true;
        this.setTicking(true);
    }

    public void tick() {
        class_1657 player;
        class_1309 class_13092 = this.entity;
        if (!(class_13092 instanceof class_1657) || (player = (class_1657)class_13092).method_7325()) {
            return;
        }
        if (player.method_37908().method_8608()) {
            return;
        }
        if (!this.entityCondition.test((class_1297)player)) {
            return;
        }
        List projectiles = player.method_37908().method_8390(class_1676.class, player.method_5829().method_1014(this.range), projectile -> {
            double movement;
            class_243 prevPos;
            if (projectile.method_24921() == player) {
                return false;
            }
            if (projectile.method_24828()) {
                return false;
            }
            class_243 class_2432 = prevPos = projectile.field_6014 != 0.0 ? new class_243(projectile.field_6014, projectile.field_6036, projectile.field_5969) : null;
            return prevPos == null || !((movement = prevPos.method_1022(projectile.method_19538())) < 0.1);
        });
        if (this.timer > 0) {
            --this.timer;
        }
        for (class_1676 projectile2 : projectiles) {
            if (!this.isProjectileApproaching(projectile2, player)) continue;
            if (this.timer > 0) break;
            this.performDodge(player, projectile2);
            this.timer = this.cooldown;
            break;
        }
    }

    private boolean isProjectileApproaching(class_1676 projectile, class_1657 player) {
        class_243 projectileVelocity;
        double distance = projectile.method_19538().method_1022(player.method_19538());
        if (distance > this.triggerDistance) {
            return false;
        }
        class_243 toPlayer = player.method_19538().method_1020(projectile.method_19538()).method_1029();
        double dot = toPlayer.method_1026(projectileVelocity = projectile.method_18798().method_1029());
        return dot > 0.7;
    }

    private void performDodge(class_1657 player, class_1676 projectile) {
        class_243 projectileVel = projectile.method_18798();
        class_243 horizontalVel = new class_243(projectileVel.field_1352, 0.0, projectileVel.field_1350).method_1029();
        this.dodgeRight = !this.dodgeRight;
        class_243 dodgeDirection = this.dodgeRight ? new class_243(-horizontalVel.field_1350, 0.0, horizontalVel.field_1352).method_1029() : new class_243(horizontalVel.field_1350, 0.0, -horizontalVel.field_1352).method_1029();
        ShapeShifterCurseFabric.LOGGER.info("\u6b63\u5728\u8eb2\u907f\u6295\u5c04\u7269: " + String.valueOf(projectile.method_5667()));
        player.method_45319(dodgeDirection.method_1021(this.dodgeSpeed));
        player.field_6037 = true;
        if (this.action != null) {
            this.action.accept((Object)player);
        }
    }

    public static PowerFactory<?> createFactory() {
        return new PowerFactory(ShapeShifterCurseFabric.identifier("projectile_dodge"), new SerializableData().add("action", ApoliDataTypes.ENTITY_ACTION, null).add("entity_condition", ApoliDataTypes.ENTITY_CONDITION, null).add("range", SerializableDataTypes.DOUBLE, (Object)5.0).add("dodge_speed", SerializableDataTypes.DOUBLE, (Object)1.0).add("trigger_distance", SerializableDataTypes.DOUBLE, (Object)4.0).add("cooldown", SerializableDataTypes.INT, (Object)20), data -> (powerType, entity) -> new ProjectileDodgePower((PowerType<?>)powerType, (class_1309)entity, (ActionFactory.Instance)data.get("action"), (Predicate)data.get("entity_condition"), data.getDouble("range"), data.getDouble("dodge_speed"), data.getDouble("trigger_distance"), data.getInt("cooldown"))).allowCondition();
    }
}

