/*
 * Decompiled with CFR 0.152.
 */
package net.onixary.shapeShifterCurseFabric.util;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.onixary.shapeShifterCurseFabric.ShapeShifterCurseFabric;
import net.onixary.shapeShifterCurseFabric.player_form_render.OriginFurModel;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class FormTextureUtils {
    public static class_2960 getColorMask_Texture(OriginFurModel model) {
        String MaskIDStr = class_3518.method_15253((JsonObject)model.json, (String)"texture_mask", null);
        return MaskIDStr == null ? null : class_2960.method_12829((String)MaskIDStr);
    }

    public static class_2960 getColorMask_OverlayTexture(OriginFurModel model, boolean Slim) {
        String MaskIDStr = null;
        MaskIDStr = !Slim ? class_3518.method_15253((JsonObject)model.json, (String)"overlay_mask", null) : class_3518.method_15253((JsonObject)model.json, (String)"overlay_slim_mask", null);
        return MaskIDStr == null ? null : class_2960.method_12829((String)MaskIDStr);
    }

    public static class_2960 getColorMask_EmissiveTexture(OriginFurModel model, boolean Slim) {
        String MaskIDStr = null;
        MaskIDStr = !Slim ? class_3518.method_15253((JsonObject)model.json, (String)"emissive_overlay_mask", null) : class_3518.method_15253((JsonObject)model.json, (String)"emissive_overlay_slim_mask", null);
        return MaskIDStr == null ? null : class_2960.method_12829((String)MaskIDStr);
    }

    public static class_1011 toNativeImage(class_2960 texture) {
        class_1011 nativeImage = null;
        class_3300 RM = class_310.method_1551().method_1478();
        class_3298 resource = null;
        try {
            resource = RM.getResourceOrThrow(texture);
            InputStream inputStream = resource.method_14482();
            nativeImage = class_1011.method_4309((InputStream)inputStream);
        }
        catch (IOException e) {
            ShapeShifterCurseFabric.LOGGER.warn("Failed to load texture: " + String.valueOf(texture));
        }
        return nativeImage;
    }

    public static int RGBA2ABGR(int color) {
        int R = color >> 24 & 0xFF;
        int G = color >> 16 & 0xFF;
        int B = color >> 8 & 0xFF;
        int A = color & 0xFF;
        return A << 24 | B << 16 | G << 8 | R;
    }

    public static int RGB2ABGR(int color) {
        return FormTextureUtils.RGBA2ABGR(color << 8 | 0xFF);
    }

    public static int ABGR2RGBA(int color) {
        int R = color & 0xFF;
        int G = color >> 8 & 0xFF;
        int B = color >> 16 & 0xFF;
        int A = color >> 24 & 0xFF;
        return R << 24 | G << 16 | B << 8 | A;
    }

    public static int ABGR2RGB(int color) {
        return FormTextureUtils.ABGR2RGBA(color) >> 8;
    }

    public static int ColorMulBytes(int ColorA, int Bytes) {
        return ColorA & 0xFF000000 | (ColorA >> 16 & 0xFF) * Bytes / 255 << 16 | (ColorA >> 8 & 0xFF) * Bytes / 255 << 8 | (ColorA & 0xFF) * Bytes / 255;
    }

    public static int GreyScaleMul(int Color2, float GreyScale) {
        int R = Math.min(255, Math.max((int)(GreyScale * (float)(Color2 & 0xFF)), 0));
        int G = Math.min(255, Math.max((int)(GreyScale * (float)(Color2 >> 8 & 0xFF)), 0));
        int B = Math.min(255, Math.max((int)(GreyScale * (float)(Color2 >> 16 & 0xFF)), 0));
        return 0xFF000000 | B << 16 | G << 8 | R;
    }

    public static int getGreyScale(int color) {
        int R = color >> 16 & 0xFF;
        int G = color >> 8 & 0xFF;
        int B = color & 0xFF;
        return R * 28 + G * 151 + B * 77 >> 8;
    }

    public static int overrideGreyScale(int a, int b, float t) {
        return Math.min(a + (int)(t * (float)b), 255);
    }

    public static Triple<Integer, Integer, Integer> getAverageGreyScale(class_1011 image, class_1011 maskImage) {
        int textureWidth = image.method_4307();
        int textureHeight = image.method_4323();
        long R = 0L;
        long G = 0L;
        long B = 0L;
        int RC = 0;
        int GC = 0;
        int BC = 0;
        for (int x = 0; x < textureWidth; ++x) {
            for (int y = 0; y < textureHeight; ++y) {
                int Mask = maskImage.method_4315(x, y);
                if ((Mask & 0xFF0000) > 0) {
                    B += (long)FormTextureUtils.getGreyScale(image.method_4315(x, y));
                    ++BC;
                    continue;
                }
                if ((Mask & 0xFF00) > 0) {
                    G += (long)FormTextureUtils.getGreyScale(image.method_4315(x, y));
                    ++GC;
                    continue;
                }
                if ((Mask & 0xFF) <= 0) continue;
                R += (long)FormTextureUtils.getGreyScale(image.method_4315(x, y));
                ++RC;
            }
        }
        return new ImmutableTriple((Object)(RC == 0 ? 255 : (int)R / RC), (Object)(GC == 0 ? 255 : (int)G / GC), (Object)(BC == 0 ? 255 : (int)B / BC));
    }

    public static int ProcessMaskChannel(int Color2, int Mask, int ColorSetting2, int AverageGreyScale, boolean ReverseGreyScale) {
        int GreyScaleAdd = ReverseGreyScale ? AverageGreyScale - FormTextureUtils.getGreyScale(Color2) : FormTextureUtils.getGreyScale(Color2) - AverageGreyScale;
        Color2 = FormTextureUtils.GreyScaleMul(ColorSetting2, 1.0f + (float)GreyScaleAdd / 255.0f);
        return FormTextureUtils.ColorMulBytes(Color2, Mask);
    }

    public static int ProcessPixel(int Color2, int Mask, ColorSetting colorSetting, Triple<Integer, Integer, Integer> MaskLayerAverageGreyScale) {
        int maskAlpha = Mask & 0xFF000000;
        if (maskAlpha >= 0 && maskAlpha < 16) {
            return colorSetting.eyeColor & 0xFFFFFF | Color2 & 0xFF000000;
        }
        if (Mask == 0) {
            return Color2;
        }
        int B = Mask >> 16 & 0xFF;
        if (B > 0) {
            int result = FormTextureUtils.ProcessMaskChannel(Color2, B, colorSetting.accentColor2, (Integer)MaskLayerAverageGreyScale.getRight(), colorSetting.accent2GreyReverse);
            return result & 0xFFFFFF | Color2 & 0xFF000000;
        }
        int G = Mask >> 8 & 0xFF;
        if (G > 0) {
            int result = FormTextureUtils.ProcessMaskChannel(Color2, G, colorSetting.accentColor1, (Integer)MaskLayerAverageGreyScale.getMiddle(), colorSetting.accent1GreyReverse);
            return result & 0xFFFFFF | Color2 & 0xFF000000;
        }
        int R = Mask & 0xFF;
        if (R > 0) {
            int result = FormTextureUtils.ProcessMaskChannel(Color2, R, colorSetting.primaryColor, (Integer)MaskLayerAverageGreyScale.getLeft(), colorSetting.primaryGreyReverse);
            return result & 0xFFFFFF | Color2 & 0xFF000000;
        }
        return Color2;
    }

    public static class_2960 BakeTexture(class_2960 texture, class_2960 mask, ColorSetting colorSetting) {
        if (texture == null || mask == null) {
            return null;
        }
        class_1011 textureImage = FormTextureUtils.toNativeImage(texture);
        class_1011 maskImage = FormTextureUtils.toNativeImage(mask);
        int textureWidth = textureImage.method_4307();
        int textureHeight = textureImage.method_4323();
        Triple<Integer, Integer, Integer> MaskLayerAverageGreyScale = FormTextureUtils.getAverageGreyScale(textureImage, maskImage);
        for (int x = 0; x < textureWidth; ++x) {
            for (int y = 0; y < textureHeight; ++y) {
                textureImage.method_4305(x, y, FormTextureUtils.ProcessPixel(textureImage.method_4315(x, y), maskImage.method_4315(x, y), colorSetting, MaskLayerAverageGreyScale));
            }
        }
        class_1060 TM = class_310.method_1551().method_1531();
        return TM.method_4617("masked_texture", new class_1043(textureImage));
    }

    public static class_2960 getBakedTexture(OriginFurModel model, ColorSetting colorSetting) {
        class_2960 CachedTexture = model.ColorMask_Baked_Textures.get(colorSetting);
        if (CachedTexture != null) {
            return CachedTexture;
        }
        CachedTexture = FormTextureUtils.BakeTexture(OriginFurModel.dTR(model.json), FormTextureUtils.getColorMask_Texture(model), colorSetting);
        if (CachedTexture == null) {
            CachedTexture = OriginFurModel.dTR(model.json);
        }
        model.ColorMask_Baked_Textures.put(colorSetting, CachedTexture);
        return CachedTexture;
    }

    public static class_2960 getBakedOverlayTexture(OriginFurModel model, ColorSetting colorSetting, boolean Slim) {
        if (!Slim) {
            class_2960 CachedTexture = model.ColorMask_Baked_OverlayTexture.get(colorSetting);
            if (CachedTexture != null) {
                return CachedTexture;
            }
            CachedTexture = FormTextureUtils.BakeTexture(class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"overlay", null)), FormTextureUtils.getColorMask_OverlayTexture(model, Slim), colorSetting);
            if (CachedTexture == null) {
                CachedTexture = class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"overlay", null));
            }
            model.ColorMask_Baked_OverlayTexture.put(colorSetting, CachedTexture);
            return CachedTexture;
        }
        class_2960 CachedTexture = model.ColorMask_Baked_OverlayTexture_Slim.get(colorSetting);
        if (CachedTexture != null) {
            return CachedTexture;
        }
        CachedTexture = FormTextureUtils.BakeTexture(class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"overlay_slim", null)), FormTextureUtils.getColorMask_OverlayTexture(model, Slim), colorSetting);
        if (CachedTexture == null) {
            CachedTexture = class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"overlay_slim", null));
        }
        model.ColorMask_Baked_OverlayTexture_Slim.put(colorSetting, CachedTexture);
        return CachedTexture;
    }

    public static class_2960 getBakedEmissiveTexture(OriginFurModel model, ColorSetting colorSetting, boolean Slim) {
        if (!Slim) {
            class_2960 CachedTexture = model.ColorMask_Baked_EmissiveTexture.get(colorSetting);
            if (CachedTexture != null) {
                return CachedTexture;
            }
            CachedTexture = FormTextureUtils.BakeTexture(class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"emissive_overlay", null)), FormTextureUtils.getColorMask_EmissiveTexture(model, Slim), colorSetting);
            if (CachedTexture == null) {
                CachedTexture = class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"emissive_overlay", null));
            }
            model.ColorMask_Baked_EmissiveTexture.put(colorSetting, CachedTexture);
            return CachedTexture;
        }
        class_2960 CachedTexture = model.ColorMask_Baked_EmissiveTexture_Slim.get(colorSetting);
        if (CachedTexture != null) {
            return CachedTexture;
        }
        CachedTexture = FormTextureUtils.BakeTexture(class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"emissive_overlay_slim", null)), FormTextureUtils.getColorMask_EmissiveTexture(model, Slim), colorSetting);
        if (CachedTexture == null) {
            CachedTexture = class_2960.method_12829((String)class_3518.method_15253((JsonObject)model.json, (String)"emissive_overlay_slim", null));
        }
        model.ColorMask_Baked_EmissiveTexture_Slim.put(colorSetting, CachedTexture);
        return CachedTexture;
    }

    public record ColorSetting(int primaryColor, int accentColor1, int accentColor2, int eyeColor, boolean primaryGreyReverse, boolean accent1GreyReverse, boolean accent2GreyReverse) {
        public int getPrimaryColor() {
            return this.primaryColor;
        }

        public int getAccentColor1() {
            return this.accentColor1;
        }

        public int getAccentColor2() {
            return this.accentColor2;
        }

        public int getEyeColor() {
            return this.eyeColor;
        }

        public boolean getPrimaryGreyReverse() {
            return this.primaryGreyReverse;
        }

        public boolean getAccent1GreyReverse() {
            return this.accent1GreyReverse;
        }

        public boolean getAccent2GreyReverse() {
            return this.accent2GreyReverse;
        }
    }
}

