/*
 * Decompiled with CFR 0.152.
 */
package me.lennyd.antispawn.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import me.lennyd.antispawn.Util;
import me.lennyd.antispawn.antispawn;
import me.lennyd.antispawn.config.ConfigManager;
import me.lennyd.antispawn.config.ConfigRegion;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class MainCommandRegister {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"antispawn").then(class_2170.method_9247((String)"info").executes(commandContext -> {
            class_5250 output = class_2561.method_43470((String)"");
            output.method_10852(Util.formatInfo("antispawn v1.1, by 01lenny\n"));
            output.method_10852(Util.formatInfo("https://github.com/infinity-atom/antispawn\n"));
            output.method_10852(Util.formatInfo("https://modrinth.com/project/antispawn"));
            ((class_2168)commandContext.getSource()).method_45068((class_2561)output);
            return 1;
        }))).then(class_2170.method_9247((String)"check").executes(commandContext -> {
            if (!((class_2168)commandContext.getSource()).method_43737()) {
                ((class_2168)commandContext.getSource()).method_45068(Util.formatError("Only players can execute this command!"));
                return 1;
            }
            for (ConfigRegion region : antispawn.CF.regions) {
                if (!Objects.equals(region.dimension, ((class_2168)commandContext.getSource()).method_44023().method_51469().method_27983().method_29177().toString()) || !Util.isInsideBox(((class_2168)commandContext.getSource()).method_44023().method_24515(), new class_2338(region.corner1X, region.corner1Y, region.corner1Z), new class_2338(region.corner2X, region.corner2Y, region.corner2Z))) continue;
                ((class_2168)commandContext.getSource()).method_45068(Util.formatInfo("You are inside the region " + region.id));
                return 1;
            }
            ((class_2168)commandContext.getSource()).method_45068(Util.formatError("You weren't detected to be in any region"));
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(s -> s.method_9259(3))).executes(commandContext -> {
            class_5250 output = class_2561.method_43470((String)"");
            output.method_10852(Util.formatInfo(antispawn.CF.regions.size() + " region(s) found in config\n"));
            for (ConfigRegion region : antispawn.CF.regions) {
                output.method_10852(Util.formatInfo(String.format("%s from %s %s %s to %s %s %s\n", region.id, region.corner1X, region.corner1Y, region.corner1Z, region.corner2X, region.corner2Y, region.corner2Z)));
            }
            output.method_10852(Util.formatInfo("End of list"));
            ((class_2168)commandContext.getSource()).method_9226(() -> output, false);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(s -> s.method_9259(3))).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"corner1", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"corner2", (ArgumentType)class_2262.method_9698()).executes(commandContext -> {
            String id = StringArgumentType.getString((CommandContext)commandContext, (String)"id");
            for (ConfigRegion region : antispawn.CF.regions) {
                if (!region.id.equals(id)) continue;
                ((class_2168)commandContext.getSource()).method_9226(() -> Util.formatError("Another region already exists with this ID!"), true);
                return 0;
            }
            class_2338 corner1 = class_2262.method_48299((CommandContext)commandContext, (String)"corner1");
            class_2338 corner2 = class_2262.method_48299((CommandContext)commandContext, (String)"corner2");
            ConfigRegion r = new ConfigRegion();
            r.id = id;
            r.corner1X = corner1.method_10263();
            r.corner1Y = corner1.method_10264();
            r.corner1Z = corner1.method_10260();
            r.corner2X = corner2.method_10263();
            r.corner2Y = corner2.method_10264();
            r.corner2Z = corner2.method_10260();
            r.dimension = ((class_2168)commandContext.getSource()).method_44023().method_51469().method_27983().method_29177().toString();
            antispawn.CF.regions.add(r);
            ConfigManager.save();
            ((class_2168)commandContext.getSource()).method_9226(() -> Util.formatInfo("Created region " + id), true);
            return 1;
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(s -> s.method_9259(3))).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).suggests((commandContext, suggestionsBuilder) -> {
            for (ConfigRegion region : antispawn.CF.regions) {
                suggestionsBuilder.suggest(region.id);
            }
            return suggestionsBuilder.buildFuture();
        }).executes(commandContext -> {
            String id = StringArgumentType.getString((CommandContext)commandContext, (String)"id");
            boolean removed = antispawn.CF.regions.removeIf(r -> r.id.equals(id));
            if (removed) {
                ((class_2168)commandContext.getSource()).method_9226(() -> Util.formatInfo("Removed region " + id), true);
                ConfigManager.save();
            } else {
                ((class_2168)commandContext.getSource()).method_9226(() -> Util.formatError("Could not remove region " + id), true);
            }
            return removed ? 1 : 0;
        }))));
    }
}

