/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.tntarrows;

import com.google.common.collect.MapMaker;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;

public class FakePlayer
extends ServerPlayer {
    public static final UUID DEFAULT_UUID = UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77");
    private static final Map<FakePlayerKey, FakePlayer> FAKE_PLAYER_MAP = new MapMaker().weakValues().makeMap();

    public static FakePlayer get(ServerLevel world, String name) {
        return FakePlayer.get(world, new GameProfile(DEFAULT_UUID, name));
    }

    public static FakePlayer get(ServerLevel world, GameProfile profile) {
        Objects.requireNonNull(world, "World may not be null.");
        Objects.requireNonNull(profile, "Game profile may not be null.");
        return FAKE_PLAYER_MAP.computeIfAbsent(new FakePlayerKey(world, profile), key -> new FakePlayer(key.world, key.profile));
    }

    protected FakePlayer(ServerLevel world, GameProfile profile) {
        super(world.getServer(), world, profile, ClientInformation.createDefault());
        this.connection = new FakePlayerNetworkHandler(this);
    }

    private record FakePlayerKey(ServerLevel world, GameProfile profile) {
    }

    public static final class FakePlayerNetworkHandler
    extends ServerGamePacketListenerImpl {
        private static final Connection FAKE_CONNECTION = new FakeClientConnection();

        public FakePlayerNetworkHandler(ServerPlayer player) {
            super(player.getServer(), FAKE_CONNECTION, player, CommonListenerCookie.createInitial((GameProfile)player.getGameProfile(), (boolean)false));
        }

        private static final class FakeClientConnection
        extends Connection {
            private FakeClientConnection() {
                super(PacketFlow.CLIENTBOUND);
            }
        }
    }
}

