/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.tntarrows;

import io.github.discusser.tntarrows.TNTArrowProjectile;
import io.github.discusser.tntarrows.TNTArrows;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TNTArrowItem
extends ArrowItem {
    public TNTArrowItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public static Component getTntComponent(ItemStack itemStack) {
        return TNTArrowItem.getTntComponent((ResourceLocation)itemStack.get((DataComponentType)TNTArrows.DATA_TNT_BLOCK.get()));
    }

    @Nullable
    public static Component getTntComponent(ResourceLocation tntBlock) {
        if (tntBlock != null) {
            int color = MapColor.COLOR_RED.col;
            Optional tnt = BuiltInRegistries.BLOCK.get(tntBlock);
            if (tnt.isPresent()) {
                color = ((Block)((Holder.Reference)tnt.get()).value()).defaultMapColor().col;
            }
            int finalColor = color;
            return Component.translatable((String)("block." + tntBlock.toLanguageKey())).withStyle(style -> style.withColor(finalColor));
        }
        return null;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        itemStack.addToTooltip(DataComponents.INSTRUMENT, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
        super.appendHoverText(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
    }

    @NotNull
    public Component getName(ItemStack itemStack) {
        MutableComponent main = super.getName(itemStack).copy();
        Component comp = TNTArrowItem.getTntComponent(itemStack);
        if (comp != null) {
            main.append(" (");
            main.append(comp);
            main.append(")");
        }
        return main;
    }

    @NotNull
    public Component getName(ResourceLocation tntBlock) {
        ItemStack itemStack = new ItemStack(TNTArrows.TNT_ARROW, 1, DataComponentPatch.builder().set((DataComponentType)TNTArrows.DATA_TNT_BLOCK.get(), (Object)tntBlock).build());
        return this.getName(itemStack);
    }

    @NotNull
    public AbstractArrow createArrow(Level level, ItemStack itemStack, LivingEntity livingEntity, @Nullable ItemStack itemStack2) {
        return new TNTArrowProjectile(level, livingEntity, itemStack.copyWithCount(1), itemStack2);
    }

    @NotNull
    public Projectile asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        TNTArrowProjectile arrow = new TNTArrowProjectile(level, position.x(), position.y(), position.z(), itemStack.copyWithCount(1), null);
        arrow.pickup = AbstractArrow.Pickup.ALLOWED;
        return arrow;
    }
}

