/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.tntarrows;

import io.github.discusser.tntarrows.FakePlayer;
import io.github.discusser.tntarrows.TNTArrowItem;
import io.github.discusser.tntarrows.TNTArrows;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TNTArrowProjectile
extends AbstractArrow {
    @Nullable
    private TntBlock tntBlock;

    public TNTArrowProjectile(EntityType<? extends AbstractArrow> entityType, Level level, ItemStack itemStack) {
        super(entityType, level);
        this.setTntBlock(itemStack);
    }

    public TNTArrowProjectile(Level level, double d, double e, double f, ItemStack itemStack, @Nullable ItemStack itemStack2) {
        super(EntityType.ARROW, d, e, f, level, itemStack, itemStack2);
        this.setTntBlock(itemStack);
    }

    public TNTArrowProjectile(Level level, LivingEntity livingEntity, ItemStack itemStack, @Nullable ItemStack itemStack2) {
        super(EntityType.ARROW, livingEntity, level, itemStack, itemStack2);
        this.setTntBlock(itemStack);
    }

    public void setTntBlock(ItemStack itemStack) {
        this.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        this.setBaseDamage(0.0);
        ResourceLocation location = (ResourceLocation)itemStack.get((DataComponentType)TNTArrows.DATA_TNT_BLOCK.get());
        if (location == null) {
            this.tntBlock = null;
            return;
        }
        try {
            this.tntBlock = (TntBlock)BuiltInRegistries.BLOCK.getValue(location);
        }
        catch (ClassCastException e) {
            TNTArrows.LOGGER.warning("Tried creating a TNT arrow that has an invalid TNT block: " + String.valueOf(location));
            this.tntBlock = null;
        }
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public void explode(HitResult hitResult) {
        try {
            if (!(hitResult.getType() != HitResult.Type.BLOCK && hitResult.getType() != HitResult.Type.ENTITY || this.level().isClientSide || this.tntBlock == null)) {
                FakePlayer player = FakePlayer.get((ServerLevel)this.level(), ((TNTArrowItem)((Object)TNTArrows.TNT_ARROW.get())).getName(this.tntBlock.arch$registryName()).getString());
                player.getInventory().setItem(0, new ItemStack((ItemLike)Items.FIRE_CHARGE));
                BlockHitResult blockHitResult = new BlockHitResult(hitResult.getLocation(), Direction.NORTH, this.blockPosition(), false);
                BlockPos pos = blockHitResult.getBlockPos();
                if (!this.level().isEmptyBlock(pos)) {
                    for (Direction direction : Direction.values()) {
                        if (!this.level().isEmptyBlock(pos.relative(direction))) continue;
                        pos = pos.relative(direction);
                        break;
                    }
                }
                BlockState blockState = this.tntBlock.defaultBlockState();
                this.level().setBlock(pos, blockState, 11);
                this.tntBlock.useItemOn(player.getInventory().getItem(0), blockState, this.level(), pos, (Player)player, InteractionHand.MAIN_HAND, blockHitResult);
                player.getInventory().setItem(0, ItemStack.EMPTY);
                PrimedTnt entity = (PrimedTnt)this.level().getEntity(ENTITY_COUNTER.get());
                if (entity != null) {
                    entity.setFuse(0);
                }
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
        catch (ClassCastException e) {
            if (this.tntBlock != null) {
                TNTArrows.LOGGER.warning("Tried exploding a TNT arrow that has an invalid TNT block: " + String.valueOf(this.tntBlock.arch$registryName()));
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void onHit(HitResult hitResult) {
        this.explode(hitResult);
    }
}

